package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.Bill;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

/**
 * Dialog that shows the current bill values set.
 */
public class BillValuesDialog extends javax.swing.JDialog {

    TestGUI gui;
    List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();

    /** Creates new form BillValuesDialog
     * @param parent
     * @param modal
     */
    public BillValuesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.gui = (TestGUI) parent;
        List<Bill> bills = gui.getAcceptor().getBillValues();
        List<Boolean> billsEnable = gui.getAcceptor().getBillValueEnables();
        createHeader();
        int counter = 0;
        for (Bill b : bills) {
            createBillComponents(b, counter);
            counter++;
        }
        counter = 0;
        for (Boolean b : billsEnable) {
            checkBoxes.get(counter).setSelected(b);
            counter++;
        }
        addListeners();
        pack();
    }

    private void addListeners() {
        for (JCheckBox cb : checkBoxes) {
            cb.addItemListener(new java.awt.event.ItemListener() {

                public void itemStateChanged(java.awt.event.ItemEvent evt) {
                    List<Boolean> bills = gui.getAcceptor().getBillValueEnables();
                    bills.set(Integer.parseInt(((JCheckBox) evt.getSource()).getActionCommand()), evt.getStateChange() == ItemEvent.SELECTED);
                    System.out.println("setting " + (evt.getStateChange() == ItemEvent.SELECTED) + " to " + ((JCheckBox) evt.getSource()).getActionCommand());
                    try{ gui.getAcceptor().setBillValueEnables(bills); } catch (Exception ex) {  System.out.println("Exception with setting bills: " + ex.getMessage()); }

                }
            });
        }
    }

    private void createBillComponents(Bill b, int index) {
        JCheckBox cb = new JCheckBox();
        cb.setActionCommand(String.valueOf(index));
        JLabel lNumber = new JLabel();
        JLabel lValue = new JLabel();
        JLabel lIsoCode = new JLabel();
        JLabel lAttributes = new JLabel();
        GridBagConstraints gbc = new GridBagConstraints();
        Insets i = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = index + 1;
        gbc.insets = i;
        pMain.add(cb, gbc);
        lNumber.setText(String.valueOf(index + 1));
        gbc.gridx = 1;
        pMain.add(lNumber, gbc);
        gbc.gridx = 2;
        lIsoCode.setText(b.getCountry());
        pMain.add(lIsoCode, gbc);
        gbc.gridx = 3;
        lValue.setText(String.valueOf(b.getValue()));
        pMain.add(lValue, gbc);
        gbc.gridx = 4;
        lAttributes.setText((char) b.getType() + " " + (char) b.getSeries() + " " + (char) b.getCompatibility() + " " + (char) b.getVersion());
        pMain.add(lAttributes, gbc);
        checkBoxes.add(cb);
    }

    private void createHeader() {
        //JPanel headerPanel = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        Insets i = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = i;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        pMain.add(new JLabel(), gbc);
        gbc.gridx = 1;
        pMain.add(new JLabel("#"), gbc);
        gbc.gridx = 2;
        pMain.add(new JLabel("ISO Code"), gbc);
        gbc.gridx = 3;
        pMain.add(new JLabel("Value"), gbc);
        gbc.gridx = 4;
        pMain.add(new JLabel("Attributes"), gbc);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pMain = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Bill Values");

        pMain.setLayout(new java.awt.GridBagLayout());
        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pMain;
    // End of variables declaration//GEN-END:variables
}
