#include "CSJPOSLib.h"
#include <stdio.h>
#include <string>

int main(int argc,char**argv)
{	
	int type = CMP_PORT_USB;                // ConnectType: CMP_PORT_USB or CMP_PORT_WiFi
	std::string addr = "/dev/usb/lp0";      // Address ex.: /dev/usb/lp0 or 192.168.1.100

	// Create an instance.
	CSJPOSLib::ESCPOSPrinter *printer = new CSJPOSLib::ESCPOSPrinter();

	// Connect printer
	int result = printer->Connect(type, addr);
	if (CMP_SUCCESS == result)
	{
		// Set encoding
		printer->SetEncoding(932);		// Japanese

		// Start Transaction ( Batch )
		printer->TransactionPrint(CMP_TP_TRANSACTION);
	  
		// Print Text
		printer->PrintText("Citizen_POS_sample1\n\n", 
				CMP_ALIGNMENT_CENTER, CMP_FNT_DEFAULT, 
				CMP_TXT_1WIDTH | CMP_TXT_1HEIGHT);
		printer->PrintText("- Sample Print 1 -\n", 
				CMP_ALIGNMENT_CENTER, CMP_FNT_DEFAULT, 
				CMP_TXT_1WIDTH | CMP_TXT_2HEIGHT);
		printer->PrintText("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", 
				CMP_ALIGNMENT_RIGHT, CMP_FNT_DEFAULT, 
				CMP_TXT_1WIDTH | CMP_TXT_1HEIGHT);

		// Print QRcode
		printer->PrintQRCode("http://www.citizen-systems.co.jp/", 
				6, CMP_QRCODE_EC_LEVEL_L, CMP_ALIGNMENT_RIGHT);

		// Partial Cut with Pre-Feed
		printer->CutPaper(CMP_CUT_PARTIAL_PREFEED);

		// End Transaction ( Batch )
		result = printer->TransactionPrint(CMP_TP_NORMAL);

		// Disconnect
		printer->Disconnect();

		if (CMP_SUCCESS != result)
		{
			/// Print process Error
			printf("Transaction Error : %d\n", result);
		}
	}
	else
	{
		// Connect Error
		printf("Connect Error : %d (addr=%s)\n", result, addr.c_str());
	}

	return 0;
}

