#include "CSJPOSLib.h"
#include <stdio.h>
#include <string>

int main(int argc,char**argv)
{	
	int type = CMP_PORT_USB;                // ConnectType: CMP_PORT_USB or CMP_PORT_WiFi
	std::string addr = "/dev/usb/lp0";      // Address ex.: /dev/usb/lp0 or 192.168.1.100

	// Create an instance.
	CSJPOSLib::ESCPOSPrinter *printer = new CSJPOSLib::ESCPOSPrinter();

	// Connect printer
	int result = printer->Connect(type, addr);
	if (CMP_SUCCESS == result)
	{
		// Set encoding
		printer->SetEncoding(932);		// Japanese

		// Start Transaction ( Batch )
		printer->TransactionPrint( CMP_TP_TRANSACTION );
	  
		// Print Text
		printer->PrintText("Citizen_POS_sample2\n\n", 
				CMP_ALIGNMENT_CENTER, CMP_FNT_DEFAULT, 
				CMP_TXT_1WIDTH | CMP_TXT_1HEIGHT);
		printer->PrintNormal( "\u001b|2vC\u001b|cA- Sample Print 2 -\n" );
		printer->PrintText("123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", 
				CMP_ALIGNMENT_RIGHT, CMP_FNT_DEFAULT, 
				CMP_TXT_1WIDTH | CMP_TXT_1HEIGHT);

		// Start Page mode
		printer->PageModePrint( CMP_PM_PAGE_MODE );

		// Position set
		printer->SetPageModeVerticalPosition( 0 );
		printer->SetPageModeHorizontalPosition( 0 );

		// Direction set
		printer->SetPageModePrintDirection( CMP_PD_TOP_TO_BOTTOM );

		// Print data output
		printer->SetPageModePrintArea( "308,0,76,800" );
		printer->PrintNormal( "\u001b|4C- Receipt -\n" );
		printer->SetPageModePrintArea( "184,0,120,800" );
		printer->PrintText( "   $ 299.99-  \n", CMP_ALIGNMENT_CENTER, CMP_FNT_UNDERLINE | CMP_FNT_BOLD, CMP_TXT_4WIDTH | CMP_TXT_4HEIGHT );
		printer->SetPageModePrintArea( "88,0,88,560" );
		printer->PrintText( "CITIZEN SYSTEMS\n", CMP_ALIGNMENT_RIGHT, CMP_FNT_DEFAULT, CMP_TXT_2WIDTH | CMP_TXT_3HEIGHT );
		printer->SetPageModePrintArea( "0,0,88,480" );
		printer->PrintBarCode( "123456789012", CMP_BCS_UPCA, 64, 4, CMP_ALIGNMENT_LEFT, CMP_HRI_TEXT_BELOW );
		printer->SetPageModePrintArea( "0,600,192,192" );
		printer->PrintQRCode( "http://www.citizen-systems.co.jp/", 5, CMP_QRCODE_EC_LEVEL_L, CMP_ALIGNMENT_LEFT );

		// End Page mode
		printer->PageModePrint( CMP_PM_NORMAL );

		// Partial Cut with Pre-Feed
		printer->CutPaper( CMP_CUT_PARTIAL_PREFEED );

		// End Transaction ( Batch )
		result = printer->TransactionPrint( CMP_TP_NORMAL );

		// Disconnect
		printer->Disconnect();

		if (CMP_SUCCESS != result)
		{
			/// Print process Error
			printf("Transaction Error : %d\n", result);
		}
	}
	else
	{
		// Connect Error
		printf("Connect Error : %d (addr=%s)\n", result, addr.c_str());
	}

	return 0;
}

