﻿
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using com.citizen.sdk;
using System.Diagnostics;

namespace POSApplication
{
    public partial class Form1 : Form
    {
        struct OrderItem
        {
            public int Id;
            public String Name;
            public  double Price;
            public int Num;
        };
        OrderItem[] orders = new OrderItem[]{
            new OrderItem(){Id=1001,Name="hamburger",Price=3.00,Num=4},
            new OrderItem(){Id=1002,Name="french fries",Price=2.00,Num=2},
            new OrderItem(){Id=1003,Name="orange juice",Price=1.50,Num=2},
            new OrderItem(){Id=1004,Name="apple juice",Price=1.50,Num=1},
            new OrderItem(){Id=1005,Name="coke",Price=1.00,Num=2},
        };

        // Count
        int count;


        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            DataTable dataTable1 = new DataTable("ComboBox");
            dataTable1.Columns.Add("Display", typeof(string));
            dataTable1.Columns.Add("Value", typeof(int));
            dataTable1.Rows.Add("WiFi", ESCPOSConst.CMP_PORT_WiFi);
            dataTable1.Rows.Add("USB", ESCPOSConst.CMP_PORT_USB);
            dataTable1.Rows.Add("COM", ESCPOSConst.CMP_PORT_COM);
            dataTable1.Rows.Add("LPT", ESCPOSConst.CMP_PORT_LPT);
            dataTable1.Rows.Add("Bluetooth", ESCPOSConst.CMP_PORT_Bluetooth);
            comboBox1.DataSource = dataTable1;
            comboBox1.DisplayMember = "Display";
            comboBox1.ValueMember = "Value";
            comboBox1.SelectedIndex = 0;

            listView1.Items.Clear();
            listView1.Columns.Add("Address", 100, HorizontalAlignment.Left);
            listView1.Columns.Add("", 255, HorizontalAlignment.Left);

            count = 0;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            listView1.Items.Clear();
        }

        // BtnSearch
        private void BtnSearch_Click(object sender, EventArgs e)
        {
            int i;
            int errCode;
            CitizenPrinterInfo[] list;
            ESCPOSPrinter printer;
            int type = (int)comboBox1.SelectedValue;

            listView1.Items.Clear();

            printer = new ESCPOSPrinter();
            list = printer.SearchCitizenPrinter(type, 5, out errCode);

            if (errCode != ESCPOSConst.CMP_SUCCESS)
            {
                showMessage(errCode);
                return;
            }

            for (i = 0; i < list.Length; i++)
            {
                string[] CLSs = new string[2];
                switch (type)
                {
                    case ESCPOSConst.CMP_PORT_WiFi:
                        CLSs[0] = list[i].ipAddress;
                        CLSs[1] = list[i].macAddress;
                        break;

                    case ESCPOSConst.CMP_PORT_USB:
                        CLSs[0] = list[i].deviceName;
                        CLSs[1] = list[i].printerModel;
                        break;

                    case ESCPOSConst.CMP_PORT_COM:
                        CLSs[0] = list[i].deviceName;
                        break;

                    case ESCPOSConst.CMP_PORT_LPT:
                        CLSs[0] = list[i].deviceName;
                        break;

                    case ESCPOSConst.CMP_PORT_Bluetooth:
                        CLSs[0] = list[i].deviceName;
                        CLSs[0] = list[i].bdAddress;
                        break;
                }

                listView1.Items.Add(new ListViewItem(CLSs));
            }

            listView1.Focus();
            listView1.Items[0].Selected = true;
        }

        //BtnReceipt
        private void BtnReceipt_Click(object sender, EventArgs e)
        {
            int result;
            double amount;
            double total_amount = 0;
            double Tax = 0;
            double Total = 0;
            const double TAX_RATE = 0.08;

            int wordcount1 = 7;
            int wordcount2 = 14;
            int wordcount3 = 3;
            int wordcount4 = 8;
            int wordcount5 = 9;
            int wordcount6 = 7;

            bool checked3inch = radioButton2.Checked;

            if (checked3inch)
            {
                wordcount1 = 8;
                wordcount2 = 22;
                wordcount3 = 6;
                wordcount4 = 12;
                wordcount5 = 14;
                wordcount6 = 10;
            }

            // Create an instance
            ESCPOSPrinter printer = new ESCPOSPrinter();
            // Connect printer
            result = Connect(printer);

            if (result != ESCPOSConst.CMP_SUCCESS)
            {
                return;
            }

            // Acquire the date and time
            DateTime dat = DateTime.Now;
            string strDATE = dat.ToString("yyyy-MM-dd HH:mm:ss");
            // Update of the serial number
            count = count + 1;
            // Start Transaction ( Batch )
            printer.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);

            // Print Text
            printer.PrintBitmap(".\\shoplogo.bmp",
                 ESCPOSConst.CMP_BM_ASIS,
                 ESCPOSConst.CMP_ALIGNMENT_CENTER,
                 ESCPOSConst.CMP_BM_MODE_HT_DITHER | ESCPOSConst.CMP_BM_MODE_CMD_RASTER);

            printer.PrintText("\nThank you very much.\n" + "Looking forward to your visit again.\n",
                 ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_BOLD,
                 ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

            printer.PrintText("ST0001  " + strDATE + "\n\n",
                 ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                 ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

            for (int i = 0; i < orders.Length; i++)
            {
                printer.PrintPaddingText(orders[i].Id.ToString(), ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount1, ESCPOSConst.CMP_SIDE_RIGHT);
                printer.PrintPaddingText(orders[i].Name, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount2, ESCPOSConst.CMP_SIDE_RIGHT);
                printer.PrintPaddingText(orders[i].Num.ToString(), ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount3, ESCPOSConst.CMP_SIDE_LEFT);

                amount = orders[i].Price * orders[i].Num;

                printer.PrintPaddingText(amount.ToString("0.00"), ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount4, ESCPOSConst.CMP_SIDE_LEFT);

                printer.PrintNormal("\n");

                total_amount += amount;
            }

            Tax = (double)(total_amount * TAX_RATE);

            Total = (double)(total_amount + Tax);

            printer.PrintNormal("\n");

            printer.PrintPaddingText("Sub Total",
                 ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                 wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

            printer.PrintPaddingText(total_amount.ToString("0.00"), 
                ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1HEIGHT, 
                wordcount6 * 2, ESCPOSConst.CMP_SIDE_LEFT);

            printer.PrintNormal("\n");

            printer.PrintPaddingText("TAX",
                 ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                 wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

            printer.PrintPaddingText(Tax.ToString("0.00"), 
                ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1HEIGHT, 
                wordcount6 * 2, ESCPOSConst.CMP_SIDE_LEFT);

            printer.PrintNormal("\n");

            printer.PrintPaddingText("Total",
                 ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                 wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

            printer.PrintPaddingText(Total.ToString("0.00"),
                ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                wordcount6, ESCPOSConst.CMP_SIDE_LEFT);

            printer.PrintNormal("\n\n");

            printer.PrintText("     " + String.Format("{0:00000}", count) + "     OP0101\n\n",
                 ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                 ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

            // After feed the paper to the cutting position, partial cut.
            printer.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
            // End Transaction ( Batch )
            result = printer.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);
            // Disconnect printer
            printer.Disconnect();

            showMessage(result);
        }
        

        //Btn Official bill
        private void BtnReceipt2_Click(object sender, EventArgs e)
        {
            int result;
            double amount;
            double total_amount = 0;
            double Tax = 0;
            double Total = 0;
            const double TAX_RATE = 0.08;

            // Create an instance
            ESCPOSPrinter printer = new ESCPOSPrinter();
            // Connect printer
            result = Connect(printer);

            if (result != ESCPOSConst.CMP_SUCCESS)
            {
                return;
            }

            // Acquire the date and time
            DateTime dat = DateTime.Now;
            string strDATE = dat.ToString("yyyy-MM-dd\n");
            // Update of the serial number
            count = count + 1;
            // Start Transaction ( Batch )
            printer.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);

            // Print Text
            printer.PrintText("RECEIPT",
                 ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                 ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

            printer.PrintText("  No." + String.Format("{0:00000}", count) + "\n\n" + strDATE + "\n",
                 ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                 ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

            for (int i = 0; i < orders.Length; i++)
            {
                amount = orders[i].Price * orders[i].Num;
                total_amount += amount;
            }

            Tax = (double)(total_amount * TAX_RATE);

            Total = (double)(total_amount + Tax);

            printer.PrintText(Total.ToString("00.00").PadLeft(13) + "-  \n\n",
                ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_UNDERLINE | ESCPOSConst.CMP_FNT_BOLD,
                ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

            printer.PrintText("Citizen Systems Europe\n" + "Mettingerstrasse 11\n" + "73728 Esslingen\n" + "Germany\n" + "TEL:xxxx-xx-xxxx\n\n",
                ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

            // After feed the paper to the cutting position, partial cut.
            printer.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
            // End Transaction ( Batch )
            result = printer.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);
            // Disconnect printer
            printer.Disconnect();

            showMessage(result);
        }

        // Btn Cooking
        private void BtnCooking_Click(object sender, EventArgs e)
        {
            int result;
            
            int wordcount1 = 18;
            int wordcount2 = 9;

            bool checked3inch = radioButton2.Checked;

            if (checked3inch)
            {
                wordcount1 = 26;
                wordcount2 = 13;
            }

            // Create an instance
            ESCPOSPrinter printer = new ESCPOSPrinter();
            // Connect printer
            result = Connect(printer);

            if (result != ESCPOSConst.CMP_SUCCESS)
            {
                return;
            }

            // Acquire the date and time
            DateTime dat = DateTime.Now;
            string strTIME = dat.ToString("HH:mm\n");
            // Update of the serial number
            count = count + 1;
            // Start Transaction ( Batch )
            printer.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);
            // Sound the buzzer (The printer must support buzzer.)
            byte[] data = { 0x1b, 0x1e, 0x00, 0x1b, 0x1e, 0x00, 0x1b, 0x1e, 0x00 };
            printer.PrintData(data);

            // Print text
            for (int i = 0; i < orders.Length; i++)
            {
                printer.PrintText(orders[i].Num.ToString().PadLeft(2) + "  ",
                    ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

                printer.PrintPaddingText(orders[i].Name,
                    ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT,
                    wordcount1, ESCPOSConst.CMP_SIDE_RIGHT);

                printer.PrintNormal("\n");

                printer.PrintText(" Single Item ",
                     ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT | ESCPOSConst.CMP_FNT_REVERSE,
                     ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                printer.PrintPaddingText("A03", ESCPOSConst.CMP_FNT_DEFAULT,
                    ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT,
                    wordcount2, ESCPOSConst.CMP_SIDE_LEFT);

                printer.PrintNormal("\n");

                printer.PrintText(String.Format("{0:00000}", count) + "　 person 2　OP0101 " + strTIME,
                    ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                    ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                // Update of the serial number
                count = count + 1;

                // After feed the paper to the cutting position, partial cut.
                printer.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
            }

            // End Transaction ( Batch )
            result = printer.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);
            // Disconnect printer
            printer.Disconnect();

            showMessage(result);
        }


        void showMessage(int result)
        {
            string word;
            switch (result)
            {
                case ESCPOSConst.CMP_SUCCESS:
                    word = "The operation is success.";
                    break;

                case ESCPOSConst.CMP_E_CONNECTED:
                    word = "The printer is already connected.";
                    break;

                case ESCPOSConst.CMP_E_DISCONNECT:
                    word = "The printer is not connected.";
                    break;

                case ESCPOSConst.CMP_E_NOTCONNECT:
                    word = "Failed connection to the printer.";
                    break;

                case ESCPOSConst.CMP_E_CONNECT_NOTFOUND:
                    word = "Failed to check the support model after connecting to the device.";
                    break;

                case ESCPOSConst.CMP_E_CONNECT_OFFLINE:
                    word = "Failed to check the printer status after connecting to the device.";
                    break;

                case ESCPOSConst.CMP_E_USB_BIDIRECTIONAL:
                    word = "The status feature of the Windows driver is enabled.";
                    break;

                case ESCPOSConst.CMP_E_ILLEGAL:
                    word = "Unsupported operation with the Device, or an invalid parameter value was used.";
                    break;

                case ESCPOSConst.CMP_E_OFFLINE:
                    word = "The printer is off-line.";
                    break;

                case ESCPOSConst.CMP_E_NOEXIST:
                    word = "The file name does not exist.";
                    break;

                case ESCPOSConst.CMP_E_FAILURE:
                    word = "The Service cannot perform the requested procedure.";
                    break;

                case ESCPOSConst.CMP_E_TIMEOUT:
                    word = "The Service timed out waiting for a response from the printer.";
                    break;

                case ESCPOSConst.CMP_E_NO_LIST:
                    word = "The printer cannot be found in the printer search.";
                    break;

                case ESCPOSConst.CMP_EPTR_COVER_OPEN:
                    word = "The cover of the printer opens.";
                    break;

                case ESCPOSConst.CMP_EPTR_REC_EMPTY:
                    word = "The printer is out of paper.";
                    break;

                case ESCPOSConst.CMP_EPTR_BADFORMAT:
                    word = "The specified file is in an unsupported format.";
                    break;

                case ESCPOSConst.CMP_EPTR_TOOBIG:
                    word = "The specified bitmap is either too big.";
                    break;

                default:
                    word = "The other error.";
                    break;
            }
            if (word == "The operation is success.")
                MessageBox.Show(word + "  " + "(" + result.ToString() + ")", "Result", MessageBoxButtons.OK, MessageBoxIcon.Information);
                else
                MessageBox.Show(word + "  " + "(" + result.ToString() + ")", "Result", MessageBoxButtons.OK, MessageBoxIcon.Error);   
        }

        int Connect(ESCPOSPrinter printer)
        {
            int Connectresult;
            int type = (int)comboBox1.SelectedValue;

            // Set the serial port settings. (Serial only)
            if (type == ESCPOSConst.CMP_PORT_COM)
            {
                printer.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600,
                    ESCPOSConst.CMP_COM_PARITY_NONE,
                    ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR);
            }

            if (listView1.SelectedItems.Count == 0)
            {
                MessageBox.Show("No printer is selected.", "Result", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return ESCPOSConst.CMP_E_FAILURE;
            }

            Connectresult = printer.Connect(type, listView1.SelectedItems[0].Text);

            if (Connectresult != ESCPOSConst.CMP_SUCCESS)
            {
                showMessage(Connectresult);
            }

            return Connectresult;
        }

   　}
    
 }
