﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using com.citizen.sdk;

namespace Citizen_POS_sample1_CS
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            // ComboBoxColumnで使用するDataTableの作成
            DataTable dataTable1 = new DataTable("ComboBox");
            dataTable1.Columns.Add("Display", typeof(string));
            dataTable1.Columns.Add("Value", typeof(int));
            dataTable1.Rows.Add("WiFi", ESCPOSConst.CMP_PORT_WiFi);
            dataTable1.Rows.Add("USB", ESCPOSConst.CMP_PORT_USB);
            dataTable1.Rows.Add("COM", ESCPOSConst.CMP_PORT_COM);
            dataTable1.Rows.Add("LPT", ESCPOSConst.CMP_PORT_LPT);
            dataTable1.Rows.Add("Bluetooth", ESCPOSConst.CMP_PORT_Bluetooth);
            comboBox1.DataSource = dataTable1;
            comboBox1.DisplayMember = "Display";
            comboBox1.ValueMember = "Value";
            comboBox1.SelectedIndex = 0;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            // Constructor
            ESCPOSPrinter posPtr = new ESCPOSPrinter();

            // Get Address
            String addr = textBox1.Text;

            // Get I/F Type
            int type = (int)comboBox1.SelectedValue;

            // Set COMM Properties
            if (ESCPOSConst.CMP_PORT_COM == type)
            {
                posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR);
            }

            // Connect
            int result = posPtr.Connect(type, addr);
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                // Character set
                posPtr.SetEncoding("ISO-8859-1");		// Latin-1
                //posPtr.SetEncoding("Shift_JIS");	    // Japanese 日本語を印字する場合は、この行を有効にしてください.

                // Start Transaction ( Batch )
                posPtr.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);

                // Print Text
                posPtr.PrintText("Citizen_POS_sample1_CS\n\n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);
                posPtr.PrintText("- Sample Print 1 -\n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);
                posPtr.PrintText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                // Print QRcode
                posPtr.PrintQRCode("http://www.citizen-systems.co.jp/", 6, ESCPOSConst.CMP_QRCODE_EC_LEVEL_L, ESCPOSConst.CMP_ALIGNMENT_RIGHT);

                // Partial Cut with Pre-Feed
                posPtr.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);

                // End Transaction ( Batch )
                result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);

                // Disconnect
                posPtr.Disconnect();

                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    // Transaction Error
                    MessageBox.Show("Transaction Error : " + result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                // Connect Error
                MessageBox.Show("Connect Error : " + result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            // Constructor
            ESCPOSPrinter posPtr = new ESCPOSPrinter();

            // Get Address
            String addr = textBox1.Text;

            // Get I/F Type
            int type = (int)comboBox1.SelectedValue;

            // Set COMM Properties
            if (ESCPOSConst.CMP_PORT_COM == type)
            {
                posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR);
            }

            // Connect
            int result = posPtr.Connect(type, addr);
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                // Character set
                result = posPtr.SetEncoding("ISO-8859-1");		// Latin-1
                //result = posPtr.SetEncoding("Shift_JIS");	    // Japanese 日本語を印字する場合は、この行を有効にしてください.

                // Max page mode area
                Debug.WriteLine("Max. Page area", "( x,y ) : " + posPtr.GetPageModeArea());

                // Start Transaction ( Batch )
                posPtr.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);

                // Print Normal
                posPtr.PrintText("Citizen_POS_sample1_CS\n\n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);
                posPtr.PrintNormal("\u001b|2vC\u001b|cA- Sample Print 2 -\n");
                posPtr.PrintText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890\n", ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                // Start Page mode
                posPtr.PageModePrint(ESCPOSConst.CMP_PM_PAGE_MODE);

                // Position set
                posPtr.SetPageModeVerticalPosition(0);
                posPtr.SetPageModeHorizontalPosition(0);

                // Direction set
                posPtr.SetPageModePrintDirection(ESCPOSConst.CMP_PD_TOP_TO_BOTTOM);

                // Print data output
                posPtr.SetPageModePrintArea("500,0,76,800");
                posPtr.PrintNormal("\u001b|4C- Receipt -\n");
                posPtr.SetPageModePrintArea("260,0,120,800");
                posPtr.PrintText("   $ 299.99-  \n", ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_UNDERLINE | ESCPOSConst.CMP_FNT_BOLD, ESCPOSConst.CMP_TXT_4WIDTH | ESCPOSConst.CMP_TXT_4HEIGHT);
                posPtr.SetPageModePrintArea("88,0,88,560");
                posPtr.PrintText("CITIZEN SYSTEMS\n", ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_3HEIGHT);
                posPtr.SetPageModePrintArea("0,0,88,480");
                posPtr.PrintBarCode("123456789012", ESCPOSConst.CMP_BCS_UPCA, 64, 4, ESCPOSConst.CMP_ALIGNMENT_LEFT, ESCPOSConst.CMP_HRI_TEXT_BELOW);
                posPtr.SetPageModePrintArea("0,600,192,192");
                posPtr.PrintQRCode("http://www.citizen-systems.co.jp/", 5, ESCPOSConst.CMP_QRCODE_EC_LEVEL_L, ESCPOSConst.CMP_ALIGNMENT_LEFT);

                // End Page mode
                posPtr.PageModePrint(ESCPOSConst.CMP_PM_NORMAL);

                // Partial Cut with Pre-Feed
                posPtr.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);

                // End Transaction ( Batch )
                result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL);

                // Disconnect
                posPtr.Disconnect();

                if (ESCPOSConst.CMP_SUCCESS != result)
                {
                    // Transaction Error
                    MessageBox.Show("Transaction Error : " + result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
            else
            {
                // Connect Error
                MessageBox.Show("Connect Error : " + result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            // Constructor
            ESCPOSPrinter posPtr = new ESCPOSPrinter();

            // Get Address
            String addr = textBox1.Text;

            // Get I/F Type
            int type = (int)comboBox1.SelectedValue;

            // Set COMM Properties
            if (ESCPOSConst.CMP_PORT_COM == type)
            {
                posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR);
            }

            // PrinterCheckEx
            int status;
            int result = posPtr.PrinterCheckEx(out status, type, addr);
            if (ESCPOSConst.CMP_SUCCESS == result)
            {
                String msg = "PrinterCheckEx() : Success\n";
                //
                // Status Check
                if (ESCPOSConst.CMP_STS_NORMAL == status)
                {
                    // Status Normal
                    msg += "\n\t * Normal";
                }
                else
                {
                    if ((ESCPOSConst.CMP_STS_COVER_OPEN & status) > 0)
                    {
                        // Cover Open
                        msg += "\n\t * Cover Open";
                    }
                    if ((ESCPOSConst.CMP_STS_PAPER_EMPTY & status) > 0)
                    {
                        // Paper Empty
                        msg += "\n\t * Paper Empty";
                    }
                    if ((ESCPOSConst.CMP_STS_PRINTEROFF & status) > 0)
                    {
                        // Printer Offline
                        msg += "\n\t * Printer Offline";
                    }
                    if ((ESCPOSConst.CMP_STS_PAPER_NEAREMPTY & status) > 0)
                    {
                        // Printer Paper Near Empty
                        msg += "\n\t * Printer Paper Near Empty";
                    }
                    if ((ESCPOSConst.CMP_STS_DRAWER_LEVEL_H & status) > 0)
                    {
                        // Drawer Lebel Hight
                        msg += "\n\t * Drawer Level Hight";
                    }
                }
                MessageBox.Show(msg, "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.None);
            }
            else
            {
                // PrinterCheckEx Error
                MessageBox.Show("PrinterCheckEx Error : " + result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }
}
