﻿Imports com.citizen.sdk

Public Class Form1

    Public Sub New()

        ' この呼び出しはデザイナーで必要です。
        InitializeComponent()

        ' InitializeComponent() 呼び出しの後で初期化を追加します。
        ' ComboBoxColumnで使用するDataTableの作成
        Dim dataTable1 As New DataTable("ComboBox")
        dataTable1.Columns.Add("Display", Type.GetType("System.String"))
        dataTable1.Columns.Add("Value", Type.GetType("System.Int32"))
        dataTable1.Rows.Add("WiFi", ESCPOSConst.CMP_PORT_WiFi)
        dataTable1.Rows.Add("USB", ESCPOSConst.CMP_PORT_USB)
        dataTable1.Rows.Add("COM", ESCPOSConst.CMP_PORT_COM)
        dataTable1.Rows.Add("LPT", ESCPOSConst.CMP_PORT_LPT)
        dataTable1.Rows.Add("Bluetooth", ESCPOSConst.CMP_PORT_Bluetooth)
        comboBox1.DataSource = dataTable1
        comboBox1.DisplayMember = "Display"
        comboBox1.ValueMember = "Value"
        comboBox1.SelectedIndex = 0

    End Sub

    Private Sub button1_Click(sender As System.Object, e As System.EventArgs) Handles button1.Click

        ' Constructor
        Dim posPtr As New ESCPOSPrinter()

        ' Get Address
        Dim addr As String = textBox1.Text

        ' Get Type
        Dim type As Integer = comboBox1.SelectedValue

        ' Set COMM Properties
        If ESCPOSConst.CMP_PORT_COM = type Then
            posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR)
        End If

        ' Connect
        Dim result As Integer = posPtr.Connect(type, addr)
        If ESCPOSConst.CMP_SUCCESS = result Then
            ' Character set
            posPtr.SetEncoding("ISO-8859-1")    ' Latin-1
            'posPtr.SetEncoding("Shift_JIS")    ' Japanese 日本語を印字する場合は、この行を有効にしてください.

            ' Start Transaction ( Batch )
            posPtr.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION)

            ' Print Text
            posPtr.PrintText("Citizen_POS_sample1_Basic" & vbCrLf & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH + ESCPOSConst.CMP_TXT_1HEIGHT)
            posPtr.PrintText("- Sample Print 1 -" & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH + ESCPOSConst.CMP_TXT_2HEIGHT)
            posPtr.PrintText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890" & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH + ESCPOSConst.CMP_TXT_1HEIGHT)

            ' Print QRcode
            posPtr.PrintQRCode("http://www.citizen-systems.co.jp/", 6, ESCPOSConst.CMP_QRCODE_EC_LEVEL_L, ESCPOSConst.CMP_ALIGNMENT_RIGHT)

            ' Partial Cut with Pre-Feed
            posPtr.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED)

            ' End Transaction ( Batch )
            result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL)

            ' Disconnect
            posPtr.Disconnect()

            If ESCPOSConst.CMP_SUCCESS <> result Then
                ' Transaction Error
                MessageBox.Show("Transaction Error : " & result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error)
            End If
        Else
            ' Connect Error
            MessageBox.Show("Connect Error : " & result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End If

    End Sub

    Private Sub button2_Click(sender As System.Object, e As System.EventArgs) Handles button2.Click

        ' Constructor
        Dim posPtr As New ESCPOSPrinter()

        ' Get Address
        Dim addr As String = textBox1.Text

        ' Get Type
        Dim type As Integer = comboBox1.SelectedValue

        ' Set COMM Properties
        If ESCPOSConst.CMP_PORT_COM = type Then
            posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR)
        End If

        ' Connect
        Dim result As Integer = posPtr.Connect(type, addr)
        If ESCPOSConst.CMP_SUCCESS = result Then
            ' Character set
            posPtr.SetEncoding("ISO-8859-1")    ' Latin-1
            'posPtr.SetEncoding("Shift_JIS")    ' Japanese 日本語を印字する場合は、この行を有効にしてください.

            ' Start Transaction ( Batch )
            posPtr.TransactionPrint(ESCPOSConst.CMP_TP_TRANSACTION)

            ' Print Normal
            posPtr.PrintText("Citizen_POS_sample1_CS" & vbCrLf & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH + ESCPOSConst.CMP_TXT_1HEIGHT)
            posPtr.PrintNormal(Chr(&H1BS) & "|2vC" & Chr(&H1BS) & "|cA- Sample Print 2 -" & vbCrLf)
            posPtr.PrintText("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890" & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH + ESCPOSConst.CMP_TXT_1HEIGHT)

            ' Start Page mode
            posPtr.PageModePrint(ESCPOSConst.CMP_PM_PAGE_MODE)

            ' Position set
            posPtr.SetPageModeVerticalPosition(0)
            posPtr.SetPageModeHorizontalPosition(0)

            ' Direction set
            posPtr.SetPageModePrintDirection(ESCPOSConst.CMP_PD_TOP_TO_BOTTOM)

            ' Print data output
            posPtr.SetPageModePrintArea("500,0,76,800")
            posPtr.PrintNormal(Chr(&H1BS) & "|4C- Receipt -" & vbCrLf)
            posPtr.SetPageModePrintArea("260,0,120,800")
            posPtr.PrintText("   $ 299.99-  " & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_UNDERLINE + ESCPOSConst.CMP_FNT_BOLD, ESCPOSConst.CMP_TXT_4WIDTH + ESCPOSConst.CMP_TXT_4HEIGHT)
            posPtr.SetPageModePrintArea("88,0,88,560")
            posPtr.PrintText("CITIZEN SYSTEMS" & vbCrLf, ESCPOSConst.CMP_ALIGNMENT_RIGHT, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH + ESCPOSConst.CMP_TXT_3HEIGHT)
            posPtr.SetPageModePrintArea("0,0,88,480")
            posPtr.PrintBarCode("123456789012", ESCPOSConst.CMP_BCS_UPCA, 64, 4, ESCPOSConst.CMP_ALIGNMENT_LEFT, ESCPOSConst.CMP_HRI_TEXT_BELOW)
            posPtr.SetPageModePrintArea("0,600,192,192")
            posPtr.PrintQRCode("http://www.citizen-systems.co.jp/", 5, ESCPOSConst.CMP_QRCODE_EC_LEVEL_L, ESCPOSConst.CMP_ALIGNMENT_LEFT)

            ' End Page mode
            posPtr.PageModePrint(ESCPOSConst.CMP_PM_NORMAL)

            ' Partial Cut with Pre-Feed
            posPtr.CutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED)

            ' End Transaction ( Batch )
            result = posPtr.TransactionPrint(ESCPOSConst.CMP_TP_NORMAL)

            ' Disconnect
            posPtr.Disconnect()

            If ESCPOSConst.CMP_SUCCESS <> result Then
                ' Transaction Error
                MessageBox.Show("Transaction Error : " & result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error)
            End If
        Else
            ' Connect Error
            MessageBox.Show("Connect Error : " & result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End If

    End Sub

    Private Sub button3_Click(sender As System.Object, e As System.EventArgs) Handles button3.Click

        ' Constructor
        Dim posPtr As New ESCPOSPrinter()

        ' Get Address
        Dim addr As String = textBox1.Text

        ' Get Type
        Dim type As Integer = comboBox1.SelectedValue

        ' Set COMM Properties
        If ESCPOSConst.CMP_PORT_COM = type Then
            posPtr.SetCommProperties(ESCPOSConst.CMP_COM_BAUDRATE_9600, ESCPOSConst.CMP_COM_PARITY_NONE, ESCPOSConst.CMP_COM_HANDSHAKE_DTRDSR)
        End If

        ' PrinterCheckEx
        Dim status As Integer
        Dim result As Integer = posPtr.PrinterCheckEx(status, type, addr)
        If ESCPOSConst.CMP_SUCCESS = result Then
            Dim msg As String = "PrinterCheckEx() : Success" & vbCrLf
            '
            ' Status Check
            If ESCPOSConst.CMP_STS_NORMAL = status Then
                ' Status Normal
                msg += vbCrLf & vbTab & " * Normal"
            Else
                If (ESCPOSConst.CMP_STS_COVER_OPEN And status) <> 0 Then
                    ' Cover Open
                    msg += vbCrLf & vbTab & " * Cover Open"
                End If
                If (ESCPOSConst.CMP_STS_PAPER_EMPTY And status) <> 0 Then
                    ' Paper Empty
                    msg += vbCrLf & vbTab & " * Paper Empty"
                End If
                If (ESCPOSConst.CMP_STS_PRINTEROFF And status) <> 0 Then
                    ' Printer Offline
                    msg += vbCrLf & vbTab & " * Printer Offline"
                End If
                If (ESCPOSConst.CMP_STS_PAPER_NEAREMPTY And status) <> 0 Then
                    ' Printer Paper Near Empty
                    msg += vbCrLf & vbTab & " * Printer Paper Near Empty"
                End If
                If (ESCPOSConst.CMP_STS_DRAWER_LEVEL_H And status) <> 0 Then
                    ' Drawer Lebel Hight
                    msg += vbCrLf & vbTab & " * Drawer Level Hight"
                End If
            End If
            MessageBox.Show(msg, "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.None)
        Else
            ' PrinterCheckEx Error
            MessageBox.Show("PrinterCheckEx Error : " & result.ToString(), "Citizen_POS_sample1", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End If

    End Sub
End Class
