package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.AuditPerformance;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

/**
 * Dialog that shows the audit performance values.
 */
public class AuditPerformanceDialog extends javax.swing.JDialog {
    TestGUI gui;
    /** Creates new form AuditPerformanceDialog
     * @param parent
     * @param modal
     */
    public AuditPerformanceDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.gui= (TestGUI) parent;
        initComponents();
        createLabels();
    }

    private void createLabels() {
        try{
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx=0;
        gbc.gridy=0;
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.insets=new Insets(3,3,3,3);
        gbc.anchor=GridBagConstraints.WEST;
        if(gui.getAcceptor().getCapAudit()){
            gbc.gridy=0;
            JLabel lPerformance = new JLabel("Audit Performance");
            pMain.add(lPerformance);
           AuditPerformance ap = gui.getAcceptor().GetAuditPerformance();
            gbc.gridy++;
            JLabel lCC0Rejects = new JLabel("CC0 Rejects: "+ap.getCC0Rejects());
            pMain.add(lCC0Rejects,gbc);
            gbc.gridy++;
            JLabel lCC1Rejects = new JLabel("CC1 Rejects: "+ap.getCC1Rejects());
            pMain.add(lCC1Rejects,gbc);
            gbc.gridy++;
            JLabel lAllJams = new JLabel("All Jams: "+ap.getJams());
            pMain.add(lAllJams,gbc);
            gbc.gridy++;
            JLabel lJamRecovery = new JLabel("Jam Recovery: "+ap.getJamRecovery());
            pMain.add(lJamRecovery,gbc);
            gbc.gridy++;
            JLabel lJamReject = new JLabel("Jam Reject: "+ap.getJamReject());
            pMain.add(lJamReject,gbc);
            gbc.gridy++;
            JLabel lJamStacker = new JLabel("Jam Stacker: "+ap.getJamStacker());
            pMain.add(lJamStacker,gbc);
            gbc.gridy++;
            JLabel lJamNoRecovery = new JLabel("Jam No Recovery: "+ap.getJamNotRecovery());
            pMain.add(lJamNoRecovery,gbc);
            gbc.gridy++;
            JLabel lOutOfService = new JLabel("Out of Service: "+ap.getOutOfService());
            pMain.add(lOutOfService,gbc);
            gbc.gridy++;
            JLabel lOutOfOrder = new JLabel("Out of Order: "+ap.getOutOfOrder());
            pMain.add(lOutOfOrder,gbc);
            gbc.gridy++;
            JLabel lOperatingHours = new JLabel("Operating Hours: "+ap.getOperatingHours());
            pMain.add(lOperatingHours,gbc);
            gbc.gridy++;
            JLabel lDocTooLong = new JLabel("Doc Too Long: "+ap.getDocTooLong());
            pMain.add(lDocTooLong,gbc);
            gbc.gridy++;
            JLabel lDocTease = new JLabel("Doc Tease: "+ap.getDocTease());
            pMain.add(lDocTease,gbc);
            gbc.gridy++;
            JLabel lCalibrations = new JLabel("Calibrations: "+ap.getCalibrations());
            pMain.add(lCalibrations,gbc);
            gbc.gridy++;
            JLabel lQPResets = new JLabel("Resets: "+ap.getResets());
            pMain.add(lQPResets,gbc);
            gbc.gridy++;
            JLabel lDownloads = new JLabel("Downloads: "+ap.getDownloads());
            pMain.add(lDownloads,gbc);
            gbc.gridy++;
            JLabel lCassetteFull = new JLabel("Cassette Full: "+ap.getCassetteFull());
            pMain.add(lCassetteFull,gbc);
            gbc.gridy++;
            JLabel lCassetteRemoved = new JLabel("Cassette Removed: "+ap.getCassetteRemoved());
            pMain.add(lCassetteRemoved,gbc);

        }else{
            gbc.gridy++;
            JLabel lPerformance = new JLabel("Audit Performance Not supported");
            pMain.add(lPerformance,gbc);
        }
        pack();
        }catch(AcceptorException ae){
            ae.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pMain = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Audit Performance");

        pMain.setLayout(new java.awt.GridBagLayout());
        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pMain;
    // End of variables declaration//GEN-END:variables

}
