package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.AuditQP;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

/**
 * Dialog that shows the audit QP values.
 */
public class AuditQPDialog extends javax.swing.JDialog {
    TestGUI gui;
    /** Creates new form DeviceInfoDialog */
    public AuditQPDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.gui= (TestGUI) parent;
        initComponents();
        createLabels();
    }

    private void createLabels() {
        try{
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx=0;
        gbc.gridy=0;
        gbc.fill=GridBagConstraints.HORIZONTAL;
        gbc.insets=new Insets(3,3,3,3);
        gbc.anchor=GridBagConstraints.WEST;
       if(gui.getAcceptor().getCapAudit()){
            gbc.gridx++;
            gbc.gridy=0;
            JLabel lPerformance = new JLabel("Audit QP: ");
            pMain.add(lPerformance,gbc);
            AuditQP aqp = gui.getAcceptor().GetAuditQP();
            gbc.gridy++;
            JLabel lLast100 = new JLabel("Last 100: "+aqp.getLast100());
            pMain.add(lLast100,gbc);
            gbc.gridy++;
            JLabel lMotorStarts = new JLabel("Motor Starts: "+aqp.getMotorStarts());
            pMain.add(lMotorStarts,gbc);
            gbc.gridy++;
            JLabel lDocsStacked = new JLabel("Docs Stacked: "+aqp.getDocsStacked());
            pMain.add(lDocsStacked,gbc);
            gbc.gridy++;
            JLabel lDocsEscrow = new JLabel("Docs Escrow: "+aqp.getDocsEscrow());
            pMain.add(lDocsEscrow,gbc);
            gbc.gridy++;
            JLabel lDocsRecognition = new JLabel("Docs Recognition: "+aqp.getDocsRecognition());
            pMain.add(lDocsRecognition,gbc);
            gbc.gridy++;
            JLabel lDocsValidated = new JLabel("Docs Validated: "+aqp.getDocsValidated());
            pMain.add(lDocsValidated,gbc);
            gbc.gridy++;
            JLabel lRecRejected = new JLabel("Docs Rec Reject: "+aqp.getDocsRecReject());
            pMain.add(lRecRejected,gbc);
            gbc.gridy++;
            JLabel lSecReject = new JLabel("Docs Sec Reject: "+aqp.getDocsSecReject());
            pMain.add(lSecReject,gbc);
            gbc.gridy++;
            JLabel lOrientReject = new JLabel("Docs Orient Reject: "+aqp.getDocsOrientReject());
            pMain.add(lOrientReject,gbc);
            gbc.gridy++;
            JLabel lDocsDisabledReject = new JLabel("Docs Disabled Reject: "+aqp.getDocsDisabledReject());
            pMain.add(lDocsDisabledReject,gbc);
            gbc.gridy++;
            JLabel lffReject = new JLabel("Docs FF Reject: "+aqp.getDocsFFReject());
            pMain.add(lffReject,gbc);
            gbc.gridy++;
            JLabel lDocsWhileDisabled = new JLabel("Docs While Disabled: "+aqp.getDocsWhileDisabled());
            pMain.add(lDocsWhileDisabled,gbc);
            gbc.gridy++;
            JLabel lDocsHostReject = new JLabel("Docs Host Reject: "+aqp.getDocsHostReject());
            pMain.add(lDocsHostReject,gbc);
            gbc.gridy++;
            JLabel lDocsBarcode = new JLabel("Docs Barcode: "+aqp.getDocsBarcode());
            pMain.add(lDocsBarcode,gbc);

        }else{
            gbc.gridy++;
            JLabel lPerformance = new JLabel("Audit QP not supported");
            pMain.add(lPerformance,gbc);
        }
        pack();
        }catch(AcceptorException ae){
            ae.printStackTrace();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pMain = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Audit QP");

        pMain.setLayout(new java.awt.GridBagLayout());
        getContentPane().add(pMain, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents



    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel pMain;
    // End of variables declaration//GEN-END:variables

}
