/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.gui;

import com.meiglobal.ebds.api.Acceptor;
import com.meiglobal.ebds.api.event.AcceptorEvent;
import com.meiglobal.ebds.api.event.AcceptorEventListener;
import com.meiglobal.ebds.api.event.ConnectedEvent;
import com.meiglobal.ebds.api.event.DisconnectedEvent;
import com.meiglobal.ebds.api.event.DownloadFinishEvent;
import com.meiglobal.ebds.api.event.DownloadProgressEvent;
import com.meiglobal.ebds.api.event.DownloadRestartEvent;
import com.meiglobal.ebds.api.event.DownloadStartEvent;
import com.meiglobal.ebds.api.event.EscrowEvent;
import com.meiglobal.ebds.api.event.PUPEscrowEvent;
import com.meiglobal.ebds.api.event.StackedEvent;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.Bill;
import com.meiglobal.ebds.api.pub.DocumentType;
import com.meiglobal.ebds.api.pub.PowerUp;
import com.meiglobal.ebds.gui.AuditLifetimeTotalsDialog;
import com.meiglobal.ebds.gui.AuditPerformanceDialog;
import com.meiglobal.ebds.gui.AuditQPDialog;
import com.meiglobal.ebds.gui.BillSetDialog;
import com.meiglobal.ebds.gui.BillValuesDialog;
import com.meiglobal.ebds.gui.DeviceInfoDialog;
import com.meiglobal.ebds.gui.FlashDownloadDialog;
import com.meiglobal.ebds.gui.GUI;
import com.meiglobal.ebds.gui.PropertiesFrame;
import com.meiglobal.ebds.gui.ShortDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;

public class TestGUI
extends JFrame
implements AcceptorEventListener {
    JFileChooser jfc = new JFileChooser();
    Acceptor a = null;
    String port;
    GUI gui;
    BillSetDialog bsd;
    BillValuesDialog bvd;
    AuditLifetimeTotalsDialog altd;
    AuditPerformanceDialog apd;
    DeviceInfoDialog did;
    AuditQPDialog aqp;
    FlashDownloadDialog fdd;
    PropertiesFrame pf;
    private JButton bAuditPerformance;
    private JButton bAuditPerformanceQP;
    private JButton bBillTypes;
    private JButton bBillValues;
    private JButton bCalibrate;
    private JButton bCapabilities;
    private JButton bClearAudit;
    private JButton bClose;
    private JButton bConnect;
    private JButton bDebugLog;
    private JButton bDeviceInfo;
    private JButton bDownload;
    private JButton bLifeTimeValues;
    private JButton bProperties;
    private JButton bReset;
    private JButton bReturn;
    private JButton bStack;
    private JComboBox cPowerUp;
    private JCheckBox jDebugCheckBox;
    private JButton jExecute;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JTextField jRawCommandField;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lDeviceState;
    private JLabel lEscrow;
    private JLabel lEscrowBar;
    private JLabel lEscrowBill;
    private JLabel lPort;
    private JLabel lPort1;
    private JTextField tDebugLog;
    private JTextField tEscrowBar;
    private JTextField tEscrowBill;
    private JButton tEscrowTimeout;
    private JTextArea tOutput;

    public TestGUI(GUI gui, String port) throws AcceptorException {
        this.gui = gui;
        this.setTitle("Demo application controling device on port " + port);
        this.initComponents();
        this.a = new Acceptor();
        this.a.addAcceptorEventListener(this);
        this.a.setDebugLogPath(".");
        this.tDebugLog.setText(this.a.getDebugLogPath());
        this.a.setDebugLog(false);
        this.port = port;
        this.lPort.setText("Port: " + port);
        this.tEscrowBar.setDocument(new ShortDocument());
        this.tEscrowBill.setDocument(new ShortDocument());
        this.cPowerUp.setModel(new DefaultComboBoxModel<PowerUp>(PowerUp.values()));
        Timer t = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TestGUI.this.lDeviceState.setText(TestGUI.this.a.getDeviceState().toString());
            }
        });
        t.start();
    }

    public void center() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = this.getWidth() / 2;
        int y = this.getHeight() / 2;
        Point p = new Point((int)(d.getWidth() / 2.0 - (double)x), (int)(d.getHeight() / 2.0 - (double)y));
        this.setLocation(p);
    }

    public void acceptorEventOccurred(AcceptorEvent evt) {
        try {
            String message;
            if (evt.getDescription() == null) {
                return;
            }
            if (evt instanceof EscrowEvent) {
                message = "Doc Type: " + (Object)((Object)this.a.getDocType());
                if (DocumentType.Bill.equals((Object)this.a.getDocType())) {
                    Bill b = this.a.getBill();
                    message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char)b.getSeries() + " " + (char)b.getType() + " " + (char)b.getCompatibility() + " " + (char)b.getVersion();
                }
                this.tOutput.append(evt.getDescription() + " " + message);
            } else if (evt instanceof StackedEvent) {
                message = "Doc Type: " + (Object)((Object)this.a.getDocType());
                if (DocumentType.Bill.equals((Object)this.a.getDocType())) {
                    Bill b = this.a.getBill();
                    message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char)b.getSeries() + " " + (char)b.getType() + " " + (char)b.getCompatibility() + " " + (char)b.getVersion();
                }
                this.tOutput.append(evt.getDescription() + " " + message);
            } else if (evt instanceof DownloadStartEvent) {
                this.tOutput.append("Download start at: " + new SimpleDateFormat("hh:mm:ss").format(System.currentTimeMillis()));
            } else {
                if (evt instanceof DownloadProgressEvent) {
                    return;
                }
                if (evt instanceof DownloadFinishEvent) {
                    this.tOutput.append("Download complete at: " + new SimpleDateFormat("hh:mm:ss").format(System.currentTimeMillis()));
                } else if (evt instanceof PUPEscrowEvent) {
                    message = "Doc Type: " + (Object)((Object)this.a.getDocType());
                    if (DocumentType.Bill.equals((Object)this.a.getDocType())) {
                        Bill b = this.a.getBill();
                        message = message + " " + b.getCountry() + " " + b.getValue() + " " + (char)b.getSeries() + " " + (char)b.getType() + " " + (char)b.getCompatibility() + " " + (char)b.getVersion();
                    }
                    this.tOutput.append(evt.getDescription() + " " + message);
                } else {
                    this.tOutput.append(evt.getDescription());
                }
            }
            if (evt instanceof DownloadRestartEvent) {
                if (this.fdd == null) {
                    this.setButtonsEnabled(false);
                    this.bDownload.setEnabled(true);
                    this.bClose.setEnabled(true);
                    this.bDebugLog.setEnabled(true);
                    this.jfc.setApproveButtonText("Select");
                    this.jfc.setMultiSelectionEnabled(false);
                    this.jfc.setDialogTitle("Select a flash file to download.");
                    this.jfc.setFileSelectionMode(0);
                    if (this.jfc.showOpenDialog(this) == 0) {
                        File f = this.jfc.getSelectedFile();
                        this.fdd = new FlashDownloadDialog(this, f.getAbsolutePath(), false);
                        this.centerDialog(this.fdd);
                        this.fdd.setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog(this, "Cannot resume download process, please resume download process manually", "Error, flash file not selected", 0);
                    }
                }
            } else if (evt instanceof ConnectedEvent) {
                this.a.setEnableAcceptance(true);
                this.setButtonsEnabled(true);
            } else if (evt instanceof DisconnectedEvent) {
                this.setButtonsEnabled(false);
            }
            this.tOutput.append(System.getProperty("line.separator"));
            this.tOutput.setCaretPosition(this.tOutput.getText().length() - 1);
        }
        catch (AcceptorException aex) {
            System.out.println("Exception in AcceptorEventOccured: " + aex.getMessage());
        }
    }

    public void dispose() {
        this.gui.addPort(this.port);
        this.closeDialogs();
        if (this.a.getConnected()) {
            this.a.close();
        }
        super.dispose();
    }

    String getPort() {
        return this.port;
    }

    private void centerDialog(JDialog d) {
        Point p = this.getLocationOnScreen();
        Point center = new Point((int)p.getX() + this.getWidth() / 2, (int)p.getY() + this.getHeight() / 2);
        d.setLocation(new Point((int)center.getX() - d.getWidth() / 2, (int)center.getY() - d.getHeight() / 2));
    }

    private void centerFrame(JFrame frame) {
        Point p = this.getLocationOnScreen();
        Point center = new Point((int)p.getX() + this.getWidth() / 2, (int)p.getY() + this.getHeight() / 2);
        frame.setLocation(new Point((int)center.getX() - frame.getWidth() / 2, (int)center.getY() - frame.getHeight() / 2));
    }

    private void closeDialogs() {
        if (this.bsd != null) {
            this.bsd.dispose();
        }
        if (this.bvd != null) {
            this.bvd.dispose();
        }
        if (this.altd != null) {
            this.altd.dispose();
        }
        if (this.apd != null) {
            this.apd.dispose();
        }
        if (this.did != null) {
            this.did.dispose();
        }
        if (this.aqp != null) {
            this.aqp.dispose();
        }
        if (this.fdd != null) {
            this.fdd.dispose();
        }
        if (this.pf != null) {
            this.pf.dispose();
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.bCapabilities = new JButton();
        this.bProperties = new JButton();
        this.bStack = new JButton();
        this.bReturn = new JButton();
        this.bBillTypes = new JButton();
        this.bBillValues = new JButton();
        this.bDeviceInfo = new JButton();
        this.bAuditPerformance = new JButton();
        this.bAuditPerformanceQP = new JButton();
        this.bLifeTimeValues = new JButton();
        this.bCalibrate = new JButton();
        this.bDownload = new JButton();
        this.bDebugLog = new JButton();
        this.tDebugLog = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.bReset = new JButton();
        this.bConnect = new JButton();
        this.bClose = new JButton();
        this.jSeparator2 = new JSeparator();
        this.lPort = new JLabel();
        this.lEscrowBar = new JLabel();
        this.lEscrow = new JLabel();
        this.tEscrowTimeout = new JButton();
        this.tEscrowBill = new JTextField();
        this.tEscrowBar = new JTextField();
        this.lEscrowBill = new JLabel();
        this.lPort1 = new JLabel();
        this.cPowerUp = new JComboBox();
        this.jDebugCheckBox = new JCheckBox();
        this.jRawCommandField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jExecute = new JButton();
        this.jLabel2 = new JLabel();
        this.lDeviceState = new JLabel();
        this.bClearAudit = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tOutput = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel2.setLayout(new GridBagLayout());
        this.bCapabilities.setText("Capabilities");
        this.bCapabilities.setEnabled(false);
        this.bCapabilities.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bCapabilitiesActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bCapabilities, gridBagConstraints);
        this.bProperties.setText("Properties");
        this.bProperties.setEnabled(false);
        this.bProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bPropertiesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bProperties, gridBagConstraints);
        this.bStack.setText("Stack");
        this.bStack.setEnabled(false);
        this.bStack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bStackActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bStack, gridBagConstraints);
        this.bReturn.setText("Return");
        this.bReturn.setEnabled(false);
        this.bReturn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bReturnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bReturn, gridBagConstraints);
        this.bBillTypes.setText("Bill Set");
        this.bBillTypes.setEnabled(false);
        this.bBillTypes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bBillTypesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bBillTypes, gridBagConstraints);
        this.bBillValues.setText("Bill Values");
        this.bBillValues.setEnabled(false);
        this.bBillValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bBillValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bBillValues, gridBagConstraints);
        this.bDeviceInfo.setText("Device Info");
        this.bDeviceInfo.setEnabled(false);
        this.bDeviceInfo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bDeviceInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bDeviceInfo, gridBagConstraints);
        this.bAuditPerformance.setText("Performance");
        this.bAuditPerformance.setEnabled(false);
        this.bAuditPerformance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bAuditPerformanceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bAuditPerformance, gridBagConstraints);
        this.bAuditPerformanceQP.setText("Performance QP");
        this.bAuditPerformanceQP.setEnabled(false);
        this.bAuditPerformanceQP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bAuditPerformanceQPActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bAuditPerformanceQP, gridBagConstraints);
        this.bLifeTimeValues.setText("Lifetime Values");
        this.bLifeTimeValues.setEnabled(false);
        this.bLifeTimeValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bLifeTimeValuesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bLifeTimeValues, gridBagConstraints);
        this.bCalibrate.setText("Calibrate");
        this.bCalibrate.setEnabled(false);
        this.bCalibrate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bCalibrateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bCalibrate, gridBagConstraints);
        this.bDownload.setText("Download Flash");
        this.bDownload.setEnabled(false);
        this.bDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bDownloadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bDownload, gridBagConstraints);
        this.bDebugLog.setText("Change");
        this.bDebugLog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bDebugLogActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bDebugLog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.tDebugLog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        this.jPanel2.add((Component)this.jSeparator1, gridBagConstraints);
        this.bReset.setText("Reset");
        this.bReset.setEnabled(false);
        this.bReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bResetActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bReset, gridBagConstraints);
        this.bConnect.setText("Connect");
        this.bConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bConnect, gridBagConstraints);
        this.bClose.setText("Disconnect");
        this.bClose.setEnabled(false);
        this.bClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.bClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        this.jPanel2.add((Component)this.jSeparator2, gridBagConstraints);
        this.lPort.setText("Port: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lPort, gridBagConstraints);
        this.lEscrowBar.setText("Barcode Timeout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lEscrowBar, gridBagConstraints);
        this.lEscrow.setText("Escrow Timeout (0 to 127 seconds, 0 means no timeout)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lEscrow, gridBagConstraints);
        this.tEscrowTimeout.setText("Set Timeout");
        this.tEscrowTimeout.setEnabled(false);
        this.tEscrowTimeout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.tEscrowTimeoutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.tEscrowTimeout, gridBagConstraints);
        this.tEscrowBill.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.tEscrowBill, gridBagConstraints);
        this.tEscrowBar.setText("0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.tEscrowBar, gridBagConstraints);
        this.lEscrowBill.setText("Bill Timeout");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lEscrowBill, gridBagConstraints);
        this.lPort1.setText("Power Up Mode");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lPort1, gridBagConstraints);
        this.cPowerUp.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.cPowerUp, gridBagConstraints);
        this.jDebugCheckBox.setText("Debug Enabled");
        this.jDebugCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.jDebugCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        this.jPanel2.add((Component)this.jDebugCheckBox, gridBagConstraints);
        this.jRawCommandField.setHorizontalAlignment(2);
        this.jRawCommandField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel2.add((Component)this.jRawCommandField, gridBagConstraints);
        this.jLabel1.setText("Enter a command in HEX and click execute.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        this.jPanel2.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 5, 3);
        this.jPanel2.add((Component)this.jSeparator4, gridBagConstraints);
        this.jExecute.setText("Execute");
        this.jExecute.setEnabled(false);
        this.jExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.jExecuteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jExecute, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("                  State");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.lDeviceState.setText("-----");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.lDeviceState, gridBagConstraints);
        this.bClearAudit.setText("Clear Audit");
        this.bClearAudit.setEnabled(false);
        this.bClearAudit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TestGUI.this.bClearAuditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.bClearAudit, gridBagConstraints);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel4.setLayout(new BorderLayout());
        this.tOutput.setColumns(20);
        this.tOutput.setRows(5);
        this.jScrollPane1.setViewportView(this.tOutput);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void bConnectActionPerformed(ActionEvent evt) {
        try {
            this.a.open(this.port, (PowerUp)((Object)this.cPowerUp.getSelectedItem()));
            this.a.setDisconnectTimeout(4000);
        }
        catch (Exception ex) {
            this.showError(ex);
        }
    }

    private void bCloseActionPerformed(ActionEvent evt) {
        if (this.a != null) {
            this.a.close();
            this.setButtonsEnabled(false);
        }
    }

    private void bBillTypesActionPerformed(ActionEvent evt) {
        this.bsd = new BillSetDialog((Frame)this, false);
        this.centerDialog(this.bsd);
        this.bsd.setVisible(true);
    }

    private void bBillValuesActionPerformed(ActionEvent evt) {
        this.bvd = new BillValuesDialog((Frame)this, false);
        this.centerDialog(this.bvd);
        this.bvd.setVisible(true);
    }

    private void bResetActionPerformed(ActionEvent evt) {
        try {
            this.a.SoftReset();
        }
        catch (Exception ex) {
            this.showError(ex);
        }
    }

    private void bLifeTimeValuesActionPerformed(ActionEvent evt) {
        this.altd = new AuditLifetimeTotalsDialog((Frame)this, false);
        this.centerDialog(this.altd);
        this.altd.setVisible(true);
    }

    private void bAuditPerformanceActionPerformed(ActionEvent evt) {
        this.apd = new AuditPerformanceDialog((Frame)this, false);
        this.centerDialog(this.apd);
        this.apd.setVisible(true);
    }

    private void bDeviceInfoActionPerformed(ActionEvent evt) {
        this.did = new DeviceInfoDialog((Frame)this, false);
        this.centerDialog(this.did);
        this.did.setVisible(true);
    }

    private void bAuditPerformanceQPActionPerformed(ActionEvent evt) {
        this.aqp = new AuditQPDialog((Frame)this, false);
        this.centerDialog(this.aqp);
        this.aqp.setVisible(true);
    }

    private void bStackActionPerformed(ActionEvent evt) {
        try {
            this.a.escrowStack();
        }
        catch (Exception ex) {
            this.showError(ex);
        }
    }

    private void bReturnActionPerformed(ActionEvent evt) {
        try {
            this.a.escrowReturn();
        }
        catch (Exception ex) {
            this.showError(ex);
        }
    }

    private void bCalibrateActionPerformed(ActionEvent evt) {
        try {
            this.a.calibrate();
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private void bDownloadActionPerformed(ActionEvent evt) {
        this.fdd = new FlashDownloadDialog((Frame)this, false);
        this.centerDialog(this.fdd);
        this.fdd.setVisible(true);
    }

    private void bDebugLogActionPerformed(ActionEvent evt) {
        this.jfc.setFileSelectionMode(1);
        this.jfc.setDialogTitle("Select debug log path");
        this.jfc.setMultiSelectionEnabled(false);
        if (this.jfc.showOpenDialog(this) == 0) {
            this.a.setDebugLogPath(this.jfc.getSelectedFile().getAbsolutePath());
            this.tDebugLog.setText(this.a.getDebugLogPath());
        }
    }

    private void bPropertiesActionPerformed(ActionEvent evt) {
        this.pf = new PropertiesFrame(this);
        this.centerFrame(this.pf);
        this.pf.setVisible(true);
    }

    private void bCapabilitiesActionPerformed(ActionEvent evt) {
        if (this.a != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Application ID: ");
            buffer.append(this.getSupported(this.a.getCapApplicationId()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Application PN: ");
            buffer.append(this.getSupported(this.a.getCapApplicationPN()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Asset Number: ");
            buffer.append(this.getSupported(this.a.getCapAssetNumber()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Audit: ");
            buffer.append(this.getSupported(this.a.getCapAudit()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Bar Codes: ");
            buffer.append(this.getSupported(this.a.getCapBarCodes()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Bar Codes Ext: ");
            buffer.append(this.getSupported(this.a.getCapBarCodesExt()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("BNF Status: ");
            buffer.append(this.getSupported(this.a.getCapBNFStatus()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Bookmark: ");
            buffer.append(this.getSupported(this.a.getCapBookmark()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Boot PN: ");
            buffer.append(this.getSupported(this.a.getCapBootPN()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Calibrate: ");
            buffer.append(this.getSupported(this.a.getCapCalibrate()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Cash box total: ");
            buffer.append(this.getSupported(this.a.getCapCashBoxTotal()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Clear Audit: ");
            buffer.append(this.getSupported(this.a.getCapClearAudit()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Coupon Ext: ");
            buffer.append(this.getSupported(this.a.getCapCouponExt()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Device Paused: ");
            buffer.append(this.getSupported(this.a.getCapDevicePaused()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Device type: ");
            buffer.append(this.getSupported(this.a.getCapDeviceType()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Device resets: ");
            buffer.append(this.getSupported(this.a.getCapDeviceResets()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Device Serial Number: ");
            buffer.append(this.getSupported(this.a.getCapDeviceSerialNumber()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Soft Reset: ");
            buffer.append(this.getSupported(this.a.getCapDeviceSoftReset()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Escrow Timeout: ");
            buffer.append(this.getSupported(this.a.getCapEscrowTimeout()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Flash Download: ");
            buffer.append(this.getSupported(this.a.getCapFlashDownload()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("No push: ");
            buffer.append(this.getSupported(this.a.getCapNoPush()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Orientation ext: ");
            buffer.append(this.getSupported(this.a.getCapOrientationExt()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Pup ext: ");
            buffer.append(this.getSupported(this.a.getCapPupExt()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Set Bezel Type: ");
            buffer.append(this.getSupported(this.a.getCapSetBezel()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Variant ID: ");
            buffer.append(this.getSupported(this.a.getCapVariantId()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Variant PN: ");
            buffer.append(this.getSupported(this.a.getCapVariantPN()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Easitrax: ");
            buffer.append(this.getSupported(this.a.getCapEasitrax()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Test Doc: ");
            buffer.append(this.getSupported(this.a.getCapTestDoc()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Note Retrieved Event: ");
            buffer.append(this.getSupported(this.a.getCapNoteRetrieved()));
            buffer.append(System.getProperty("line.separator"));
            buffer.append("Advanced Bookmark Mode: ");
            buffer.append(this.getSupported(this.a.getCapAdvBookmark()));
            buffer.append(System.getProperty("line.separator"));
            JOptionPane.showMessageDialog(this, buffer.toString());
        }
    }

    private void tEscrowTimeoutActionPerformed(ActionEvent evt) {
        try {
            int billTimeout = 0;
            int barTimeout = 0;
            try {
                billTimeout = Integer.parseInt(this.tEscrowBill.getText());
                if (billTimeout > 127) {
                    billTimeout = 127;
                }
            }
            catch (Exception nfe) {
                // empty catch block
            }
            try {
                barTimeout = Integer.parseInt(this.tEscrowBar.getText());
                if (barTimeout > 127) {
                    barTimeout = 127;
                }
            }
            catch (Exception nfe) {
                // empty catch block
            }
            this.a.specifyEscrowTimeout(billTimeout, barTimeout);
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private void jDebugCheckBoxActionPerformed(ActionEvent evt) {
        try {
            this.a.setDebugLog(this.jDebugCheckBox.isSelected());
            this.bDebugLog.setEnabled(!this.jDebugCheckBox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jExecuteActionPerformed(ActionEvent evt) {
        byte[] reply;
        int i;
        String s = this.jRawCommandField.getText().toUpperCase();
        boolean active = false;
        byte b = 0;
        ArrayList<Byte> cmd = new ArrayList<Byte>();
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                active = true;
                b = (byte)(b << 4);
                b = (byte)(b + (c - 48));
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                active = true;
                b = (byte)(b << 4);
                b = (byte)(b + (c - 65 + 10));
                continue;
            }
            if (!active) continue;
            cmd.add(b);
            active = false;
            b = 0;
        }
        if (active) {
            cmd.add(b);
        }
        if (cmd.size() == 0) {
            return;
        }
        try {
            byte[] z = new byte[cmd.size()];
            for (i = 0; i < z.length; ++i) {
                z[i] = (Byte)cmd.get(i);
            }
            reply = this.a.rawTransaction(z);
        }
        catch (Exception e) {
            this.tOutput.append("Raw Command Error: " + e.getMessage());
            return;
        }
        String r = "Raw Reply: ";
        String asc = " ";
        for (i = 0; i < reply.length; ++i) {
            asc = reply[i] >= 32 && reply[i] < 127 ? asc + (char)reply[i] : asc + ".";
            r = r + String.format("%02X ", reply[i]);
        }
        this.tOutput.append(r + asc);
        this.tOutput.append(System.getProperty("line.separator"));
        this.tOutput.setCaretPosition(this.tOutput.getText().length() - 1);
    }

    private void bClearAuditActionPerformed(ActionEvent evt) {
        try {
            boolean acked = this.a.clearAudit();
            this.tOutput.append("Clear Audit command: " + (acked ? "Acknowledged" : "NAK'd"));
            this.tOutput.append(System.getProperty("line.separator"));
        }
        catch (Exception e) {
            this.showError(e);
        }
    }

    private String getSupported(boolean supported) {
        return supported ? "Supported" : "Not Supported";
    }

    private void setButtonsEnabled(boolean b) {
        this.bClose.setEnabled(b);
        this.bConnect.setEnabled(!b);
        this.bCapabilities.setEnabled(b);
        this.bProperties.setEnabled(b);
        this.bBillTypes.setEnabled(b);
        this.bBillValues.setEnabled(b);
        this.bDeviceInfo.setEnabled(b);
        if (this.a.getCapAudit()) {
            this.bAuditPerformanceQP.setEnabled(b);
            this.bLifeTimeValues.setEnabled(b);
            this.bAuditPerformance.setEnabled(b);
        }
        this.bDeviceInfo.setEnabled(b);
        this.bReset.setEnabled(b);
        this.bStack.setEnabled(b);
        this.bReturn.setEnabled(b);
        this.bCalibrate.setEnabled(b);
        this.bDownload.setEnabled(b);
        this.tEscrowTimeout.setEnabled(b && this.a.getCapEscrowTimeout());
        this.jRawCommandField.setEnabled(b);
        this.jExecute.setEnabled(b);
        this.bClearAudit.setEnabled(b);
    }

    public Acceptor getAcceptor() {
        return this.a;
    }

    private void showError(Exception ex) {
        JOptionPane.showMessageDialog(this, "An exception has been thrown by the driver while executing the command" + System.getProperty("line.separator") + ex.getMessage(), "Error executing command", 0);
        ex.printStackTrace();
    }
}

