/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api.util;

import com.meiglobal.ebds.api.util.Timeoutable;
import java.util.Enumeration;
import java.util.Vector;

public class CustomTimer
implements Runnable {
    private Vector _observers = new Vector(1);
    private final long _timeout;
    private boolean _stopped = false;

    public CustomTimer(long timeout) throws IllegalArgumentException {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must not be less than 1.");
        }
        this._timeout = timeout;
    }

    public void addTimeoutObserver(Timeoutable to) {
        this._observers.addElement(to);
    }

    public void removeTimeoutObserver(Timeoutable to) {
        this._observers.removeElement(to);
    }

    protected final void fireTimeoutOccured() {
        Enumeration e = this._observers.elements();
        while (e.hasMoreElements()) {
            ((Timeoutable)e.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this._stopped = false;
        Thread t = new Thread((Runnable)this, "CustomTimer");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this._stopped = true;
        this.notifyAll();
    }

    public synchronized void run() {
        long now;
        long until = System.currentTimeMillis() + this._timeout;
        while (!this._stopped && until > (now = System.currentTimeMillis())) {
            try {
                this.wait(until - now);
            }
            catch (InterruptedException e) {}
        }
        if (!this._stopped) {
            this.fireTimeoutOccured();
        }
    }
}

