/*
 * Decompiled with CFR 0.152.
 */
package com.meiglobal.ebds.api;

import com.meiglobal.ebds.api.Acceptor;
import com.meiglobal.ebds.api.WrappedSerialPort;
import com.meiglobal.ebds.api.pub.AcceptorException;
import com.meiglobal.ebds.api.pub.State;
import com.meiglobal.ebds.api.util.SerialReadTimeout;
import com.meiglobal.ebds.api.util.Util;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class EBDS_SerialPort
extends WrappedSerialPort {
    public static final byte STX = 2;
    public static final byte ETX = 3;
    private static byte ACKMask = 1;
    private byte[] _bArrCurrentCommand = new byte[0];
    private byte[] _bArrPreviousCommand;
    private byte[] _bArrPreviousReply;
    private Date _dtSent;
    private byte _ackToggleBit = 0;
    private int _nakCount;
    private int _iIdenticalCommandAndReplyCount = 0;
    private Acceptor _acceptor;

    public EBDS_SerialPort(Acceptor acceptor) {
        this._acceptor = acceptor;
    }

    public void resetPort() {
        try {
            this.close();
        }
        catch (Exception closeEx) {
            this._acceptor.log(String.format("Exception during Port Close - %s - %s", closeEx.getClass().toString(), closeEx.getMessage()));
        }
        try {
            this.openPort(this._strPortName);
        }
        catch (Exception openEx) {
            this._acceptor.log(String.format("Exception during Port Re-Open - %s - %s", openEx.getClass().toString(), openEx.getMessage()));
        }
    }

    public synchronized void sendData(byte[] data) throws AcceptorException, IOException {
        this.flushInputStream();
        if (data == null) {
            throw new AcceptorException("Message Payload is null");
        }
        int len = data.length + 4;
        byte[] b = new byte[len];
        b[0] = 2;
        b[1] = (byte)len;
        System.arraycopy(data, 0, b, 2, data.length);
        b[len - 2] = 3;
        b[2] = (byte)(b[2] | this._ackToggleBit);
        b[len - 1] = this.calcCRC(b);
        this._bArrCurrentCommand = b;
        this._dtSent = Calendar.getInstance().getTime();
        this.send(b);
    }

    public synchronized byte[] receive() throws AcceptorException, SerialReadTimeout {
        byte[] reply = new byte[]{};
        int timeout = 250;
        boolean complete = false;
        int lenByte = 0;
        int checkByte = 0;
        int iPtr = 0;
        int iState = 0;
        if (this._acceptor._inSoftResetOneSecondIgnore) {
            this._acceptor._inSoftResetOneSecondIgnore = false;
            Util.sleep(1000L);
            this.flushInputStream();
        }
        if (this._acceptor.getDeviceState() == State.Downloading || this._acceptor.getDeviceState() == State.DownloadRestart || this._acceptor.getDeviceState() == State.DownloadStart) {
            timeout = 1000;
        }
        long start = System.currentTimeMillis();
        while (!complete) {
            if (System.currentTimeMillis() - start > (long)timeout) {
                this.flushInputStream();
                throw new SerialReadTimeout("Did not receive reply in time");
            }
            try {
                if (this._iRead == this._iWrite) {
                    Thread.sleep(25L);
                    continue;
                }
                int bt = this._buffer[this._iRead++];
                switch (iState) {
                    case 0: {
                        if (bt != 2) break;
                        ++iState;
                        break;
                    }
                    case 1: {
                        reply = new byte[bt];
                        reply[iPtr++] = 2;
                        reply[iPtr++] = bt;
                        checkByte = lenByte = bt;
                        ++iState;
                        break;
                    }
                    case 2: {
                        if (iPtr >= lenByte - 2) break;
                        if (iPtr == lenByte - 3) {
                            ++iState;
                        }
                        checkByte = (byte)(checkByte ^ bt);
                        reply[iPtr++] = bt;
                        break;
                    }
                    case 3: {
                        if (bt != 3) {
                            throw new Exception("Invalid Response - Expected ETX. Got: " + bt);
                        }
                        reply[iPtr++] = 3;
                        ++iState;
                        break;
                    }
                    case 4: {
                        if (bt != checkByte) {
                            throw new Exception("Invalid Response - Bad Checksum. Expected: " + checkByte + " Got: " + bt);
                        }
                        reply[iPtr] = bt;
                        complete = true;
                    }
                }
            }
            catch (InterruptedException iEx) {
            }
            catch (Exception ex) {
                this.flushInputStream();
                this.logCommandAndReply(this._bArrCurrentCommand, reply, false);
                throw new AcceptorException("Invalid Operation", ex);
            }
        }
        if (reply.length == this._bArrCurrentCommand.length) {
            boolean replyIdentical = true;
            for (int i = 0; i < reply.length; ++i) {
                if (reply[i] == this._bArrCurrentCommand[i]) continue;
                replyIdentical = false;
                break;
            }
            if (replyIdentical) {
                this.logCommandAndReply(this._bArrCurrentCommand, reply, true);
                throw new AcceptorException("Echo Detected");
            }
        }
        this.logCommandAndReply(this._bArrCurrentCommand, reply, false);
        return reply;
    }

    public boolean getReplyAcked(byte[] reply) {
        if (reply.length < 3) {
            return false;
        }
        if ((reply[2] & ACKMask) == this._ackToggleBit) {
            this._ackToggleBit = (byte)(this._ackToggleBit ^ 1);
            this._nakCount = 0;
            return true;
        }
        ++this._nakCount;
        if (this._nakCount == 8) {
            this._ackToggleBit = (byte)(this._ackToggleBit ^ 1);
            this._nakCount = 0;
        }
        return false;
    }

    protected byte calcCRC(byte[] b) {
        byte start = 0;
        for (int i = 1; i < b[1] - 2; ++i) {
            start = (byte)(start ^ b[i]);
        }
        return start;
    }

    synchronized void flushIdenticalCommands() {
        if (this._iIdenticalCommandAndReplyCount > 0) {
            this._acceptor.log(String.format("    : %d transactions identical to previous.", this._iIdenticalCommandAndReplyCount));
        }
        this._iIdenticalCommandAndReplyCount = 0;
    }

    private synchronized void logCommandAndReply(byte[] command, byte[] reply, boolean wasEchoDiscarded) {
        if (!this._acceptor.getDebugLog()) {
            return;
        }
        boolean isCommandIdentical = true;
        for (int i = 0; i < command.length - 1; ++i) {
            if (this._bArrPreviousCommand == null || i >= this._bArrPreviousCommand.length) {
                isCommandIdentical = false;
                break;
            }
            if (i != 2) {
                if (command[i] == this._bArrPreviousCommand[i]) continue;
                isCommandIdentical = false;
                break;
            }
            if ((command[i] & 0x7E) == (this._bArrPreviousCommand[i] & 0x7E)) continue;
            isCommandIdentical = false;
            break;
        }
        boolean isReplyIdentical = true;
        if (reply.length > 0) {
            for (int i = 0; i < reply.length - 1; ++i) {
                if (this._bArrPreviousReply == null || i >= this._bArrPreviousReply.length) {
                    isReplyIdentical = false;
                } else if (i != 2) {
                    if (reply[i] == this._bArrPreviousReply[i]) continue;
                    isReplyIdentical = false;
                } else {
                    if ((reply[i] & 0x7E) == (this._bArrPreviousReply[i] & 0x7E)) continue;
                    isReplyIdentical = false;
                }
                break;
            }
        } else {
            isReplyIdentical = false;
        }
        if (isCommandIdentical && isReplyIdentical) {
            ++this._iIdenticalCommandAndReplyCount;
        } else {
            if (this._iIdenticalCommandAndReplyCount > 0) {
                this._acceptor.log(String.format("    : %d transactions identical to previous.", this._iIdenticalCommandAndReplyCount));
            }
            this._iIdenticalCommandAndReplyCount = 0;
            StringBuilder commandString = new StringBuilder("SEND: ");
            for (byte b : command) {
                commandString.append(String.format("%02X ", b));
            }
            this._acceptor.log(commandString.toString(), this._dtSent);
            StringBuilder replyString = new StringBuilder("RECV: ");
            if (reply.length > 0) {
                for (byte b : reply) {
                    replyString.append(String.format("%02X ", b));
                }
            } else if (!wasEchoDiscarded) {
                replyString.append("NO REPLY");
            } else {
                replyString.append("ECHO DISCARDED");
            }
            this._acceptor.log(replyString.toString());
            this._bArrPreviousReply = reply;
            this._bArrPreviousCommand = command;
        }
    }
}

