//
//  NPrinterLib.h
//
//  Created by NPI


#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "NCommon.h"


@interface NPrinterLib : NSObject

-(id)init;
-(void)dealloc;

// Method
-(int) NEnumPrinters : (NSMutableString*) o_printers : (int*) o_size;
-(int) NGetPrinterFromID : (NSString*) i_ID : (NSMutableString*) o_printer;
-(int) NDeletePrinter : (NSString*) i_prt;
-(int) NRenamePrinter : (NSString*) i_beforeprt : (NSString*) i_afterprt;
-(int) NGetPrinterInf : (NSString*) i_prt : (NSMutableString*) o_ports : (int*) o_size;
-(bool) NAutoOpen : (int) i_flg;

-(int) NOpenPrinter : (NSString*) i_prt : (bool) i_statusFlg;
-(int) NClosePrinter: (NSString*) i_prt;
-(int) NClosePrinters;

-(int) NPrint : (NSString*) i_prt : (NSString*) i_dat : (int) i_size : (int*) io_jobid;
-(int) NDPrint : (NSString*) i_prt : (NSData*) i_dat : (int) i_size : (int*) io_jobid;
-(int) NImagePrint : (NSString*) i_prt : (UIImage*) i_bmp : (int) i_width : (int) i_height : (int) i_putType : (int*) io_jobid;
-(int) NImagePrintF : (NSString*) i_prt : (NSString*) i_file : (int) i_putType : (int*) io_jobid;
-(int) NBitImagePrint : (NSString*) i_prt : (UIImage*) i_bmp : (int) i_width : (int) i_height : (int*) io_jobid;
-(int) NBitImagePrintF : (NSString*) i_prt : (NSString*) i_file : (int*) io_jobid;

-(int) NGetStatus : (NSString*) i_prt : (int*) o_status;
-(int) NGetInformation : (NSString*) i_prt : (int) i_id : (NSMutableData*) o_dat : (UInt64*) o_time;

-(int) NStartDoc : (NSString*) i_prt : (int*) io_jobid;
-(int) NEndDoc : (NSString*) i_prt;
-(int) NCancelDoc : (NSString*) i_prt;

-(int) NResetPrinter : (NSString*) i_prt;

-(int) NBarcode : (NSString*) i_prt : (NSString*) i_fontName : (UIImage*) i_bmp : (int) i_x : (int) i_y : (int) i_width : (int) i_height : (char*) i_dat : (int) i_size;

-(int) NFirmwareDL : (NSString*) i_prt : (NSString*) i_file : (int) i_errflg : (short*) io_chksum : (int*) io_jobid;
-(int) NWritePrinter : (NSString*) i_prt : (char*) i_rowBuffer : (int) i_nmuSize : (int*) o_nmuSize;
-(bool) NCheckOnline : (NSString*) i_prt;
-(int) NDataConvert : (unsigned char*) i_rawData : (int) i_size : (unsigned char*) o_rawData : (int*) o_size;
-(int) NReadPrinter : (NSString*) i_prt : (char*) o_buffer : (int) i_buffersize : (int*) o_readsize;

-(int) NLogGetLines : (int) i_view : (NSMutableArray*) o_lines;
-(int) NLogGetString : (int) i_view : (NSMutableString*) o_str;
-(int) NLogDelete : (int) i_delflg;
-(int) NLogSetProperty : (NSString*) i_LogType : (int) i_LogSize;

-(int) NBarcode1DGetData : (NSString*) i_fontName : (int*) o_type : (int*) o_width : (int*) o_height : (int*) o_HRI : (int*) o_hexMode : (int*) o_rotate : (int*) o_startBit : (int*) o_stopBit : (NSMutableString*) o_fileName;

-(int) NBarcode1DSetting : (NSString*) i_fontName : (int) i_type : (int) i_width : (int) i_height : (int) i_HRI : (int) i_hexMode : (int) i_rotate : (int) i_startBit : (int) i_stopBit : (NSString*) i_fileName;

@end

