//
//  NCommon.h
//
//  Created by NEI
//

#import <UIKit/UIKit.h>

#ifndef NPrinterLib_NCommon_h
#define NPrinterLib_NCommon_h

#define SDKVERSION                  "1.0.0.0"
#define RELEASEDATE                 "2014/05/20"        // YYYY/MM/DD

#define N_SUCCESS                   0
#define NERR_PRTOPEN                -2
#define NERR_OFFLINE                -5
#define NERR_PRTCLOSE               -6

#define NERR_FILEOPEN               -10
#define NERR_PRTOUTPUT              -13
#define NERR_PRTINPUT               -14

#define NERR_PRTALREADYOPEN         -21
#define NERR_NOHANDLE               -22

#define NERR_NOTSUPPORTED           -40

#define NERR_LOADFROMFILE           -50
#define NERR_IMAGESIZE              -51
#define NERR_LOADBITMAP             -52

#define NERR_DOCNOTSTARTED          -71
#define NERR_ALREADYSTARTDOC        -72

#define NERR_FWFFILE                -80
#define NERR_FWF_CHECKSUM           -81
#define NERR_FWDL_TIMEOUT           -82
#define NERR_FWCHK_TIMEOUT          -83
#define NERR_FWCHK_FOUNDERROR       -84

#define NERR_ARGUMENT               -90
#define NERR_ARGUMENT_01            -91
#define NERR_ARGUMENT_02            -92
#define NERR_ARGUMENT_03            -93
#define NERR_ARGUMENT_04            -94
#define NERR_ARGUMENT_05            -95
#define NERR_ARGUMENT_06            -96
#define NERR_ARGUMENT_07            -97
#define NERR_ARGUMENT_08            -98
#define NERR_ARGUMENT_09            -99

#define NERR_PRTINFO_CREATE         -130
#define NERR_PRTINFO_READ           -131
#define NERR_PRTINFO_WRITE          -132
#define NERR_PRTNAME_ALLOC          -133
#define NERR_PRTNAME_BEFORE         -134
#define NERR_PRTNAME_AFTER          -135
#define NERR_PRTINFO_GET            -136
#define NERR_PRTINFO_ILLEGAL        -137
#define NERR_PRTINFO_DELETE         -138
#define NERR_PRTINFO_NOTFOUND       -139

#define NERR_DEVICE_NOTSUPPORT      -150

#define NERR_BCDSETTINGFILE         -160
#define NERR_CREATEBCDFILE          -161
#define NERR_CREATEBCDDATA          -162
#define NERR_GETBCDDATA             -163

#define NERR_LOGCREATE              -170
#define NERR_LOGDELETE              -171
#define NERR_LOGRENAME              -172
#define NERR_LOGOPEN                -173
#define NERR_LOGWRITE               -174
#define NERR_LOGREAD                -175


// ImagePrint type
#define IMG_RASTER_LINE             0x00
#define IMG_RASTER_BLOCK            0x01
#define IMG_RASTER_GRADATION        0x02
#define IMG_BITIMG                  0x10

#define COLOR_SIZE                  140

const int EXTEND_DATA_SIZE[] =
{
    0,      // 0
    4,
    32,
    8,
    8,
    4,      // 5
    4,
    4,
    4,
    16,
    16,     // 10
    64,
    32,
    32,
    32,
    16,     // 15
    16,
    16,
    16,
    8,
    8,      // 20
    8,
    8,
    8,
    4,
    4,      // 25
    4,
    4,
    2,
    2,
    2,      // 30
    2       // 31
};

#define FWFERRCHECK_OFF             0
#define FWFERRCHECK_ON              1

// ----- Barcode -------------------------
typedef struct brdData
{
    bool    flg1DBarcode;
    int     type;
    int     width;
    int     height;
    int     HRI;
    int     hexMode;
    int     rotate;
    int     startbit;
    int     stopbit;
    char   fileName[256];
} BARCODEDATA;



#define TYPE_UPCA                   0
#define TYPE_UPCE                   1
#define TYPE_EAN13                  2
#define TYPE_EAN8                   3
#define TYPE_CODE39                 4
#define TYPE_ITF                    5
#define TYPE_CODABAR                6
#define TYPE_CODE128                7
#define TYPE_CODE93                 8

#define TYPE_QRCODEMODEL2           0
#define TYPE_PDF417                 1

#define ERR_QRMODEL2_L              0
#define ERR_QRMODEL2_M              1
#define ERR_QRMODEL2_Q              2
#define ERR_QRMODEL2_H              3

#define ERR_PDF417_AUTO             -1

#define HRI_NONE                    0
#define HRI_TOP_FONTA               1
#define HRI_BTM_FONTA               2
#define HRI_BOTH_FONTA              3
#define HRI_TOP_FONTB               4
#define HRI_BTM_FONTB               5
#define HRI_BOTH_FONTB              6

#define FONT_A                      24
#define FONT_B                      17
#define FONT_C                      16

#define ROTATE_NONE                 0
#define ROTATE_90                   1
#define ROTATE_180                  2
#define ROTATE_270                  3

// ----- Log -------------------------
#define LOGSIZE_DEFAULT             1000000

#define LOG_TYPE_ERROR              1
#define LOG_TYPE_WARN               2
#define LOG_TYPE_FUNC               3
#define LOG_TYPE_DATAIN             4
#define LOG_TYPE_DATAOUT            5

#define LOG_STR_ERR                 "[ERR]"
#define LOG_STR_WARN                "[WRN]"
#define LOG_STR_FUNC                "[FNC]"
#define LOG_STR_DATAIN              "[I N]"
#define LOG_STR_DATAOUT             "[OUT]"

#define LOG_CURRENT                 0
#define LOG_BACKUP                  1
#define LOG_BOTH                    2

#endif






