package com.citizen.app.posapplicationen;

import android.app.Activity;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;
import android.widget.RadioButton;
import android.app.AlertDialog;
import android.content.DialogInterface;
import java.util.Calendar;
import java.util.Locale;

import com.citizen.sdk.ESCPOSConst;
import com.citizen.sdk.ESCPOSPrinter;
import com.citizen.sdk.CitizenPrinterInfo;


public class MainActivity extends Activity {

    private int count = 0;


    private class OrderItem {
        public int Id;
        public String Name;
        public double Price;
        public int Num;

        public OrderItem(int id, String name, double price, int num) {
            this.Id = id;
            this.Name = name;
            this.Price = price;
            this.Num = num;
        }
    }

    private OrderItem[] orders = {
            new OrderItem(1001, "hamburger",  3.00, 4),
            new OrderItem(1002, "french fries",  2.00, 2),
            new OrderItem(1003, "orange juice",  1.50, 2),
            new OrderItem(1004, "apple juice",  1.50, 1),
            new OrderItem(1005, "coke",  1.00, 2),
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        setContentView(R.layout.activity_main);

        // Select IF
        final Spinner spinner = (Spinner) findViewById(R.id.spinner);
        if (spinner != null) {
            spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
                @Override
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                    String address = "";
                    int connectType;

                    connectType = getSelectedInterface();
                    if (ESCPOSConst.CMP_PORT_USB == connectType) {
                        address = "null(Automatic Detection)";
                    }
                    setAddress(address);
                }

                @Override
                public void onNothingSelected(AdapterView<?> parent) {
                    Log.e("OnNothingSelected", "NothingSelected");
                }
            });
        }

        // Search
        final Button button_Search = (Button) findViewById(R.id.button_Search);
        if (button_Search != null) {
            button_Search.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {

                    int searchMode = 0;			// SearchMode == 0 : searchCitizenPrinter()
                    							// SearchMode != 0 : searchESCPOSPrinter()
                    int connectType;
                    int timeout;
                    int[] errCode = new int[1];

                    // Create an instance( LabelPrinter class )
                    ESCPOSPrinter printer = new ESCPOSPrinter();

                    // Get selected interface
                    connectType = getSelectedInterface();
                    if (connectType == ESCPOSConst.CMP_PORT_USB) {
                        // Usb interface is Auto Detect only
                        Toast.makeText(MainActivity.this, "USB interface is Automatic Detection only", Toast.LENGTH_LONG).show();
                        return;
                    }

                    // Set context
                    printer.setContext(MainActivity.this);

                    // Get timeout
                    timeout = getSearchTime(connectType);

                    // Search
                    if (searchMode == 0) {
                        // Search Citizen Printer
                        CitizenPrinterInfo list1[] = printer.searchCitizenPrinter(connectType, timeout, errCode);

                        if (list1.length > 0) {

                            final CharSequence[] item = new CharSequence[list1.length];
                            for (int i = 0; i < list1.length; i++) {
                                if (connectType == ESCPOSConst.CMP_PORT_WiFi) {
                                    item[i] = list1[i].ipAddress;
                                } else {
                                    item[i] = list1[i].bdAddress;
                                }
                            }

                            // Search address preview and select
                            new AlertDialog.Builder(MainActivity.this)
                                    .setTitle("Select the address")
                                    .setItems(item,
                                            new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialog, int which) {
                                                    setAddress(String.format("%s", item[which]));
                                                }
                                            })
                                    .show();
                        } else {
                            // 0 search results
                            Toast.makeText(MainActivity.this, "0 Search Results", Toast.LENGTH_LONG).show();
                        }
                    } else {
                        // Search Printer
                        String[] list2 = printer.searchESCPOSPrinter(connectType, timeout, errCode);
                        if (list2.length > 0) {
                            final CharSequence[] item = list2;

                            // Search address preview and select
                            new AlertDialog.Builder(MainActivity.this)
                                    .setTitle("Select the address")
                                    .setItems(item,
                                            new DialogInterface.OnClickListener() {
                                                @Override
                                                public void onClick(DialogInterface dialog, int which) {
                                                    setAddress(String.format("%s", item[which]));
                                                }
                                            })
                                    .show();
                        } else {
                            // 0 search results
                            Toast.makeText(MainActivity.this, "0 Search Results", Toast.LENGTH_LONG).show();
                        }
                    }
                }
            });
        }

        // Btn Receipt
        final Button button_sample1 = (Button) findViewById(R.id.button_sample1);
        if (button_sample1 != null) button_sample1.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                int result;
                int total_Num = 0;
                double amount;
                double total_amount = 0;
                double Tax;
                double Total;
                final double TAX_RATE = 0.08;
                android.graphics.Bitmap bitmap;

                int wordcount1 = 7;
                int wordcount2 = 14;
                int wordcount3 = 3;
                int wordcount4 = 8;
                int wordcount5 = 9;
                int wordcount6 = 7;

                RadioButton radioButton2 = (RadioButton) findViewById(R.id.radioButton2);
                boolean checked3inch = radioButton2.isChecked();
                if (checked3inch) {
                    wordcount1 = 8;
                    wordcount2 = 22;
                    wordcount3 = 6;
                    wordcount4 = 12;
                    wordcount5 = 14;
                    wordcount6 = 10;
                }

                // Create an instance
                ESCPOSPrinter printer = new ESCPOSPrinter();
                // Connect printer
                result = Connect(printer);

                if (result != ESCPOSConst.CMP_SUCCESS) {
                    return;
                }

                // Acquire the date and time
                String strDATE = (String) DateFormat.format("yyyy-MM-dd  kk:mm:ss", Calendar.getInstance());
                // Update of the serial number
                count = count + 1;
                // Set Encording
                printer.setEncoding("ISO-8859-1");
                // Start Transaction ( Batch )
                printer.transactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);
                // Read image file from res folder
                bitmap = android.graphics.BitmapFactory.decodeResource( getResources(), R.drawable.shoplogo );

                // Open Drawer
                printer.openDrawer(ESCPOSConst.CMP_DRAWER_1, 1);

                // Print Text
                printer.printBitmap(bitmap,
                        ESCPOSConst.CMP_BM_ASIS,
                        ESCPOSConst.CMP_ALIGNMENT_CENTER,
                        ESCPOSConst.CMP_BM_MODE_HT_DITHER | ESCPOSConst.CMP_BM_MODE_CMD_RASTER);

                printer.printText("\nThank you very much.\n" + "Looking forward to your visit again.\n",
                        ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_BOLD,
                        ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                printer.printText("ST0001  " + strDATE + "\n\n",
                        ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                        ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                for (int i = 0; i < orders.length; i++) {
                    printer.printPaddingText(String.valueOf(orders[i].Id),
                            ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount1, ESCPOSConst.CMP_SIDE_RIGHT);

                    printer.printPaddingText(orders[i].Name,
                            ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount2, ESCPOSConst.CMP_SIDE_RIGHT);

                    printer.printPaddingText(String.valueOf(orders[i].Num),
                            ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount3, ESCPOSConst.CMP_SIDE_LEFT);

                    amount = orders[i].Price * orders[i].Num;

                    printer.printPaddingText(String.format(Locale.US, "%.2f", amount), ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH, wordcount4, ESCPOSConst.CMP_SIDE_LEFT);

                    printer.printNormal("\n");

                    total_Num += orders[i].Num;

                    total_amount += amount;
                }
                Tax = (total_amount * TAX_RATE);

                Total = (total_amount + Tax);

                printer.printNormal("\n");

                printer.printPaddingText("Sub Total",
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

                printer.printPaddingText(String.format(Locale.US, "%.2f", total_amount),
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount6 * 2, ESCPOSConst.CMP_SIDE_LEFT);

                printer.printNormal("\n");

                printer.printPaddingText("Tax",
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

                printer.printPaddingText(String.format(Locale.US, "%.2f", Tax),
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount6 * 2, ESCPOSConst.CMP_SIDE_LEFT);

                printer.printNormal("\n");

                printer.printPaddingText("Total",
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount5, ESCPOSConst.CMP_SIDE_RIGHT);

                printer.printPaddingText(String.format(Locale.US, "%.2f", Total),
                        ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT,
                        wordcount6, ESCPOSConst.CMP_SIDE_LEFT);

                printer.printNormal("\n\n");

                printer.printText(total_Num + "-items    " + String.format(Locale.US, "%05d", count) + "     OP0101\n\n",
                        ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                        ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                // After feed the paper to the cutting position, partial cut.
                printer.cutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
                /// End Transaction ( Batch )
                result = printer.transactionPrint(ESCPOSConst.CMP_TP_NORMAL);
                /// Disconnect printer
                printer.disconnect();

                Toast.makeText(MainActivity.this, showMessage(result), Toast.LENGTH_SHORT).show();
            }
        });

        // Btn Official bill
        final Button button_sample2 = (Button) findViewById(R.id.button_sample2);
        if (button_sample2 != null) {
            button_sample2.setOnClickListener(new View.OnClickListener() {
                public void onClick(View v) {

                    int result;
                    double amount;
                    double total_amount = 0;
                    double Tax;
                    double Total;
                    final double TAX_RATE = 0.08;

                    // Create an instance
                    ESCPOSPrinter printer = new ESCPOSPrinter();
                    // Connect printer
                    result = Connect(printer);

                    if (result != ESCPOSConst.CMP_SUCCESS) {
                        return;
                    }

                    // Acquire the date and time
                    String strDATE = (String) DateFormat.format("yyyy-MM-dd\n", Calendar.getInstance());
                    // Update of the serial number
                    count = count + 1;
                    // Set Encording
                    printer.setEncoding("ISO-8859-1");
                    // Start Transaction ( Batch )
                    printer.transactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);

                    // Print Text
                    printer.printText("RECEIPT",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                            ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

                    printer.printText("  No." + String.format(Locale.US, "%05d", count) + "\n\n" + strDATE+ "\n",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                            ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                    for (int i = 0; i < orders.length; i++) {
                        amount = orders[i].Price * orders[i].Num;
                        total_amount += amount;
                    }

                    Tax =  (total_amount * TAX_RATE);

                    Total = (total_amount + Tax);

                    printer.printText("         " + String.format(Locale.US, "%.2f", Total) + "- \n\n",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_UNDERLINE | ESCPOSConst.CMP_FNT_BOLD,
                            ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

                    printer.printText("Citizen Systems Europe\n" + "Mettingerstrasse 11\n" + "73728 Esslingen\n" + "Germany\n" + "TEL:xxxx-xx-xxxx\n\n",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                            ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                    // After feed the paper to the cutting position, partial cut.
                    printer.cutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
                    // End Transaction ( Batch )
                    result = printer.transactionPrint(ESCPOSConst.CMP_TP_NORMAL);
                    // Disconnect printer
                    printer.disconnect();

                    Toast.makeText(MainActivity.this, showMessage(result), Toast.LENGTH_SHORT).show();
                }
            });
        }

        // Btn Cooking
        final Button button_sample3 = (Button) findViewById(R.id.button_sample3);
        button_sample3.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                int result;

                int wordcount1 = 18;
                int wordcount2 = 9;

                RadioButton radioButton2 = (RadioButton) findViewById(R.id.radioButton2);
                boolean checked3inch = radioButton2.isChecked();
                if (checked3inch) {
                    wordcount1 = 26;
                    wordcount2 = 13;
                }

                // Create an instance
                ESCPOSPrinter printer = new ESCPOSPrinter();
                // Connect printer
                result = Connect(printer);

                if (result != ESCPOSConst.CMP_SUCCESS) {
                    return;
                }

                // Acquire the date and time
                String strTime = (String) DateFormat.format("kk:mm", Calendar.getInstance());
                // Update of the serial number
                count = count + 1;
                // Set Encording
                printer.setEncoding("ISO-8859-1");
                // Start Transaction ( Batch )
                printer.transactionPrint(ESCPOSConst.CMP_TP_TRANSACTION);
                // Sound the buzzer (The printer must support buzzer.)
                byte[] data = {0x1b, 0x1e, 0x00, 0x1b, 0x1e, 0x00, 0x1b, 0x1e, 0x00};
                printer.printData(data);

                // Print text
                for (int i = 0; i < orders.length; i++) {
                    printer.printText(String.valueOf(orders[i].Num) + "  ",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT);

                    printer.printPaddingText(orders[i].Name,
                            ESCPOSConst.CMP_FNT_DEFAULT, ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT,
                            wordcount1, ESCPOSConst.CMP_SIDE_RIGHT);

                    printer.printNormal("\n");

                    printer.printText(" Single Item ",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT | ESCPOSConst.CMP_FNT_REVERSE,
                            ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                    printer.printPaddingText("A03", ESCPOSConst.CMP_FNT_DEFAULT,
                            ESCPOSConst.CMP_TXT_2WIDTH | ESCPOSConst.CMP_TXT_2HEIGHT,
                            wordcount2, ESCPOSConst.CMP_SIDE_LEFT);

                    printer.printNormal("\n");

                    printer.printText(String.format(Locale.US, "%05d", count) + "   person 2  OP0101 " + strTime + "\n",
                            ESCPOSConst.CMP_ALIGNMENT_CENTER, ESCPOSConst.CMP_FNT_DEFAULT,
                            ESCPOSConst.CMP_TXT_1WIDTH | ESCPOSConst.CMP_TXT_1HEIGHT);

                    // Update of the serial number
                    count = count + 1;
                    // After feed the paper to the cutting position, partial cut.
                    printer.cutPaper(ESCPOSConst.CMP_CUT_PARTIAL_PREFEED);
                }

                // End Transaction ( Batch )
                result = printer.transactionPrint(ESCPOSConst.CMP_TP_NORMAL);
                // Disconnect printer
                printer.disconnect();

                Toast.makeText(MainActivity.this, showMessage(result), Toast.LENGTH_SHORT).show();
            }
        });
    }

    // Connect
    private int Connect(ESCPOSPrinter printer) {
        int connectType;
        String address;
        int result;

        connectType = getSelectedInterface();
        address = getAddress();

        if (connectType == ESCPOSConst.CMP_PORT_USB) {
            printer.setContext(MainActivity.this);
            UsbDevice usbDevice = null;
            result = printer.connect(ESCPOSConst.CMP_PORT_USB, usbDevice);
        } else {
            result = printer.connect(connectType, address);
        }

        if (result != ESCPOSConst.CMP_SUCCESS) {
            Toast.makeText(MainActivity.this, showMessage(result), Toast.LENGTH_SHORT).show();
        }
        return result;
    }


    private int getSearchTime(int connectType) {
        int timeout;

        if (ESCPOSConst.CMP_PORT_WiFi == connectType) {
            timeout = 3;
        } else if ((ESCPOSConst.CMP_PORT_Bluetooth == connectType) || (ESCPOSConst.CMP_PORT_Bluetooth_Insecure == connectType)) {
            timeout = 10;
        } else {
            timeout = 0;
        }
        return timeout;
    }

    private int getSelectedInterface() {
        int selectIF = ESCPOSConst.CMP_PORT_WiFi;
        Spinner spinner = (Spinner) findViewById(R.id.spinner);

        if (spinner != null) {
            selectIF = spinner.getSelectedItemPosition();
        }
        return selectIF;
    }

    private String getAddress() {
        String address = "";
        EditText editText_Address = (EditText) findViewById(R.id.editText_Address);

        if (editText_Address != null) {
            address = editText_Address.getText().toString();
        }
        return address;
    }

    private void setAddress(String address) {
        EditText editText_Address = (EditText) findViewById(R.id.editText_Address);

        if (editText_Address != null) {
            editText_Address.setText(address);
        }
    }

    private String showMessage(int result) {
        String word;
        switch (result) {
            case ESCPOSConst.CMP_SUCCESS:
                word = "The operation is success.";
                break;

            case ESCPOSConst.CMP_E_CONNECTED:
                word = "The printer is already connected.";
                break;

            case ESCPOSConst.CMP_E_DISCONNECT:
                word = "The printer is not connected.";
                break;

            case ESCPOSConst.CMP_E_NOTCONNECT:
                word = "Failed connection to the printer.";
                break;

            case ESCPOSConst.CMP_E_CONNECT_NOTFOUND:
                word = "Failed to check the support model after connecting to the device.";
                break;

            case ESCPOSConst.CMP_E_CONNECT_OFFLINE:
                word = "Failed to check the printer status after connecting to the device.";
                break;

            case ESCPOSConst.CMP_E_ILLEGAL:
                word = "Unsupported operation with the Device, or an invalid parameter value was used.";
                break;

            case ESCPOSConst.CMP_E_OFFLINE:
                word = "The printer is off-line.";
                break;

            case ESCPOSConst.CMP_E_NOEXIST:
                word = "The file name does not exist.";
                break;

            case ESCPOSConst.CMP_E_FAILURE:
                word = "The Service cannot perform the requested procedure.";
                break;

            case ESCPOSConst.CMP_E_TIMEOUT:
                word = "The Service timed out waiting for a response from the printer.";
                break;

            case ESCPOSConst.CMP_E_NO_LIST:
                word = "The printer cannot be found in the printer search.";
                break;

            case ESCPOSConst.CMP_EPTR_COVER_OPEN:
                word = "The cover of the printer opens.";
                break;

            case ESCPOSConst.CMP_EPTR_REC_EMPTY:
                word = "The printer is out of paper.";
                break;

            case ESCPOSConst.CMP_EPTR_BADFORMAT:
                word = "The specified file is in an unsupported format.";
                break;

            case ESCPOSConst.CMP_EPTR_TOOBIG:
                word = "The specified bitmap is either too big.";
                break;

            default:
                word = "The other error.";
                break;
        }
        return word;
    }
}
