package npi.sample.timer;

import java.util.Timer;
import java.util.TimerTask;

import android.os.Handler;
import android.os.Message;

import npi.sdk.NPrinterLib;

public class RepeatPrintTimerTask extends TimerTask
{
	private Timer 			mTimer;
	private NPrinterLib 	mObjLib;
	private String 		mStrPrinter;

	private Handler 		mHandler;

	private int 			mLine;
	private int			mMaxCount;

	private final String	SENDDATA	= "\"HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH\"0A";
	private final String	FEED		= "1B4A50";
	private final String	FULLCUT		= "1B69";

	private int 			mCount;

	private boolean 		flgCutON;


	public RepeatPrintTimerTask(RepeatPrintBean rBean)
	{
		mTimer 			= rBean.getTimer();
		mObjLib 		= rBean.getObjLib();
		mStrPrinter 	= rBean.getStrPrinter();

		mHandler 		= rBean.getHdl();

		mLine			= rBean.getLine();
		mMaxCount		= rBean.getCount();

		mCount			= 0;

		flgCutON		= rBean.isFlgCutON();
	}

	@Override
	public void run()
	{
		int nmsRet = 0;
		Message msg = new Message();

		mCount++;
		msg.arg1 = mCount;

		for(int n = 0; n < mLine; n++)
		{
			nmsRet = mObjLib.NPrint(mStrPrinter, SENDDATA, SENDDATA.length(), null);

			if(nmsRet < 0)
			{
				msg.arg2 = nmsRet;

				mHandler.sendMessage(msg);
				mTimer.cancel();
				return;
			}
		}

		String feedCutCmd = FEED;
		if(flgCutON)
		{
			feedCutCmd += FULLCUT;
		}

		// Feed
		mObjLib.NPrint(mStrPrinter, feedCutCmd, feedCutCmd.length(), null);

		if(mMaxCount != 0 && mCount >= mMaxCount)
		{
			msg.arg2 = 1;
			mTimer.cancel();
		}
		else
		{
			msg.arg2 = 0;
		}

		mHandler.sendMessage(msg);

	}

}
