package npi.sample;

import java.io.UnsupportedEncodingException;

import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

/**
 * NPrint, NDPrint, NStartDoc, NEndDoc, NCancelDoc
 * @author NPI
 *
 */
public class SubForm02 extends Activity implements OnClickListener
{
	// NPI SDK Class
	private NPrinterLib objLib;

	// Use printer name
	private String staPrinterName;

	// Button
	private Button btnNPrint;
	private Button btnNDPrint;
	private Button btnNImagePrintF;
	private Button btnNStartDoc;
	private Button btnNEndDoc;
	private Button btnNCancelDoc;
	private Button btnBack02;

	// TextView
	private TextView txtNPrintRet;
	private TextView txtNDPrintRet;
	private TextView txtNImagePrintFRet;
	private TextView txtNStartDocRet;
	private TextView txtNEndDocRet;
	private TextView txtNCancelDocRet;

	// EditText
	private EditText edtPrintData;
	private EditText edtImageFilePath;

	// Spinner
	private Spinner spnImageTypeSelect;


	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form02);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();

		Intent intentObj = getIntent();
		staPrinterName = intentObj.getStringExtra("PRTNAME");

		// ----- NPrint -----
		btnNPrint	 		= (Button)findViewById(R.id.btnNPrint);
		btnNPrint.setOnClickListener(this);

		txtNPrintRet		= (TextView)findViewById(R.id.txtNPrintRet);
		edtPrintData		= (EditText)findViewById(R.id.edtPrintData);

		// ----- NDPrint -----
		btnNDPrint			= (Button)findViewById(R.id.btnNDPrint);
		btnNDPrint.setOnClickListener(this);

		txtNDPrintRet		= (TextView)findViewById(R.id.txtNDPrintRet);

		// ----- NImagePrintF -----
		btnNImagePrintF		= (Button)findViewById(R.id.btnNImagePrintF);
		btnNImagePrintF.setOnClickListener(this);

		txtNImagePrintFRet	= (TextView)findViewById(R.id.txtNImagePrintFRet);
		edtImageFilePath	= (EditText)findViewById(R.id.edtImagePath);
		spnImageTypeSelect	= (Spinner)findViewById(R.id.spnImageSelect);


		edtImageFilePath.setText(Environment.getExternalStorageDirectory() + "/npi/printer.jpg");


		// ----- NStartDoc -----
		btnNStartDoc		= (Button)findViewById(R.id.btnNStartDoc);
		btnNStartDoc.setOnClickListener(this);

		txtNStartDocRet		= (TextView)findViewById(R.id.txtNStartDocRet);

		// ----- NEndDoc -----
		btnNEndDoc	 		= (Button)findViewById(R.id.btnNEndDoc);
		btnNEndDoc.setOnClickListener(this);

		txtNEndDocRet		= (TextView)findViewById(R.id.txtNEndDocRet);

		// ----- NCancelDoc -----
		btnNCancelDoc		= (Button)findViewById(R.id.btnNCancelDoc);
		btnNCancelDoc.setOnClickListener(this);

		txtNCancelDocRet	= (TextView)findViewById(R.id.txtNCancelDocRet);

		// ----- Back -----
		btnBack02			= (Button)findViewById(R.id.btnBack02);
		btnBack02.setOnClickListener(this);
		btnBack02.setTextColor(Color.RED);
	}

	@Override
	public void onClick(View v)
	{
		int nmsRet;
		byte[] rawSendData;
		NInt objJobID = null;
		String staPrtData = edtPrintData.getText().toString();

		if(v == btnNPrint)
		{
			// NPrint process
			objJobID = new NInt();

			try
			{
				if(objLib.mStrCharSet.equals(""))
				{
					nmsRet = objLib.NPrint(staPrinterName, staPrtData, staPrtData.getBytes().length, objJobID);
				}
				else
				{
					nmsRet = objLib.NPrint(staPrinterName, staPrtData, staPrtData.getBytes(objLib.mStrCharSet).length, objJobID);
				}
			}
			catch (UnsupportedEncodingException e)
			{
				nmsRet = NRet.ERR_CHARSET;
			}

			txtNPrintRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNPrintRet.setTextColor(Color.RED);
			}
			else
			{
				txtNPrintRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNDPrint)
		{
			// NDPrint process
			objJobID = new NInt();

			// Cut command
			rawSendData = new byte[2];
			rawSendData[0] = 0x1B;
			rawSendData[1] = 0x6D;

			nmsRet = objLib.NDPrint(staPrinterName, rawSendData, rawSendData.length, objJobID);

			txtNDPrintRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNDPrintRet.setTextColor(Color.RED);
			}
			else
			{
				txtNDPrintRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNImagePrintF)
		{
			// NImagePrintF process
			objJobID = new NInt();

			// file path
			String strFilePath 	= edtImageFilePath.getText().toString();

			// print image type
			byte bImageType 	= checkImagePrintType();


			nmsRet = objLib.NImagePrintF(staPrinterName, strFilePath, bImageType, objJobID);

			txtNImagePrintFRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNImagePrintFRet.setTextColor(Color.RED);
			}
			else
			{
				txtNImagePrintFRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNStartDoc)
		{
			// NStartDoc process
			objJobID = new NInt();

			nmsRet = objLib.NStartDoc(staPrinterName, objJobID);

			txtNStartDocRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNStartDocRet.setTextColor(Color.RED);
			}
			else
			{
				txtNStartDocRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNEndDoc)
		{
			// NEndDoc process
			nmsRet = objLib.NEndDoc(staPrinterName);

			txtNEndDocRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNEndDocRet.setTextColor(Color.RED);
			}
			else
			{
				txtNEndDocRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNCancelDoc)
		{
			// NCancelDoc process
			nmsRet = objLib.NCancelDoc(staPrinterName);

			txtNCancelDocRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNCancelDocRet.setTextColor(Color.RED);
			}
			else
			{
				txtNCancelDocRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnBack02)
		{
			// Return to the previous screen
			finish();
		}
	}

	private byte checkImagePrintType()
	{
		byte numRet = 0x00;		// default raster line

		String item = (String)spnImageTypeSelect.getSelectedItem();

		if(item.equals("Raster line"))
		{
			numRet = 0x00;
		}
		else if(item.equals("Raster block"))
		{
			numRet = 0x01;
		}
		else if(item.equals("Raster gradation"))
		{
			numRet = 0x02;
		}
		else if(item.equals("Bit image"))
		{
			numRet = 0x10;
		}

		return numRet;
	}
}
