package npi.sample.timer;


import java.util.TimerTask;

import npi.sdk.NPrinterLib;
import npi.sdk.data.NInt;
import android.os.Handler;


public class StatusCheckTimer extends TimerTask
{
	private NPrinterLib objLib;
	private String strPrinter;
	private Handler mStatusHandler;

	public StatusCheckTimer(NPrinterLib objLib, String strPrinter, Handler hdl)
	{
		this.objLib = objLib;
		this.strPrinter = strPrinter;

		mStatusHandler = hdl;

	}

	@Override
	public void run()
	{
		NInt o_status = new NInt();
		int nmsRet = objLib.NGetStatus(strPrinter, o_status);

		if(nmsRet == 0)
		{
			mStatusHandler.sendEmptyMessage(o_status.getValue());
		}
		else
		{
			// Error
			mStatusHandler.sendEmptyMessage(nmsRet);
		}
	}

}
