package npi.sample;

import java.util.HashMap;

import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import npi.sdk.data.NShort;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

/**
 * NBarcode, NImagePrint
 * @author NPI
 *
 */
public class SubForm05 extends Activity implements OnClickListener
{

	// NPI SDK Class
	private NPrinterLib objLib;

	// Use printer name
	private String staPrinterName;

	// Button
	private Button btnNBarcode;
	private Button btnBack05;

	// TextView
	private TextView txtBarcodeRet;
	private TextView txtNImagePrintRet;

	// EditText
	private EditText edtBitmapWidth;
	private EditText edtBitmapHeight;
	private EditText edtBcdX;
	private EditText edtBcdY;
	private EditText edtBcdWidth;
	private EditText edtBcdHeight;
	private EditText edtBcdData;

	// Spinner
	private Spinner spnBcdfontname;
	private Spinner spnImageTypeSelect;

	// barcode data map
	private HashMap<String, String> mapBcdData;

	// test barcode data
	private final String[][] bcdData = {	{"Barcode1"    , "012345678905"},
											{"Barcode2"    , "012345000065"},
											{"Barcode3"    , "4912345678904"},
											{"Barcode4"    , "49123456"},
											{"Barcode5"    , "*ABC12*"},
											{"Barcode6"    , "1234567890"},
											{"Barcode7"    , "123456"},
											{"Barcode8"    , "{A{1AB{Bab"},
											{"Barcode9"    , "ABC12"},
											{"Barcode10"   , "012345678905"},
											{"2D-Barcode1" , "1234567890"},
											{"2D-Barcode2" , "pdf417_TEST"},
											{"2D-Barcode3" , "111222333444"},
											{"2D-Barcode4" , "1234567890"},
											{"2D-Barcode5" , "1234567890"},
										 };




	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form05);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();

		Intent intentObj = getIntent();
		staPrinterName = intentObj.getStringExtra("PRTNAME");

		mapBcdData = new HashMap<String, String>();

		for(int n=0; n < bcdData.length; n++)
		{
			mapBcdData.put(bcdData[n][0], bcdData[n][1]);
		}


		btnNBarcode	 		= (Button)findViewById(R.id.btnNBarcode);
		btnBack05	 		= (Button)findViewById(R.id.btnBack05);

		btnNBarcode.setOnClickListener(this);
		btnBack05.setOnClickListener(this);
		btnBack05.setTextColor(Color.RED);


		txtBarcodeRet		= (TextView)findViewById(R.id.txtNBarcodeRet);
		txtNImagePrintRet	= (TextView)findViewById(R.id.txtNImagePrintRet);


		edtBitmapWidth		= (EditText)findViewById(R.id.edtBitmapWidth);
		edtBitmapHeight		= (EditText)findViewById(R.id.edtBitmapHeight);
		edtBcdX				= (EditText)findViewById(R.id.edtBcdX);
		edtBcdY				= (EditText)findViewById(R.id.edtBcdY);
		edtBcdWidth			= (EditText)findViewById(R.id.edtBcdWidth);
		edtBcdHeight		= (EditText)findViewById(R.id.edtBcdHeight);
		edtBcdData			= (EditText)findViewById(R.id.edtBcdData);

		spnBcdfontname		= (Spinner)findViewById(R.id.spnBcdFont);
		spnImageTypeSelect	= (Spinner)findViewById(R.id.spnImageSelect2);


		spnBcdfontname.setOnItemSelectedListener(new OnItemSelectedListener()
		{
			@Override
			public void onItemSelected(AdapterView<?> arg0, View arg1, int arg2, long arg3)
			{
				Spinner spinner = (Spinner)arg0;
				String item = (String)spinner.getSelectedItem();

				edtBcdData.setText(mapBcdData.get(item));
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0)
			{


			}
		});
	}

	@Override
	public void onClick(View v)
	{
		int nmsRet 			= 0;
		int nmsBitmapWidth 	= 0;
		int nmsBitmapHeight	= 0;
		int nmsX			= 0;
		int nmsY			= 0;
		int nmsWidth 		= 0;
		int nmsHeight 		= 0;

		Bitmap objBitmap	= null;

		byte[] rawDataBuf	= null;

		NInt io_jobid = new NInt();



		if(v == btnNBarcode)
		{
			// get size
			try
			{
				nmsBitmapWidth	= Integer.parseInt(edtBitmapWidth.getText().toString());
				nmsBitmapHeight	= Integer.parseInt(edtBitmapHeight.getText().toString());
				nmsX 			= Integer.parseInt(edtBcdX.getText().toString());
				nmsY 			= Integer.parseInt(edtBcdY.getText().toString());
				nmsWidth 		= Integer.parseInt(edtBcdWidth.getText().toString());
				nmsHeight 		= Integer.parseInt(edtBcdHeight.getText().toString());
			}
			catch(Exception e)
			{
				MessageBox("Barcode size error:" + e.getMessage());
				return;
			}

			// Bitmap area create
			objBitmap = Bitmap.createBitmap(nmsBitmapWidth, nmsBitmapHeight, Bitmap.Config.ARGB_8888);
			objBitmap.eraseColor(Color.YELLOW);

			// NBarcode create
			rawDataBuf = edtBcdData.getText().toString().getBytes();
			nmsRet = objLib.NBarcode(staPrinterName, (String)spnBcdfontname.getSelectedItem(), objBitmap, nmsX, nmsY, nmsWidth, nmsHeight, rawDataBuf, rawDataBuf.length);


			txtBarcodeRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtBarcodeRet.setTextColor(Color.RED);
				return;		// ERROR
			}
			else
			{
				txtBarcodeRet.setTextColor(Color.BLACK);
			}

			// NStartDoc
			nmsRet = objLib.NStartDoc(staPrinterName, io_jobid);
			if(nmsRet != NRet.SUCCESS)
			{
				txtNImagePrintRet.setText("NStartDoc Error:" + nmsRet);
				txtNImagePrintRet.setTextColor(Color.RED);
				return;		// ERROR
			}


			String staStartMsg = "\"Barcode print start!\"0A";
			objLib.NPrint(staPrinterName, staStartMsg, staStartMsg.getBytes().length, io_jobid);

			// Bitmap print
			// print image type
			byte bImageType 	= checkImagePrintType();


			nmsRet = objLib.NImagePrint(staPrinterName, objBitmap, objBitmap.getWidth(), objBitmap.getHeight(), bImageType, io_jobid);

			txtNImagePrintRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtNImagePrintRet.setTextColor(Color.RED);
			}
			else
			{
				txtNImagePrintRet.setTextColor(Color.BLACK);
			}


			String staEndMsg = "\"Barcode print end\"0A0A0A0A1B69";
			objLib.NPrint(staPrinterName, staEndMsg, staEndMsg.getBytes().length, io_jobid);

			// NEndDoc
			nmsRet = objLib.NEndDoc(staPrinterName);



		}
		else if(v == btnBack05)
		{
			// Return to the previous screen
			finish();
		}
	}

	private byte checkImagePrintType()
	{
		byte nmsRet = 0x00;		// default raster line

		String item = (String)spnImageTypeSelect.getSelectedItem();

		if(item.equals("Raster line"))
		{
			nmsRet = 0x00;
		}
		else if(item.equals("Raster block"))
		{
			nmsRet = 0x01;
		}
		else if(item.equals("Raster gradation"))
		{
			nmsRet = 0x02;
		}
		else if(item.equals("Bit image"))
		{
			nmsRet = 0x10;
		}

		return nmsRet;
	}

	private void MessageBox(String msg)
	{
		Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
	}
}
