package npi.sample;

import java.util.Timer;


import npi.sample.timer.StatusCheckTimer;
import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import npi.sdk.data.NLong;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.TypedValue;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

/**
 * NGetStatus, NGetInformation
 * @author NPI
 *
 */
public class SubForm03 extends Activity implements OnClickListener
{
	// NPI SDK Class
	private NPrinterLib objLib;

	// Use printer name
	private String staPrinterName;

	// Button
	private Button btnNGetStatus;
	private Button btnNGetInformation;
	private Button btnBack03;

	// TextView
	private TextView txtNGetStatusRet;
	private TextView[] bitViewArray;
	private TextView txtNGetInfoRet;
	private TextView txtNGetInfoView;

	// Spinner
	private Spinner spnStatusType;
	private Spinner spnExtendNo;


	// Extend information data size
	public static final int[] EXTEND_DATA_SIZE =
	{
		0,		// extend 0inonej
		4,		// 1
		32,
		8,
		8,
		4,		// 5
		4,
		4,
		4,
		16,
		16,		// 10
		64,
		32,
		32,
		32,
		16,		// 15
		16,
		16,
		16,
		8,
		8,		// 20
		8,
		8,
		8,
		4,
		4,		// 25
		4,
		4,
		2,
		2,
		2,		// 30
		2,		// 31
		0		// 32(Error test)
	};


	// Timer(for Status)
	private Timer statusChkTimer;

	private boolean flgAutoStatusON;

    private Handler mStatusHandler = new Handler()
    {
        @Override
        public void handleMessage(Message msg)
        {
        	if(msg.what >= 0)
        	{
				for(int n = 0; n < bitViewArray.length; n++)
				{
					int nmsCheckBit = (int) Math.pow(2, n);

					if((msg.what & nmsCheckBit) == nmsCheckBit)
					{
						bitViewArray[n].setTextColor(Color.RED);
					}
					else
					{
						bitViewArray[n].setTextColor(Color.BLACK);
					}
				}

				txtNGetStatusRet.setText("0");
				txtNGetStatusRet.setTextColor(Color.BLACK);
        	}
        	else
        	{
        		// Error -> Status timer stop
        		txtNGetStatusRet.setText(Integer.toString(msg.what));
        		txtNGetStatusRet.setTextColor(Color.RED);
        		autoStatusStop();
        	}
        }
    };

	@Override
	protected void onPause()
	{
		super.onPause();
		autoStatusStop();
		//System.out.println("onPause SubForm03");
	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form03);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();

		Intent intentObj = getIntent();
		staPrinterName = intentObj.getStringExtra("PRTNAME");

		// ----- NGetStatus -----
		btnNGetStatus	 	= (Button)findViewById(R.id.btnNGetStatus);
		btnNGetStatus.setOnClickListener(this);

		txtNGetStatusRet	= (TextView)findViewById(R.id.txtStatusRet);

		bitViewArray 		= new TextView[8];
		bitViewArray[0]		= (TextView)findViewById(R.id.txtBit0);
		bitViewArray[1]		= (TextView)findViewById(R.id.txtBit1);
		bitViewArray[2]		= (TextView)findViewById(R.id.txtBit2);
		bitViewArray[3]		= (TextView)findViewById(R.id.txtBit3);
		bitViewArray[4]		= (TextView)findViewById(R.id.txtBit4);
		bitViewArray[5]		= (TextView)findViewById(R.id.txtBit5);
		bitViewArray[6]		= (TextView)findViewById(R.id.txtBit6);
		bitViewArray[7]		= (TextView)findViewById(R.id.txtBit7);

		statusChkTimer		= null;
		spnStatusType		= (Spinner)findViewById(R.id.spnAutoStatus);

		// ----- NGetInformation -----
		btnNGetInformation	= (Button)findViewById(R.id.btnNGetInfo);
		btnNGetInformation.setOnClickListener(this);

		txtNGetInfoRet		= (TextView)findViewById(R.id.txtGetInfoRet);

		txtNGetInfoView		= (TextView)findViewById(R.id.txtGetInfoView);

		spnExtendNo			= (Spinner)findViewById(R.id.spnExtendNo);

		// ----- Back -----
		btnBack03			= (Button)findViewById(R.id.btnBack03);
		btnBack03.setOnClickListener(this);
		btnBack03.setTextColor(Color.RED);
	}

	@Override
	public void onClick(View v)
	{
		if(v == btnNGetStatus)
		{
			if(flgAutoStatusON)
			{
				autoStatusStop();
			}
			else if(spnStatusType.getSelectedItem().toString().equals("Auto Status"))
			{
				autoStatusStart();
			}
			else
			{
				manualStatus();
			}
		}
		else if(v == btnNGetInformation)
		{
			getInformationSample();
		}
		else if(v == btnBack03)
		{
			finish();
		}
	}

	private void autoStatusStart()
	{
		// Status thread ON
		statusChkTimer = new Timer();

		StatusCheckTimer stsChkTask = new StatusCheckTimer(objLib, staPrinterName, mStatusHandler);
		statusChkTimer.schedule( stsChkTask, 100, 100);

		btnNGetStatus.setText("Auto status stop");
		btnNGetStatus.setTextColor(Color.RED);
		flgAutoStatusON = true;
	}

	private void autoStatusStop()
	{
		if(statusChkTimer != null)
		{
			statusChkTimer.cancel();
			statusChkTimer = null;
		}

		btnNGetStatus.setText("NGetStatus");
		btnNGetStatus.setTextColor(Color.BLACK);
		flgAutoStatusON = false;
	}

	private void manualStatus()
	{
		int nmsRet;
		NInt o_status = new NInt();
		nmsRet = objLib.NGetStatus(staPrinterName, o_status);

		txtNGetStatusRet.setText(Integer.toString(nmsRet));
		if(nmsRet != NRet.SUCCESS)
		{
			txtNGetStatusRet.setTextColor(Color.RED);
		}
		else
		{
			txtNGetStatusRet.setTextColor(Color.BLACK);
		}

		for(int n = 0; n < bitViewArray.length; n++)
		{
			int nmsCheckBit = (int) Math.pow(2, n);

			if((o_status.getValue() & nmsCheckBit) == nmsCheckBit)
			{
				bitViewArray[n].setTextColor(Color.RED);
			}
			else
			{
				bitViewArray[n].setTextColor(Color.BLACK);
			}
		}
	}

	private void getInformationSample()
	{
		int nmsRet;
		byte nmsExtendNo;
		byte[] rawExtendData;
		long nmsStartTime;
		long nmsloopCheckTime;
		String staExtendData = null;

		// You get extended information type
		nmsExtendNo = Byte.parseByte((String)spnExtendNo.getSelectedItem());

		// Data insertion sequence generation
		rawExtendData = new byte[EXTEND_DATA_SIZE[nmsExtendNo]];

		// Acquisition time
		NLong objTime = new NLong();

		// Issue the NGetInformation first, to obtain a final acquisition time of the data
		nmsRet = objLib.NGetInformation(staPrinterName, nmsExtendNo, rawExtendData, objTime);
		if(nmsRet != NRet.SUCCESS)
		{
			setGetInformationResult(nmsRet);
			return;
		}
		nmsStartTime = objTime.getValue();



		// Sending of printer information acquisition command
		byte[] rawCmdBuf = new byte[3];
		rawCmdBuf[0] = 0x1B;
		rawCmdBuf[1] = 0x73;
		rawCmdBuf[2] = nmsExtendNo;

		nmsRet = objLib.NDPrint(staPrinterName, rawCmdBuf, rawCmdBuf.length, null);
		if(nmsRet != NRet.SUCCESS)
		{
			setGetInformationResult(nmsRet);
			return;
		}


		// Call the NGetInformation again, looping time stamp to be updated (timeout 3 seconds)
		nmsloopCheckTime = System.currentTimeMillis();
		while(nmsloopCheckTime + 3000 > System.currentTimeMillis())
		{
			nmsRet = objLib.NGetInformation(staPrinterName, nmsExtendNo, rawExtendData, objTime);

			if(nmsRet != NRet.SUCCESS)
			{
				txtNGetInfoRet.setText(Integer.toString(nmsRet));
				return;
			}


			if(nmsStartTime < objTime.getValue())
			{
				// Data acquisition completion
				staExtendData = dumpString("Date:"+objTime.getDateString(), rawExtendData, rawExtendData.length);
				break;
			}

			try
			{
				Thread.sleep(50);
			}
			catch (InterruptedException e)
			{
			}
		}



		if(nmsStartTime >= objTime.getValue())
		{
			staExtendData = "Updated data could not be obtained!\r\n" + dumpString("Date:"+objTime.getDateString(), rawExtendData, rawExtendData.length);
		}

		// data display
		txtNGetInfoView.setText(staExtendData);

		// text size setting
		float adjustSize = getAdjustTextSize(txtNGetInfoView.getWidth(), "*** Extend info["+ "Date:"+objTime.getDateString() +"] ***", txtNGetInfoView.getTextSize(), 10f);
		txtNGetInfoView.setTextSize(TypedValue.COMPLEX_UNIT_PX, adjustSize);

		setGetInformationResult(nmsRet);
	}

	/**
	 * A result is set on a screen.
	 * @param numRet
	 */
	private void setGetInformationResult(int numRet)
	{
		txtNGetInfoRet.setText(Integer.toString(numRet));

		if(numRet != NRet.SUCCESS)
		{
			txtNGetInfoRet.setTextColor(Color.RED);
		}
		else
		{
			txtNGetInfoRet.setTextColor(Color.BLACK);
		}
	}


	private static String dumpString(String message, byte[] dumpData, int writeSize)
	{
		if(writeSize > dumpData.length)
		{
			writeSize = dumpData.length;
		}

		StringBuilder strObj = new StringBuilder("*** Extend info["+ message +"] ***\r\n");
		strObj.append("+0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F\r\n");
		strObj.append("------------------------------------------------\r\n");


		StringBuilder dumpStr = new StringBuilder();
		int index = 0;
		while (index < writeSize)
		{
			dumpStr.append(byteToHexString(dumpData[index])).append(" ");

			if(index % 0x10 == 0x0F)
			{
				strObj.append(dumpStr.toString());
				strObj.append("\r\n");
				dumpStr = new StringBuilder();
			}

			index++;
		}


		if(!dumpStr.equals(""))
		{
			strObj.append(dumpStr.toString());
			strObj.append("\r\n");
		}

		return strObj.toString();
	}

	private static String byteToHexString(byte value)
	{
		String staRet = Integer.toHexString((int)value).toUpperCase();
		int nmsLength = staRet.getBytes().length;

		if(nmsLength == 2)
		{
			return staRet;
		}
		else if(nmsLength == 1)
		{
			return "0" + staRet;
		}

		return staRet.substring(nmsLength - 2, nmsLength);
	}

	private float getAdjustTextSize(int width, String text, float initTextSize, float minTextSize)
	{
		Paint paint = new Paint();

		float textWidth;

		float textSize = initTextSize;


		paint.setTextSize(textSize);
		paint.setTypeface(Typeface.MONOSPACE);
		textWidth = paint.measureText(text);


		while (width < textWidth)
		{
			textSize = textSize - 1;


			if (minTextSize > 0 && minTextSize >= textSize)
			{
				textSize = minTextSize;
				break;
			}

			paint.setTextSize(textSize);
			textWidth = paint.measureText(text);
		}
		return textSize;
	}
}
