package npi.sample;


import java.util.Timer;

import npi.sample.timer.RepeatPrintBean;
import npi.sample.timer.RepeatPrintTimerTask;
import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import android.app.Activity;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

/**
 * NPI test class (Repeat test)
 * @author NPI
 *
 */
public class SubForm06 extends Activity implements OnClickListener
{
	private boolean	flgRepeatON;

	// NPI SDK Class
	private NPrinterLib objLib;

	// Use printer name
	private String staPrinterName;

	// Button
	private Button btnRepeatTest;
	private Button btnBack06;

	// EditText
	private EditText edtLine;
	private EditText edtMillSec;
	private EditText edtCount;

	// TextView
	private TextView txtResult;

	// Spinner
	private Spinner spnCutType;

	// Timer
	private Timer repeatPrintTimer;


	private Handler mHandler = new Handler()
	{
		@Override
		public void handleMessage(Message msg)
		{
			int nowCount 	= msg.arg1;
			int nmsRet 		= msg.arg2;

			switch (nmsRet)
	     	{
				case 0:
					txtResult.setText(nowCount + " times OK");
					break;
				case 1:
					txtResult.setText(nowCount + " times OK [Finish]");
					break;
				default:
					txtResult.setText(nowCount + " times NG... error code : "+ nmsRet);
					break;
	     	}
		}
	};

	@Override
	protected void onPause()
	{
		super.onPause();

//		// repeat test OFF
//		if(repeatPrintTimer != null)
//		{
//			repeatPrintTimer.cancel();
//			System.out.println("onPause repeat cancel");
//		}
	}


	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form06);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();

		Intent intentObj = getIntent();
		staPrinterName = intentObj.getStringExtra("PRTNAME");

		repeatPrintTimer = null;


		btnRepeatTest = (Button)findViewById(R.id.btnRepeat);
		btnRepeatTest.setOnClickListener(this);


		btnBack06 = (Button)findViewById(R.id.btnBack06);
		btnBack06.setOnClickListener(this);
		btnBack06.setTextColor(Color.RED);


		edtLine		= (EditText)findViewById(R.id.edtRepeatLine);
		edtMillSec	= (EditText)findViewById(R.id.edtRepeatMsec);
		edtCount	= (EditText)findViewById(R.id.edtRepeatCount);

		txtResult	= (TextView)findViewById(R.id.txtRepeatRet);

		spnCutType	= (Spinner)findViewById(R.id.spnRepeatCutType);
	}

	@Override
	public void onClick(View v)
	{
		if(v == btnRepeatTest)
		{
			if(flgRepeatON)
			{
				this.repeatTestOFF();
			}
			else
			{
				this.repeatTestON();
			}
		}
		else if(v == btnBack06)
		{
			// Return to the previous screen
			repeatTestOFF();
			finish();
		}
	}


	private void repeatTestOFF()
	{
		if(repeatPrintTimer != null)
		{
			repeatPrintTimer.cancel();
		}

		btnRepeatTest.setText("Repeat test Start");
		btnRepeatTest.setTextColor(Color.BLACK);
		flgRepeatON = false;
	}


	private void repeatTestON()
	{
		int nmsLine 	= 0;
		int nmsMillSec 	= 0;
		int nmsCount 	= 0;

		try
		{
			nmsLine = Integer.parseInt(edtLine.getText().toString());

			if(nmsLine <= 0)
			{
				MessageBox("Please specify one or more values.");
				return;
			}
		}
		catch(Exception e)
		{
			MessageBox("Line input error : "+ e.getMessage());
			return;
		}

		try
		{
			nmsMillSec = Integer.parseInt(edtMillSec.getText().toString());

			if(nmsMillSec <= 0)
			{
				MessageBox("Please specify one or more values.");
				return;
			}
		}
		catch(Exception e)
		{
			MessageBox("msec input error : "+ e.getMessage());
			return;
		}

		try
		{
			nmsCount = Integer.parseInt(edtCount.getText().toString());
		}
		catch(Exception e)
		{
			MessageBox("Count input error : "+ e.getMessage());
			return;
		}


		// Repeat thread ON
		repeatPrintTimer = new Timer();

		// Bean create
		RepeatPrintBean rBean = new RepeatPrintBean();
		rBean.setObjLib(objLib);
		rBean.setStrPrinter(staPrinterName);
		rBean.setHdl(mHandler);
		rBean.setTimer(repeatPrintTimer);

		rBean.setLine(nmsLine);
		rBean.setCount(nmsCount);

		if(((String)spnCutType.getSelectedItem()).equals("ON"))
		{
			rBean.setFlgCutON(true);
		}
		else
		{
			rBean.setFlgCutON(false);
		}




		RepeatPrintTimerTask repeatTask = new RepeatPrintTimerTask(rBean);
		repeatPrintTimer.schedule(repeatTask, 100, nmsMillSec);

		btnRepeatTest.setText("Repeat test Stop!");
		btnRepeatTest.setTextColor(Color.RED);
		flgRepeatON = true;
	}


	private void MessageBox(String msg)
	{
		Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
	}
}
