package npi.sample;

import npi.sdk.NCarryLibrary;
import npi.sdk.NPrinterLib;
import npi.sdk.common.NRet;
import npi.sdk.data.NInt;
import npi.sdk.data.NShort;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager.LayoutParams;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

/**
 * NResetPrinter, NFirmwareDL
 * @author NPI
 *
 */
public class SubForm04 extends Activity implements OnClickListener
{
	// NPI SDK Class
	private NPrinterLib objLib;

	// Use printer name
	private String staPrinterName;

	// Button
	private Button btnNResetPrinter;
	private Button btnNFirmwareDL;
	private Button btnNFirmwareResult;
	private Button btnNFirwareCheck;
	private Button btnBack04;

	// TextView
	private TextView txtResetRet;
	private TextView txtFirmwareDLRet;
	private TextView txtFirmwareResultRet;
	private TextView txtFirmwareCheckRet;

	// EditText
	private EditText edtFwfFileName;
	private EditText edtCheckSum;

	// Spinner
	private Spinner spnErrCheck;


	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		this.getWindow().setSoftInputMode(LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
		setContentView(R.layout.sub_form04);

		NCarryLibrary carryObj = (NCarryLibrary) this.getApplication();
		objLib = carryObj.getLibrary();

		Intent intentObj = getIntent();
		staPrinterName = intentObj.getStringExtra("PRTNAME");

		// ----- NResetPrinter -----
		btnNResetPrinter	= (Button)findViewById(R.id.btnNResetPrinter);
		btnNResetPrinter.setOnClickListener(this);

		txtResetRet			= (TextView)findViewById(R.id.txtNResetRet);

		// ----- NFirmwareDL -----
		btnNFirmwareDL	 	= (Button)findViewById(R.id.btnNFirmwareDL);
		btnNFirmwareDL.setOnClickListener(this);

		txtFirmwareDLRet	= (TextView)findViewById(R.id.txtNFWDLRet);

		edtFwfFileName		= (EditText)findViewById(R.id.edtFwfFileName);

		spnErrCheck			= (Spinner)findViewById(R.id.spnErrCheck);

		// ----- NFirmwareResult -----
		btnNFirmwareResult	= (Button)findViewById(R.id.btnNFirmwareResult);
		btnNFirmwareResult.setOnClickListener(this);

		txtFirmwareResultRet = (TextView)findViewById(R.id.txtNFWDLResultRet);


		// ----- NFirmwareDL (check sum comparison) -----
		btnNFirwareCheck	= (Button)findViewById(R.id.btnFirmwareCheck);
		btnNFirwareCheck.setOnClickListener(this);

		txtFirmwareCheckRet	= (TextView)findViewById(R.id.txtFirmwareCheckRet);

		edtCheckSum			= (EditText)findViewById(R.id.edtCheckSum);

		// ----- Back -----
		btnBack04	 		= (Button)findViewById(R.id.btnBack04);
		btnBack04.setOnClickListener(this);
		btnBack04.setTextColor(Color.RED);
	}

	@Override
	public void onClick(View v)
	{
		int nmsRet;
		NShort io_chksum = new NShort();
		NInt io_jobid = new NInt();

		short nmsCheckValue;

		byte bErrCheck = Byte.parseByte((String)spnErrCheck.getSelectedItem());

		if(v == btnNResetPrinter)
		{
			nmsRet = objLib.NResetPrinter(staPrinterName);

			txtResetRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtResetRet.setTextColor(Color.RED);
			}
			else
			{
				txtResetRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNFirmwareDL)
		{
			nmsRet = objLib.NFirmwareDL(staPrinterName, edtFwfFileName.getText().toString(), bErrCheck, io_chksum, io_jobid);


			txtFirmwareDLRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtFirmwareDLRet.setTextColor(Color.RED);
			}
			else
			{
				txtFirmwareDLRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNFirmwareResult)
		{
			nmsRet = objLib.NFirmwareResult(staPrinterName);


			txtFirmwareResultRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtFirmwareResultRet.setTextColor(Color.RED);
			}
			else
			{
				txtFirmwareResultRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnNFirwareCheck)
		{
			try
			{
				nmsCheckValue = Short.parseShort(edtCheckSum.getText().toString(), 16);
				io_chksum.setValue(nmsCheckValue);
			}
			catch(Exception e)
			{
				MessageBox("Incorrect checksum. Please re-enter. Error:" + e.getMessage());
				return;
			}


			nmsRet = objLib.NFirmwareDL(staPrinterName, null, bErrCheck, io_chksum, io_jobid);

			txtFirmwareCheckRet.setText(Integer.toString(nmsRet));
			if(nmsRet != NRet.SUCCESS)
			{
				txtFirmwareCheckRet.setTextColor(Color.RED);
			}
			else
			{
				txtFirmwareCheckRet.setTextColor(Color.BLACK);
			}
		}
		else if(v == btnBack04)
		{
			finish();
		}

	}


	private void MessageBox(String msg)
	{
		Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
	}
}
