/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import npi.sdk.common.NCommon;
import npi.sdk.common.NDocumentData;
import npi.sdk.common.NExData;
import npi.sdk.common.NExDataArray;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NBoolean;
import npi.sdk.data.NInt;
import npi.sdk.data.NLong;
import npi.sdk.data.NShort;
import npi.sdk.data.NString;
import npi.sdk.device.NDeviceInfo;
import npi.sdk.device.NOpenThread;
import npi.sdk.device.bluetooth.NBluetooth;
import npi.sdk.device.usb.NSendData;
import npi.sdk.device.usb.NUsb;
import npi.sdk.device.usb.NUsbBase;
import npi.sdk.image.NImageProcess;

public class NDeviceCtl {
    private Context mContext;
    private NLogWriter NLog;
    private NUsbBase usbBase;
    private boolean flgAutoOpen = true;
    private HashMap<String, NUsb> mapUsbInfo;
    private HashMap<String, NBluetooth> mapBlthInfo;
    private HashMap<String, NDocumentData> documentMap;
    private Object objDocumentLock;
    private int numJobID;
    private Object jobLock;
    private HashMap<String, Integer> recvBufFlgMap;
    private HashMap<String, LinkedList<NSendData>> sendQueueMap;
    private HashSet<String> sendThreadStopSet;
    private HashMap<String, Integer> mapOpenStatus;
    private Object objConnLock;

    public NDeviceCtl(Context i_context, NLogWriter i_NLog) {
        this.mContext = i_context;
        this.NLog = i_NLog;
        this.NLog.func("NDeviceCtl loading...");
        this.usbBase = new NUsbBase(i_context, i_NLog);
        this.sendQueueMap = new HashMap();
        this.sendThreadStopSet = new HashSet();
        this.mapOpenStatus = new HashMap();
        this.mapUsbInfo = new HashMap();
        this.mapBlthInfo = new HashMap();
        this.documentMap = new HashMap();
        this.objDocumentLock = new Object();
        this.numJobID = 1;
        this.jobLock = new Object();
        this.recvBufFlgMap = new HashMap();
        this.objConnLock = new Object();
    }

    protected void finalize() {
        this.NLog.func("NDeviceCtl end...");
        this.allClosePrinter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getJobID(String i_prt) {
        Object object = this.objDocumentLock;
        synchronized (object) {
            if (this.documentMap.containsKey(i_prt)) {
                return this.documentMap.get(i_prt).getJobID();
            }
        }
        object = this.jobLock;
        synchronized (object) {
            this.numJobID = this.numJobID >= 99999 ? 1 : ++this.numJobID;
        }
        return this.numJobID;
    }

    public boolean setAutoOpen(int nOpenType) {
        switch (nOpenType) {
            case 0: {
                this.flgAutoOpen = false;
                break;
            }
            case 1: {
                this.flgAutoOpen = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.NLog.write("NAutoOpen argument warn value:" + nOpenType, 2);
            }
        }
        return this.flgAutoOpen;
    }

    public int getPrinterArray(NString prtInfoStr) {
        int nmsRet;
        ArrayList<String> blthKeyArray;
        HashMap<String, NDeviceInfo> mapEnumInfo = new HashMap<String, NDeviceInfo>();
        ArrayList<String> usbKeyArray = this.usbBase.getDeviceKeyArray();
        if (usbKeyArray != null) {
            for (String usbKey : usbKeyArray) {
                NDeviceInfo dInfo = new NDeviceInfo();
                dInfo.setDeviceType(1);
                dInfo.setDeviceName(usbKey);
                mapEnumInfo.put(usbKey, dInfo);
            }
        }
        if ((blthKeyArray = NBluetooth.getDeviceKeyArray()) != null) {
            for (String blthKey : blthKeyArray) {
                NDeviceInfo dInfo = new NDeviceInfo();
                dInfo.setDeviceType(2);
                dInfo.setDeviceName(blthKey);
                mapEnumInfo.put(blthKey, dInfo);
            }
        }
        if ((nmsRet = this.setPrinterInfoFile(mapEnumInfo, prtInfoStr)) != 0) {
            this.NLog.write("NEnumPrinters error code:" + nmsRet, 1);
            return nmsRet;
        }
        return 0;
    }

    private int setPrinterInfoFile(HashMap<String, NDeviceInfo> mapEnumInfo, NString prtInfoStr) {
        NDeviceInfo dInfo;
        String deviceName = null;
        String printerName = null;
        int deviceType = 0;
        String addPrtName = null;
        BufferedReader brObj = null;
        PrintWriter prObj = null;
        String line = null;
        String[] dataArray = new String[3];
        HashMap<String, NDeviceInfo> fileEnumInfo = new HashMap<String, NDeviceInfo>();
        TreeSet<String> prtSet = new TreeSet<String>();
        TreeSet<String> addFileSet = null;
        String prtInfoFile = String.valueOf(NCommon.getStoragePath()) + "/npi/NPrinterInf";
        File checkFile = new File(prtInfoFile);
        if (!checkFile.exists()) {
            File folder = new File(checkFile.getParent());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            try {
                checkFile.createNewFile();
            }
            catch (Exception e) {
                return -130;
            }
        }
        try {
            try {
                brObj = new BufferedReader(new FileReader(prtInfoFile));
                while ((line = brObj.readLine()) != null) {
                    try {
                        int firstIndex = line.indexOf(",", 0);
                        int secondIndex = line.indexOf(",", firstIndex + 1);
                        dataArray[0] = line.substring(0, firstIndex);
                        dataArray[1] = line.substring(firstIndex + 1, secondIndex);
                        dataArray[2] = line.substring(secondIndex + 1);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    printerName = dataArray[0];
                    try {
                        deviceType = Integer.parseInt(dataArray[1]);
                    }
                    catch (NumberFormatException e) {
                        this.NLog.write("setPrinterInfoFile NumberFormatException:" + dataArray[1], 2);
                        continue;
                    }
                    deviceName = dataArray[2];
                    NDeviceInfo dInfo2 = new NDeviceInfo();
                    dInfo2.setPrinterName(printerName);
                    dInfo2.setDeviceType(deviceType);
                    dInfo2.setDeviceName(deviceName);
                    prtSet.add(printerName);
                    fileEnumInfo.put(deviceName, dInfo2);
                }
            }
            catch (Exception e) {
                try {
                    try {
                        brObj.close();
                    }
                    catch (Exception exception) {
                        brObj = null;
                    }
                }
                finally {
                    brObj = null;
                }
                return -131;
            }
        }
        finally {
            block43: {
                try {
                    try {
                        brObj.close();
                    }
                    catch (Exception exception) {
                        brObj = null;
                        break block43;
                    }
                }
                catch (Throwable throwable) {
                    brObj = null;
                    throw throwable;
                }
                brObj = null;
            }
        }
        for (String tmpDeviceName : mapEnumInfo.keySet()) {
            if (fileEnumInfo.containsKey(tmpDeviceName)) continue;
            addPrtName = this.getNewPrinterName(prtSet);
            if (addPrtName == null) {
                return -133;
            }
            dInfo = mapEnumInfo.get(tmpDeviceName);
            dInfo.setPrinterName(addPrtName);
            fileEnumInfo.put(tmpDeviceName, dInfo);
        }
        addFileSet = new TreeSet<String>();
        try {
            try {
                prObj = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(prtInfoFile), "UTF-8"));
                for (String key : fileEnumInfo.keySet()) {
                    dInfo = (NDeviceInfo)fileEnumInfo.get(key);
                    StringBuilder tmpLine = new StringBuilder(dInfo.getPrinterName());
                    tmpLine.append(",");
                    tmpLine.append(Integer.toString(dInfo.getDeviceType()));
                    tmpLine.append(",");
                    tmpLine.append(dInfo.getDeviceName());
                    addFileSet.add(tmpLine.toString());
                }
                for (String addline : addFileSet) {
                    prObj.println(addline);
                }
            }
            catch (Exception e) {
                this.NLog.error(e);
                if (prObj != null) {
                    prObj.close();
                    prObj = null;
                }
                return -132;
            }
        }
        finally {
            if (prObj != null) {
                prObj.close();
                prObj = null;
            }
        }
        StringBuilder tmpPrtName = new StringBuilder();
        for (String prtName : prtSet) {
            if (!tmpPrtName.toString().equals("")) {
                tmpPrtName.append(",");
            }
            tmpPrtName.append(prtName);
        }
        prtInfoStr.setValue(tmpPrtName.toString());
        return 0;
    }

    private String getNewPrinterName(TreeSet<String> prtSet) {
        String prtName = null;
        int nCount = 1;
        while (nCount <= 999) {
            prtName = String.format("PRT%03d", nCount);
            if (!prtSet.contains(prtName)) {
                prtSet.add(prtName);
                return prtName;
            }
            ++nCount;
        }
        return null;
    }

    public int renamePrinterName(String i_beforeprt, String i_afterprt) {
        BufferedReader objBr = null;
        PrintWriter objPr = null;
        String[] rawDataArray = new String[3];
        String line = null;
        String putLine = null;
        String printerName = null;
        LinkedHashMap<String, String> mapOutput = new LinkedHashMap<String, String>();
        String prtInfoFile = String.valueOf(NCommon.getStoragePath()) + "/npi/NPrinterInf";
        File checkFile = new File(prtInfoFile);
        if (!checkFile.exists()) {
            return -131;
        }
        try {
            try {
                objBr = new BufferedReader(new FileReader(prtInfoFile));
                while ((line = objBr.readLine()) != null) {
                    try {
                        int firstIndex = line.indexOf(",", 0);
                        int secondIndex = line.indexOf(",", firstIndex + 1);
                        rawDataArray[0] = line.substring(0, firstIndex);
                        rawDataArray[1] = line.substring(firstIndex + 1, secondIndex);
                        rawDataArray[2] = line.substring(secondIndex + 1);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    printerName = rawDataArray[0];
                    mapOutput.put(printerName, line);
                }
            }
            catch (Exception e) {
                this.NLog.error(e);
                try {
                    try {
                        objBr.close();
                    }
                    catch (Exception exception) {
                        objBr = null;
                    }
                }
                finally {
                    objBr = null;
                }
                return -131;
            }
        }
        finally {
            block36: {
                try {
                    try {
                        objBr.close();
                    }
                    catch (Exception exception) {
                        objBr = null;
                        break block36;
                    }
                }
                catch (Throwable throwable) {
                    objBr = null;
                    throw throwable;
                }
                objBr = null;
            }
        }
        if (!mapOutput.containsKey(i_beforeprt)) {
            return -134;
        }
        if (mapOutput.containsKey(i_afterprt)) {
            return -135;
        }
        try {
            try {
                objPr = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(prtInfoFile), "UTF-8"));
                for (String key : mapOutput.keySet()) {
                    putLine = (String)mapOutput.get(key);
                    if (i_beforeprt.equals(key)) {
                        int firstIndex = putLine.indexOf(",", 0);
                        int secondIndex = putLine.indexOf(",", firstIndex + 1);
                        rawDataArray[0] = putLine.substring(0, firstIndex);
                        rawDataArray[1] = putLine.substring(firstIndex + 1, secondIndex);
                        rawDataArray[2] = putLine.substring(secondIndex + 1);
                        putLine = i_afterprt + "," + rawDataArray[1] + "," + rawDataArray[2];
                    }
                    objPr.println(putLine);
                }
            }
            catch (Exception e) {
                this.NLog.error(e);
                if (objPr != null) {
                    objPr.close();
                }
                return -132;
            }
        }
        finally {
            if (objPr != null) {
                objPr.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int openPrinter(String i_prt, boolean i_statusFlg) {
        boolean flgFirstConnect = false;
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        NString portInf = new NString();
        int numRet = NCommon.getPrinterInf(i_prt, portInf);
        if (numRet != 0) {
            return numRet;
        }
        try {
            String[] infArray = new String[2];
            int firstIndex = portInf.getValue().indexOf(",", 0);
            infArray[0] = portInf.getValue().substring(0, firstIndex);
            infArray[1] = portInf.getValue().substring(firstIndex + 1);
            int numDeviceType = Integer.parseInt(infArray[0]);
            String deviceName = infArray[1];
            Object object = this.objConnLock;
            synchronized (object) {
                switch (numDeviceType) {
                    case 0: {
                        this.NLog.warn("Serial is not supported by Android");
                        numRet = -150;
                    }
                    case 1: {
                        usbObj = this.mapUsbInfo.get(i_prt);
                        if (usbObj != null) {
                            if (usbObj.getFlgOpen()) {
                                return -21;
                            }
                        } else {
                            usbObj = new NUsb(this.mContext, this.NLog, this.usbBase, this.recvBufFlgMap, this.sendQueueMap, this.sendThreadStopSet, this.mapOpenStatus);
                            flgFirstConnect = true;
                        }
                        if (usbObj.connect(i_prt, deviceName, i_statusFlg) != 0) return -2;
                        if (!flgFirstConnect) return numRet;
                        this.mapUsbInfo.put(i_prt, usbObj);
                        break;
                    }
                    case 2: {
                        blthObj = this.mapBlthInfo.get(i_prt);
                        if (blthObj != null) {
                            if (blthObj.getFlgOpen()) {
                                return -21;
                            }
                        } else {
                            blthObj = new NBluetooth(this.NLog, i_prt, this.sendQueueMap, this.sendThreadStopSet);
                            flgFirstConnect = true;
                        }
                        if (blthObj.connect(deviceName, i_statusFlg) != 0) return -2;
                        if (!flgFirstConnect) return numRet;
                        this.mapBlthInfo.put(i_prt, blthObj);
                        break;
                    }
                    default: {
                        this.NLog.error("printer info device type illegal:" + numDeviceType);
                        return -137;
                    }
                }
                return numRet;
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            return -137;
        }
    }

    public int closePrinter(String i_prt) {
        NUsb objUsb = null;
        NBluetooth objBlth = null;
        objUsb = this.mapUsbInfo.get(i_prt);
        objBlth = this.mapBlthInfo.get(i_prt);
        if (objUsb != null && (objUsb.getFlgOpen() || objUsb.getFlgRetry())) {
            this.NLog.error("FlgOpen:" + objUsb.getFlgOpen() + " FlgRetry:" + objUsb.getFlgRetry());
            objUsb = this.mapUsbInfo.get(i_prt);
            objUsb.setFlgSendStop(true);
        } else if (objBlth != null && (objBlth.getFlgOpen() || objBlth.getFlgRetry())) {
            objBlth = this.mapBlthInfo.get(i_prt);
            objBlth.setFlgSendStop(true);
        } else {
            return -22;
        }
        this.setOpenResult(i_prt, 100);
        return 0;
    }

    public void allClosePrinter() {
        for (String key : this.mapUsbInfo.keySet()) {
            this.closePrinter(key);
        }
        for (String key : this.mapBlthInfo.keySet()) {
            this.closePrinter(key);
        }
    }

    public boolean checkBluetooth(String i_prt) {
        NBluetooth objBlth = this.mapBlthInfo.get(i_prt);
        return objBlth == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(String i_prt, byte[] i_rowBuffer, int i_nmuSize, NInt o_nmuSize, boolean bFirst) {
        int nmsRet = 0;
        NUsb objUsb = this.mapUsbInfo.get(i_prt);
        NBluetooth objBlth = this.mapBlthInfo.get(i_prt);
        LinkedList<NSendData> sendQueue = null;
        if (objUsb != null) {
            if (objUsb.getFlgOpen()) {
                NSendData sData = new NSendData();
                sData.setSendBuf(i_rowBuffer);
                sData.setSendSize(i_nmuSize);
                LinkedList<NSendData> linkedList = sendQueue = this.sendQueueMap.get(i_prt);
                synchronized (linkedList) {
                    if (sendQueue.offer(sData)) {
                        o_nmuSize.setValue(i_nmuSize);
                    }
                }
                return 0;
            }
            if (objUsb.getFlgRetry()) {
                return -22;
            }
        } else if (objBlth != null) {
            if (objBlth.getFlgOpen()) {
                NSendData sData = new NSendData();
                sData.setSendBuf(i_rowBuffer);
                sData.setSendSize(i_nmuSize);
                LinkedList<NSendData> linkedList = sendQueue = this.sendQueueMap.get(i_prt);
                synchronized (linkedList) {
                    if (sendQueue.offer(sData)) {
                        o_nmuSize.setValue(i_nmuSize);
                    }
                }
                return 0;
            }
            if (objBlth.getFlgRetry()) {
                return -22;
            }
        }
        if (this.flgAutoOpen) {
            if (bFirst) {
                NOpenThread objOpen = new NOpenThread(i_prt, true, this.NLog, this);
                objOpen.start();
                nmsRet = this.write(i_prt, i_rowBuffer, i_nmuSize, o_nmuSize, false);
            } else {
                NSendData sData = new NSendData();
                sData.setSendBuf(i_rowBuffer);
                sData.setSendSize(i_nmuSize);
                LinkedList<NSendData> linkedList = sendQueue = this.sendQueueMap.get(i_prt);
                synchronized (linkedList) {
                    if (sendQueue.offer(sData)) {
                        o_nmuSize.setValue(i_nmuSize);
                    }
                }
            }
        } else {
            nmsRet = -22;
        }
        return nmsRet;
    }

    public int getStatus(String i_prt, NInt o_status, boolean bFirst) {
        int nmsRet = 0;
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        o_status.setValue(255);
        if (this.mapUsbInfo.containsKey(i_prt) && this.mapUsbInfo.get(i_prt).getFlgOpen()) {
            usbObj = this.mapUsbInfo.get(i_prt);
            o_status.setValue(usbObj.getUSBStatus());
        } else if (this.mapBlthInfo.containsKey(i_prt) && this.mapBlthInfo.get(i_prt).getFlgOpen()) {
            blthObj = this.mapBlthInfo.get(i_prt);
            o_status.setValue(blthObj.getBlthStatus());
        } else if (this.flgAutoOpen) {
            // empty if block
        }
        if (o_status.getValue() == 255) {
            nmsRet = -5;
        }
        return nmsRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInformation(String i_prt, byte i_id, byte[] o_dat, NLong o_time, boolean bFirst) {
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        NExDataArray exArray = null;
        NExData dInfo = null;
        if (this.mapUsbInfo.containsKey(i_prt) && this.mapUsbInfo.get(i_prt).getFlgOpen()) {
            usbObj = this.mapUsbInfo.get(i_prt);
            exArray = usbObj.getUSBExtendInfo();
        } else if (this.mapBlthInfo.containsKey(i_prt) && this.mapBlthInfo.get(i_prt).getFlgOpen()) {
            blthObj = this.mapBlthInfo.get(i_prt);
            exArray = blthObj.getExtendInfo();
        } else {
            if (this.flgAutoOpen && bFirst) {
                return -22;
            }
            return -22;
        }
        if (exArray == null) {
            return -22;
        }
        dInfo = exArray.getData(i_id);
        Object object = exArray.objLock;
        synchronized (object) {
            this.NLog.write(NCommon.getDateString(dInfo.getTimeStamp()), dInfo.getBuffer(), 4);
            System.arraycopy(dInfo.getBuffer(), 0, o_dat, 0, o_dat.length);
            if (o_time != null) {
                o_time.setValue(dInfo.getTimeStamp());
            }
        }
        return 0;
    }

    public boolean checkOnline(String i_prt, boolean bFirst) {
        boolean bOnlineRet = false;
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        if (this.mapUsbInfo.containsKey(i_prt) && this.mapUsbInfo.get(i_prt).getFlgOpen()) {
            usbObj = this.mapUsbInfo.get(i_prt);
            bOnlineRet = usbObj.getOnline();
        } else if (this.mapBlthInfo.containsKey(i_prt) && this.mapBlthInfo.get(i_prt).getFlgOpen()) {
            blthObj = this.mapBlthInfo.get(i_prt);
            bOnlineRet = blthObj.getOnline();
        } else if (this.flgAutoOpen) {
            // empty if block
        }
        return bOnlineRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetPrinter(String i_prt, boolean bFirst) {
        boolean bRet = false;
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        LinkedList<NSendData> sendQueue = null;
        if (bFirst) {
            this.cancelDocument(i_prt);
        }
        if (this.mapUsbInfo.containsKey(i_prt) && this.mapUsbInfo.get(i_prt).getFlgOpen()) {
            usbObj = this.mapUsbInfo.get(i_prt);
            bRet = usbObj.resetPrinter();
        } else if (this.mapBlthInfo.containsKey(i_prt) && this.mapBlthInfo.get(i_prt).getFlgOpen()) {
            blthObj = this.mapBlthInfo.get(i_prt);
            bRet = false;
        } else if (this.flgAutoOpen) {
            if (bFirst) {
                NOpenThread objOpen = new NOpenThread(i_prt, true, this.NLog, this);
                objOpen.start();
                bRet = this.resetPrinter(i_prt, false);
            } else {
                NSendData sData = new NSendData();
                sData.setFlgReset(true);
                LinkedList<NSendData> linkedList = sendQueue = this.sendQueueMap.get(i_prt);
                synchronized (linkedList) {
                    sendQueue.offer(sData);
                }
                bRet = true;
            }
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startDocument(String i_prt, NInt o_jobid) {
        Object object = this.objDocumentLock;
        synchronized (object) {
            block4: {
                if (!this.documentMap.containsKey(i_prt)) break block4;
                return -72;
            }
            NDocumentData docData = new NDocumentData();
            int nmsJobid = this.getJobID(i_prt);
            docData.setJobID(nmsJobid);
            o_jobid.setValue(nmsJobid);
            this.documentMap.put(i_prt, docData);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int endDocument(String i_prt) {
        int nmsRet = 0;
        NInt o_nmuSize = null;
        NDocumentData docData = null;
        Object object = this.objDocumentLock;
        synchronized (object) {
            block5: {
                if (this.documentMap.containsKey(i_prt)) break block5;
                return -71;
            }
            docData = this.documentMap.remove(i_prt);
        }
        if (docData != null && docData.getDataBuffer() != null) {
            o_nmuSize = new NInt();
            nmsRet = this.write(i_prt, docData.getDataBuffer(), docData.getDataBuffer().length, o_nmuSize, true);
        }
        return nmsRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelDocument(String i_prt) {
        Object object = this.objDocumentLock;
        synchronized (object) {
            block4: {
                if (this.documentMap.containsKey(i_prt)) break block4;
                return -71;
            }
            this.documentMap.remove(i_prt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int documentWrite(String i_prt, byte[] i_rowBuffer, int i_nmuSize, NBoolean bDocument) {
        Object object = this.objDocumentLock;
        synchronized (object) {
            if (this.documentMap.containsKey(i_prt)) {
                bDocument.setValue(true);
                this.documentMap.get(i_prt).addDataBuffer(i_rowBuffer, i_nmuSize);
            }
        }
        return 0;
    }

    public byte[] imagePrint(String i_prt, Bitmap i_bmp, int i_width, int i_height, byte i_putType, NInt numRet) {
        byte[] putBuff = null;
        switch (i_putType) {
            case 0: 
            case 1: 
            case 2: {
                putBuff = NImageProcess.RasterOutHex(i_prt, i_bmp, i_width, i_height, i_putType, this.NLog);
                break;
            }
            case 16: {
                putBuff = NImageProcess.BitImageOutHex(i_prt, i_bmp, i_width, i_height, this.NLog);
                break;
            }
            default: {
                numRet.setValue(-90);
                return null;
            }
        }
        if (putBuff == null) {
            numRet.setValue(-52);
            return null;
        }
        numRet.setValue(0);
        return putBuff;
    }

    public int setProtocol(String i_prt, int i_type) {
        if (i_type == 0 || i_type == 1) {
            this.recvBufFlgMap.put(i_prt, new Integer(i_type));
        }
        if (!this.recvBufFlgMap.containsKey(i_prt)) {
            return 0;
        }
        return this.recvBufFlgMap.get(i_prt);
    }

    public byte[] imagePrintFile(String i_prt, String i_file, byte i_putType, NInt objRet) {
        Bitmap i_bmp = BitmapFactory.decodeFile((String)i_file);
        if (i_bmp == null) {
            objRet.setValue(-50);
            return null;
        }
        return this.imagePrint(i_prt, i_bmp, i_bmp.getWidth(), i_bmp.getHeight(), i_putType, objRet);
    }

    /*
     * Unable to fully structure code
     */
    public int firmwareDL(String i_prt, String i_file, boolean flgErrCheck, NShort io_chksum, NInt io_jobid) {
        block33: {
            gsCmd01 = new byte[]{29, 71, 1};
            gsCmd21 = new byte[]{29, 71, 33};
            fwfSendCmd = new byte[]{29, 100};
            numCheckSum = 0;
            o_status = new NInt();
            o_nmuSize = new NInt();
            flgFirstCheck = true;
            flgPrintStartCheck = true;
            br = null;
            if (!flgErrCheck) break block33;
            nmsRet = this.getStatus(i_prt, o_status, true);
            if (nmsRet != 0) {
                this.NLog.error("status check error in firmware download:" + nmsRet, i_prt);
                return nmsRet;
            }
            if (o_status.getValue() != 0) {
                this.NLog.error("Status found error in firmware download:" + nmsRet, i_prt);
                return -84;
            }
            checkTime = System.currentTimeMillis();
            nmsRet = this.write(i_prt, gsCmd01, gsCmd01.length, o_nmuSize, true);
            if (nmsRet == 0) ** GOTO lbl48
            this.NLog.error("NFirmwareDL send error[1] = ", i_prt);
            return nmsRet;
lbl-1000:
            // 1 sources

            {
                nmsRet = this.getStatus(i_prt, o_status, true);
                if (nmsRet == -5) {
                    this.NLog.error("NFirmwareDL status error[1] = " + nmsRet, i_prt);
                    return nmsRet;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException var19_17) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < checkTime + 3000L) continue;
                if (flgFirstCheck) {
                    nmsRet = this.write(i_prt, gsCmd21, gsCmd21.length, o_nmuSize, true);
                    if (nmsRet != 0) {
                        this.NLog.error("NFirmwareDL send error[2] = ", i_prt);
                        return nmsRet;
                    }
                    checkTime = System.currentTimeMillis();
                    flgFirstCheck = false;
                    continue;
                }
                flgPrintStartCheck = false;
                break;
lbl48:
                // 3 sources

                ** while ((o_status.getValue() & 128) == 0)
            }
lbl49:
            // 2 sources

            checkTime = System.currentTimeMillis();
            o_status.setValue(0);
            while (!flgPrintStartCheck && o_status.getValue() != 255) {
                nmsRet = this.getStatus(i_prt, o_status, true);
                if (nmsRet == -5) {
                    this.NLog.error("NFirmwareDL status error[2] = " + nmsRet, i_prt);
                    return nmsRet;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException var19_19) {
                    // empty catch block
                }
                if (System.currentTimeMillis() < checkTime + 3000L) continue;
                this.NLog.error("NFirmwareDL check error = -82", i_prt);
                return -82;
            }
        }
        if ((nmsRet = this.startDocument(i_prt, io_jobid)) != 0) {
            this.NLog.error("NFirmwareDL StartDoc error = " + nmsRet, i_prt);
            return nmsRet;
        }
        bDocument = new NBoolean();
        nmsRet = this.documentWrite(i_prt, fwfSendCmd, fwfSendCmd.length, bDocument);
        if (nmsRet != 0) {
            this.NLog.error("NFirmwareDL send error[3] = " + nmsRet, i_prt);
            return nmsRet;
        }
        nCount = 0;
        tmpStr = new StringBuilder();
        try {
            try {
                br = new BufferedReader(new FileReader(i_file));
                while ((line = br.readLine()) != null) {
                    if (++nCount == 4) {
                        numCheckSum = Short.parseShort(line, 16);
                    }
                    if (nCount <= 4) continue;
                    tmpStr.append(line);
                }
            }
            catch (Exception e) {
                this.NLog.error(e);
                this.cancelDocument(i_prt);
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException var24_24) {
                        // empty catch block
                    }
                }
                return -80;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException var24_26) {}
            }
        }
        nmsRet = this.documentWrite(i_prt, tmpStr.toString().getBytes(), tmpStr.toString().getBytes().length, bDocument);
        if (nmsRet != 0) {
            this.NLog.error("NFirmwareDL send error[4] = " + nmsRet, i_prt);
            return nmsRet;
        }
        nmsRet = this.endDocument(i_prt);
        if (nmsRet != 0) {
            this.NLog.error("NFirmwareDL EndDoc error = " + nmsRet, i_prt);
            return nmsRet;
        }
        if (io_chksum != null) {
            io_chksum.setValue(numCheckSum);
            this.NLog.func("NFirmwareDL new checkSum:" + numCheckSum, i_prt);
        }
        return 0;
    }

    public int firmwareDLEndCheck(String i_prt) {
        int nmsRet = 0;
        NInt objStatus = new NInt();
        nmsRet = this.getStatus(i_prt, objStatus, true);
        if (nmsRet != 0 && nmsRet != -5) {
            this.NLog.error("NFirmwareDL error = " + nmsRet, i_prt);
            return nmsRet;
        }
        nmsRet = objStatus.getValue();
        if (nmsRet >= 128) {
            return nmsRet;
        }
        return this.getOpenResult(i_prt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int firmwareCheck(String i_prt, NShort io_chksum) {
        byte[] chkSumBuf = null;
        BufferedReader objbr = null;
        byte[] checkCmd = new byte[]{27, 115, 28};
        byte[] o_dat = new byte[2];
        NLong o_time = new NLong();
        try {
            chkSumBuf = this.convertCheckSum(io_chksum);
            long checkBeforeTime = System.currentTimeMillis();
            NInt o_nmuSize = new NInt();
            int numRet = this.write(i_prt, checkCmd, checkCmd.length, o_nmuSize, true);
            if (numRet != 0) {
                this.NLog.error("Firmware check send data error:" + numRet, i_prt);
                int n = numRet;
                return n;
            }
            long startTime = System.currentTimeMillis();
            while (startTime + 3000L > System.currentTimeMillis()) {
                numRet = this.getInformation(i_prt, (byte)28, o_dat, o_time, true);
                if (numRet != 0) {
                    this.NLog.error("Firmware check get extend data error:" + numRet, i_prt);
                    int n = numRet;
                    return n;
                }
                if (checkBeforeTime >= o_time.getValue()) continue;
            }
            if (checkBeforeTime >= o_time.getValue()) {
                return -83;
            }
            if (chkSumBuf[0] != o_dat[0]) return -81;
            if (chkSumBuf[1] == o_dat[1]) return 0;
            return -81;
        }
        catch (Exception e) {
            this.NLog.error(e);
            return -80;
        }
        finally {
            if (objbr != null) {
                try {
                    objbr.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private byte[] convertCheckSum(NShort io_chksum) {
        byte[] buf = new byte[]{(byte)(io_chksum.getValue() >> 8), (byte)io_chksum.getValue()};
        return buf;
    }

    public void setOpenResult(String i_prt, int numResult) {
        if (this.mapOpenStatus.containsKey(i_prt)) {
            this.mapOpenStatus.remove(i_prt);
        }
        this.mapOpenStatus.put(i_prt, new Integer(numResult));
    }

    public int getOpenResult(String i_prt) {
        int numRet = 100;
        if (this.mapOpenStatus.containsKey(i_prt)) {
            numRet = this.mapOpenStatus.get(i_prt);
        }
        return numRet;
    }

    public HashMap<String, LinkedList<NSendData>> getSendQueueMap() {
        return this.sendQueueMap;
    }

    public HashSet<String> getSendThreadStopSet() {
        return this.sendThreadStopSet;
    }

    public int readData(String i_prt, byte[] o_buffer, int i_buffersize, NInt o_readsize) {
        int numRet;
        NUsb usbObj = null;
        NBluetooth blthObj = null;
        if (this.mapUsbInfo.containsKey(i_prt) && this.mapUsbInfo.get(i_prt).getFlgOpen()) {
            usbObj = this.mapUsbInfo.get(i_prt);
            numRet = usbObj.usbRecvForReadPrinter(o_buffer, i_buffersize, o_readsize);
        } else if (this.mapBlthInfo.containsKey(i_prt) && this.mapBlthInfo.get(i_prt).getFlgOpen()) {
            blthObj = this.mapBlthInfo.get(i_prt);
            numRet = blthObj.blthRecvForReadPrinter(o_buffer, i_buffersize, o_readsize);
        } else {
            numRet = -22;
        }
        return numRet;
    }
}

