/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;

public class NLogWriter {
    private final String DATE_PATTERN = "yyyy/MM/dd HH:mm:ss.SSS";
    private String strFileName;
    private PrintWriter pwObj;
    private int nMaxSize;
    protected HashSet<Integer> setLogType;
    private Object syncObj;
    private SimpleDateFormat sdf;

    public NLogWriter(String strFileName, int nMaxSize, ArrayList<Integer> logTypeArray) {
        this.strFileName = strFileName;
        this.nMaxSize = nMaxSize;
        this.sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        this.setLogType = new HashSet();
        if (logTypeArray != null && logTypeArray.size() > 0) {
            int index = 0;
            while (index < logTypeArray.size()) {
                this.setLogType.add(logTypeArray.get(index));
                ++index;
            }
        }
        this.syncObj = new Object();
    }

    private int open() {
        if (this.strFileName == null || this.strFileName.equals("")) {
            return -10;
        }
        File folder = new File(new File(this.strFileName).getParent());
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!this.checkExistFileSize()) {
            return -10;
        }
        File file = null;
        try {
            this.pwObj = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.strFileName, true), "UTF-8"));
            file = new File(this.strFileName);
            file.setWritable(true, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -10;
        }
        return 0;
    }

    private boolean checkExistFileSize() {
        File file = new File(this.strFileName);
        File newFile = null;
        if (file.exists() && this.nMaxSize <= (int)file.length()) {
            newFile = new File(String.valueOf(this.strFileName) + ".bk");
            if (newFile.exists() && !newFile.delete()) {
                return false;
            }
            if (!file.renameTo(newFile)) {
                return false;
            }
        }
        return true;
    }

    public int error(String strMsg) {
        return this.write(strMsg, 1);
    }

    public int warn(String strMsg) {
        return this.write(strMsg, 2);
    }

    public int func(String strMsg) {
        return this.write(strMsg, 3);
    }

    public int error(String strMsg, String prtName) {
        return this.write(strMsg + " Printer[" + prtName + "]", 1);
    }

    public int warn(String strMsg, String prtName) {
        return this.write(strMsg + " Printer[" + prtName + "]", 2);
    }

    public int func(String strMsg, String prtName) {
        return this.write(strMsg + " Printer[" + prtName + "]", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(String strMsg, int nLogType) {
        String dateStr;
        if (!this.setLogType.contains(nLogType)) {
            return -120;
        }
        String strLogType = "[???]";
        switch (nLogType) {
            case 1: {
                strLogType = "[ERR]";
                break;
            }
            case 2: {
                strLogType = "[WRN]";
                break;
            }
            case 3: {
                strLogType = "[FNC]";
                break;
            }
            case 4: {
                strLogType = "[I N]";
                break;
            }
            case 5: {
                strLogType = "[OUT]";
                break;
            }
        }
        Object object = this.sdf;
        synchronized (object) {
            dateStr = this.sdf.format(new Date());
        }
        StringBuilder writeBuff = new StringBuilder(dateStr);
        writeBuff.append(" ");
        writeBuff.append(strLogType);
        writeBuff.append(" ");
        writeBuff.append(strMsg);
        object = this.syncObj;
        synchronized (object) {
            block20: {
                int nRet = this.open();
                if (nRet == 0) break block20;
                int n = nRet;
                this.close();
                return n;
            }
            try {
                try {
                    this.pwObj.println(writeBuff.toString());
                    this.pwObj.flush();
                }
                catch (Exception e) {
                    this.close();
                    return -121;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.close();
            }
            return 0;
        }
    }

    public int error(Exception e) {
        int nRet;
        StringWriter stringWriter;
        block10: {
            stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            nRet = this.write(stringWriter.toString(), 1);
            try {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {
                    printWriter = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                printWriter = null;
                throw throwable;
            }
            printWriter = null;
        }
        try {
            try {
                stringWriter.close();
            }
            catch (Exception exception) {
                stringWriter = null;
            }
        }
        finally {
            stringWriter = null;
        }
        return nRet;
    }

    public int write(String message, byte[] dumpData, int nLogType) {
        return this.write(message, dumpData, dumpData.length, nLogType);
    }

    public int write(String message, byte[] dumpData, int writeSize, int nLogType) {
        if (writeSize > dumpData.length) {
            writeSize = dumpData.length;
        }
        int nRet = this.write("*** DumpLog[" + message + "] ***", nLogType);
        nRet = this.write("+0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F", nLogType);
        nRet = this.write("------------------------------------------------", nLogType);
        if (nRet < 0) {
            return nRet;
        }
        StringBuilder dumpStr = new StringBuilder();
        int index = 0;
        while (index < writeSize) {
            dumpStr.append(this.byteToHexString(dumpData[index])).append(" ");
            if (index % 16 == 15) {
                nRet = this.write(dumpStr.toString(), nLogType);
                if (nRet < 0) {
                    return nRet;
                }
                dumpStr = new StringBuilder();
            }
            ++index;
        }
        if (!dumpStr.equals("") && (nRet = this.write(dumpStr.toString(), nLogType)) < 0) {
            return nRet;
        }
        return 0;
    }

    private String byteToHexString(byte value) {
        String retStr = Integer.toHexString(value).toUpperCase();
        int length = retStr.getBytes().length;
        if (length == 2) {
            return retStr;
        }
        if (length == 1) {
            return "0" + retStr;
        }
        return retStr.substring(length - 2, length);
    }

    private void close() {
        if (this.pwObj != null) {
            try {
                try {
                    this.pwObj.flush();
                    this.pwObj.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.pwObj = null;
                }
            }
            finally {
                this.pwObj = null;
            }
        }
    }

    protected void finalize() {
        this.close();
        this.syncObj = null;
    }
}

