/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.image;

import android.graphics.Bitmap;
import java.util.Arrays;
import npi.sdk.common.NByteBuffer;
import npi.sdk.common.NLogWriter;

public class NImageProcess {
    public static byte[] RasterOutHex(String i_prt, Bitmap i_bmp, int i_width, int i_height, byte i_putType, NLogWriter NLog) {
        NByteBuffer retBuf = new NByteBuffer();
        byte[] wk = new byte[8];
        byte[] imgcmd = new byte[5];
        byte[] lfcmd = new byte[3];
        imgcmd[0] = 27;
        imgcmd[1] = i_putType == 2 ? 101 : 98;
        imgcmd[2] = (byte)(i_width / 8);
        if (i_width % 8 > 0) {
            imgcmd[2] = (byte)(imgcmd[2] + 1);
        }
        if (i_putType != 0) {
            imgcmd[3] = (byte)(i_height % 256);
            imgcmd[4] = (byte)(i_height / 256);
        } else {
            imgcmd[3] = 1;
            imgcmd[4] = 0;
        }
        lfcmd[0] = 27;
        lfcmd[1] = 74;
        lfcmd[2] = 0;
        int width = i_bmp.getWidth();
        int height = i_bmp.getHeight();
        int[] pixels = new int[width * height];
        i_bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        try {
            if (i_putType != 0) {
                retBuf.addBuffer(imgcmd);
            }
            int y = 0;
            while (y < i_height) {
                int n;
                byte owk;
                if (i_putType == 0) {
                    retBuf.addBuffer(imgcmd);
                }
                int x = 0;
                while (x < i_width) {
                    int color = pixels[x + y * width];
                    int colorB = (color & 0xFF0000) >> 16;
                    int colorG = (color & 0xFF00) >> 8;
                    int colorR = color & 0xFF;
                    if (i_putType != 2) {
                        wk[x % 8] = (colorR + colorG + colorB) / 3 < 140 ? (byte)1 : 0;
                        if (x % 8 == 7) {
                            owk = 0;
                            int n2 = 0;
                            while (n2 < 8) {
                                owk = (byte)(owk | wk[n2] << 7 - n2);
                                ++n2;
                            }
                            retBuf.addBuffer(owk);
                            Arrays.fill(wk, (byte)0);
                        }
                    } else {
                        owk = (byte)((colorB + colorG + colorR) / 3);
                        owk = ~owk;
                        retBuf.addBuffer(owk);
                    }
                    ++x;
                }
                if (i_putType != 2) {
                    if (i_width % 8 > 0) {
                        owk = 0;
                        n = 0;
                        while (n < 8) {
                            owk = (byte)(owk | wk[n] << 7 - n);
                            ++n;
                        }
                        retBuf.addBuffer(owk);
                    }
                } else if (i_width % 8 > 0) {
                    owk = 0;
                    n = i_width % 8;
                    while (n < 8) {
                        owk = 0;
                        retBuf.addBuffer(owk);
                        ++n;
                    }
                }
                if (i_putType == 0) {
                    retBuf.addBuffer(lfcmd);
                }
                ++y;
            }
            if (i_putType != 0) {
                retBuf.addBuffer(lfcmd);
            }
        }
        catch (Exception e) {
            NLog.error(e);
            return null;
        }
        return retBuf.getBuffer();
    }

    public static byte[] BitImageOutHex(String i_prt, Bitmap i_bmp, int i_width, int i_height, NLogWriter NLog) {
        int rowinf = 24;
        NByteBuffer retBuf = new NByteBuffer();
        byte[] wk = null;
        byte[] imgcmd = new byte[5];
        byte[] lfcmd = new byte[3];
        imgcmd[0] = 27;
        imgcmd[1] = 42;
        imgcmd[2] = 35;
        imgcmd[3] = (byte)(i_width % 256);
        imgcmd[4] = (byte)(i_width / 256);
        lfcmd[0] = 27;
        lfcmd[1] = 74;
        lfcmd[2] = 0;
        wk = new byte[24 * i_width];
        Arrays.fill(wk, (byte)0);
        int width = i_bmp.getWidth();
        int height = i_bmp.getHeight();
        int[] pixels = new int[width * height];
        i_bmp.getPixels(pixels, 0, width, 0, 0, width, height);
        try {
            int n;
            int cnt;
            byte owk;
            int i;
            int y = 0;
            while (y < i_height) {
                int x = 0;
                while (x < i_width) {
                    int color = pixels[x + y * width];
                    int colorR = color & 0xFF;
                    int colorG = (color & 0xFF00) >> 8;
                    int colorB = (color & 0xFF0000) >> 16;
                    wk[y % 24 * i_width + x] = (colorR + colorG + colorB) / 3 < 140 ? (byte)1 : 0;
                    ++x;
                }
                if (y % 24 == 23) {
                    retBuf.addBuffer(imgcmd);
                    i = 0;
                    while (i < i_width) {
                        owk = 0;
                        cnt = 0;
                        n = 0;
                        while (n < rowinf) {
                            owk = (byte)(owk | wk[n * i_width + i] << 7 - cnt);
                            if (n != 0 && n % 8 == 7) {
                                retBuf.addBuffer(owk);
                                owk = 0;
                                cnt = -1;
                            }
                            ++cnt;
                            ++n;
                        }
                        ++i;
                    }
                    retBuf.addBuffer(lfcmd);
                    Arrays.fill(wk, (byte)0);
                }
                ++y;
            }
            if (i_height % rowinf > 0) {
                retBuf.addBuffer(imgcmd);
                i = 0;
                while (i < i_width) {
                    owk = 0;
                    cnt = 0;
                    n = 0;
                    while (n < rowinf) {
                        owk = (byte)(owk | wk[n * i_width + i] << 7 - cnt);
                        if (n != 0 && n % 8 == 7) {
                            retBuf.addBuffer(owk);
                            owk = 0;
                            cnt = -1;
                        }
                        ++cnt;
                        ++n;
                    }
                    ++i;
                }
                retBuf.addBuffer(lfcmd);
            }
        }
        catch (Exception e) {
            NLog.error(e);
            return null;
        }
        return retBuf.getBuffer();
    }
}

