/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.usb;

import java.util.LinkedList;
import npi.sdk.common.NCommon;
import npi.sdk.common.NLogWriter;
import npi.sdk.device.usb.NSendData;
import npi.sdk.device.usb.NUsb;

public class NUsbSendThread
extends Thread {
    private NLogWriter NLog;
    private NUsb usbObj;

    public NUsbSendThread(NLogWriter NLog, NUsb usbObj) {
        this.NLog = NLog;
        this.usbObj = usbObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            this.NLog.func("USB send thread start Thread Id:" + this.getId(), this.usbObj.getPrinterName());
            NSendData objData = null;
            LinkedList<NSendData> sendQueue = null;
            while (true) {
                if ((sendQueue = this.usbObj.getSendQueue(this.usbObj.getPrinterName())) == null) {
                    this.NLog.error("USB send thread queue error");
                    break block8;
                }
                LinkedList<NSendData> linkedList = sendQueue;
                synchronized (linkedList) {
                    objData = sendQueue.poll();
                }
                if (objData == null) {
                    if (!this.usbObj.getFlgSendStop()) {
                        NCommon.sleep(10L);
                        continue;
                    }
                    break block8;
                }
                if (objData.getFlgReset()) {
                    if (this.usbObj.resetPrinter()) continue;
                    this.NLog.error("USB reset printer error!!", this.usbObj.getPrinterName());
                    break block8;
                }
                if (!this.usbObj.sendData(objData.getSendBuf(), objData.getSendSize(), null)) break;
            }
            this.NLog.error("USB send data error!!", this.usbObj.getPrinterName());
        }
        this.usbObj.close();
        this.usbObj.setOpenFlg(100);
        this.NLog.func("USB send thread end... Thread Id:" + this.getId(), this.usbObj.getPrinterName());
    }
}

