/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import npi.sdk.barcode.NBarcodeConvert;
import npi.sdk.common.NBarcodeData;
import npi.sdk.common.NCommon;
import npi.sdk.common.NIniFileOperation;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NBoolean;
import npi.sdk.data.NInt;
import npi.sdk.data.NLong;
import npi.sdk.data.NShort;
import npi.sdk.data.NString;
import npi.sdk.device.NDeviceCtl;
import npi.sdk.device.NOpenThread;

public class NPrinterLib {
    public final String SDKVERSION = "1.1.0.0 / 2014.02.14";
    private NLogWriter NLog;
    private NDeviceCtl objDevice;
    private HashMap<String, NBarcodeData> mapBcdFontName;
    private NBarcodeConvert bcdConvert;
    public String mStrCharSet = "";

    public NPrinterLib(Context context) {
        this.setLogFileSetting();
        this.NLog.func("NPrinterLib loading...");
        this.setBarcodeSetting();
        this.setCharSet();
        this.objDevice = new NDeviceCtl(context, this.NLog);
        this.bcdConvert = new NBarcodeConvert(this.NLog);
    }

    private void setCharSet() {
        BufferedReader objBr = null;
        String line = null;
        String settingFile = String.valueOf(NCommon.getStoragePath()) + "/npi/NCharSetInf";
        File objFile = new File(settingFile);
        if (!objFile.exists()) {
            return;
        }
        try {
            objBr = new BufferedReader(new FileReader(objFile));
            line = objBr.readLine();
            if (line != null) {
                this.mStrCharSet = line;
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            this.NLog.error("Charset load error!");
        }
    }

    protected void finalize() {
        this.objDevice = null;
    }

    public int NEnumPrinters(NString o_printers, NInt o_size) {
        this.NLog.func("NEnumPrinters start");
        if (o_printers == null) {
            this.NLog.error("NEnumPrinters error code:-91");
            return -91;
        }
        int nmsRet = this.objDevice.getPrinterArray(o_printers);
        if (nmsRet != 0) {
            this.NLog.error("NEnumPrinters get printer name error:" + nmsRet);
            return nmsRet;
        }
        if (o_size != null) {
            o_size.setValue(o_printers.getValue().getBytes().length);
            this.NLog.func("NEnumPrinters o_size:" + o_size.getValue());
        }
        this.NLog.func("NEnumPrinters success io_printers:" + o_printers.getValue());
        return 0;
    }

    public int NRenamePrinter(String i_beforeprt, String i_afterprt) {
        this.NLog.func("NRenamePrinter start i_beforeprt:" + i_beforeprt + " i_afterprt:" + i_afterprt);
        if (!this.renameStringCheck(i_beforeprt)) {
            this.NLog.error("NRenamePrinter error code:-91");
            return -91;
        }
        if (!this.renameStringCheck(i_afterprt) || i_beforeprt.equals(i_afterprt)) {
            this.NLog.error("NRenamePrinter error code:-92");
            return -92;
        }
        if (this.NCheckOnline(i_beforeprt)) {
            this.NLog.error("NRenamePrinter error code:-21");
            return -21;
        }
        int nmsRet = this.objDevice.renamePrinterName(i_beforeprt, i_afterprt);
        if (nmsRet != 0) {
            this.NLog.error("NRenamePrinter error:" + nmsRet);
            return nmsRet;
        }
        this.NLog.func("NRenamePrinter success");
        return 0;
    }

    private boolean renameStringCheck(String i_prt) {
        if (i_prt == null || i_prt.equals("")) {
            return false;
        }
        if (i_prt.getBytes().length != i_prt.length()) {
            return false;
        }
        if (i_prt.length() > 50) {
            return false;
        }
        int index = 0;
        while (index < NCommon.RENAMEPRINTER_CHECK.length) {
            if (i_prt.indexOf(NCommon.RENAMEPRINTER_CHECK[index]) != -1) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public int NGetPrinterInf(String i_prt, NString o_ports, NInt o_size) {
        this.NLog.write("NGetPrinterInf start  i_prt:" + i_prt, 3);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NGetPrinterInf error code:-91", i_prt);
            return -91;
        }
        if (o_ports == null) {
            this.NLog.error("NGetPrinterInf error code:-92", i_prt);
            return -92;
        }
        int nmsRet = NCommon.getPrinterInf(i_prt, o_ports);
        if (nmsRet != 0) {
            this.NLog.error("NRenamePrinter error:" + nmsRet, i_prt);
            return nmsRet;
        }
        if (o_size != null) {
            o_size.setValue(o_ports.getValue().getBytes().length);
            this.NLog.func("NGetPrinterInf o_size:" + o_size.getValue(), i_prt);
        }
        this.NLog.func("NGetPrinterInf success o_ports:" + o_ports.getValue(), i_prt);
        return 0;
    }

    public boolean NAutoOpen(int i_flg) {
        this.NLog.func("NAutoOpen start  i_flg:" + i_flg);
        boolean flgRet = this.objDevice.setAutoOpen(i_flg);
        this.NLog.func("NAutoOpen success result:" + flgRet);
        return flgRet;
    }

    public void NOpenPrinter(String i_prt, boolean i_statusFlg) {
        NOpenThread objOpen = new NOpenThread(i_prt, i_statusFlg, this.NLog, this.objDevice);
        objOpen.start();
    }

    public int NOpenResult(String i_prt) {
        int nmsRet = this.objDevice.getOpenResult(i_prt);
        this.NLog.func("NOpenResult result:" + nmsRet);
        return nmsRet;
    }

    public int NClosePrinter(String i_prt) {
        this.NLog.func("NClosePrinter start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NClosePrinter error code:-91", i_prt);
            return -91;
        }
        int nmsRet = this.objDevice.closePrinter(i_prt);
        if (nmsRet != 0) {
            this.NLog.error("NClosePrinter error Result Code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NClosePrinter success", i_prt);
        return 0;
    }

    public int NClosePrinters() {
        this.NLog.func("NClosePrinters start");
        this.objDevice.allClosePrinter();
        this.NLog.func("NClosePrinter success");
        return 0;
    }

    public int NPrint(String i_prt, String i_dat, int i_size, NInt io_jobid) {
        byte[] buffData = null;
        this.NLog.func("NPrint start  i_prt:" + i_prt + " i_dat:" + i_dat + " i_size:" + i_size);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NPrint error code:-91", i_prt);
            return -91;
        }
        if (i_dat == null || i_dat.equals("")) {
            this.NLog.error("NPrint error code:-92", i_prt);
            return -92;
        }
        if (i_size <= 0) {
            this.NLog.error("NPrint error code:-93", i_prt);
            return -93;
        }
        NInt objNumSize = new NInt(0);
        try {
            buffData = this.mStrCharSet == null || this.mStrCharSet.equals("") ? i_dat.getBytes() : i_dat.getBytes(this.mStrCharSet);
        }
        catch (UnsupportedEncodingException e1) {
            this.NLog.error("NPrint convert error = -15", i_prt);
            return -15;
        }
        int nmsRet = this.NDataConvert(buffData, i_size, null, objNumSize);
        if (nmsRet != 0) {
            this.NLog.error("NPrint convert error[1] = " + nmsRet, i_prt);
            return -90;
        }
        if (objNumSize.getValue() == 0) {
            this.NLog.warn("NPrint warn print size = 0", i_prt);
            return 0;
        }
        byte[] rawOData = new byte[objNumSize.getValue()];
        if (rawOData == null || rawOData.length <= 0) {
            this.NLog.error("NPrint error = -31 create buffer length =" + objNumSize.getValue(), i_prt);
            return -31;
        }
        nmsRet = this.NDataConvert(buffData, i_size, rawOData, objNumSize);
        if (nmsRet != 0) {
            this.NLog.error("NPrint convert error[2] = " + nmsRet, i_prt);
            return -90;
        }
        int nmsJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(nmsJobID);
        }
        NInt objWroteSize = new NInt(0);
        nmsRet = this.NWritePrinter(i_prt, rawOData, objNumSize.getValue(), objWroteSize);
        if (nmsRet != 0) {
            this.NLog.error("NPrint write error:" + nmsRet + " jobID:" + nmsJobID, i_prt);
            return nmsRet;
        }
        this.NLog.func("NPrint success wrote size:" + objWroteSize.getValue() + " jobID:" + nmsJobID, i_prt);
        return 0;
    }

    public int NDPrint(String i_prt, byte[] i_dat, int i_size, NInt io_jobid) {
        NInt objWroteSize;
        int numRet;
        this.NLog.func("NDPrint start i_size:" + i_size, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NDPrint error code:-91", i_prt);
            return -91;
        }
        if (i_dat == null || i_dat.length < 1) {
            this.NLog.error("NDPrint error code:-92", i_prt);
            return -92;
        }
        if (i_size < 1) {
            this.NLog.error("NDPrint error code:-93", i_prt);
            return -93;
        }
        int nmsJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(nmsJobID);
        }
        if ((numRet = this.NWritePrinter(i_prt, i_dat, i_size, objWroteSize = new NInt(0))) != 0) {
            this.NLog.error("NDPrint write error:" + numRet + " jobID:" + nmsJobID, i_prt);
            return numRet;
        }
        this.NLog.func("NDPrint success wrote size:" + objWroteSize.getValue() + " jobID:" + nmsJobID, i_prt);
        return 0;
    }

    public int NImagePrint(String i_prt, Bitmap i_bmp, int i_width, int i_height, byte i_putType, NInt io_jobid) {
        this.NLog.func("NImagePrint start i_width:" + i_width + " i_height:" + i_height + " i_putType:" + i_putType, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NImagePrint error code:-91", i_prt);
            return -91;
        }
        if (i_bmp == null) {
            this.NLog.error("NImagePrint error code:-92", i_prt);
            return -92;
        }
        if (i_width <= 0 || i_bmp.getWidth() < i_width) {
            this.NLog.error("NImagePrint error code:-93", i_prt);
            return -93;
        }
        if (i_height <= 0 || i_bmp.getHeight() < i_height) {
            this.NLog.error("NImagePrint error code:-94", i_prt);
            return -94;
        }
        switch (i_putType) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                break;
            }
            default: {
                this.NLog.error("NImagePrint error code:-95", i_prt);
                return -95;
            }
        }
        int nmsJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(nmsJobID);
        }
        byte[] rawPrtBuff = null;
        NInt objRet = new NInt();
        rawPrtBuff = this.objDevice.imagePrint(i_prt, i_bmp, i_width, i_height, i_putType, objRet);
        if (rawPrtBuff == null) {
            this.NLog.error("NImagePrint error code:" + objRet.getValue() + " jobID:" + nmsJobID, i_prt);
            return objRet.getValue();
        }
        NInt objWroteSize = new NInt(0);
        int nmsRet = this.NWritePrinter(i_prt, rawPrtBuff, rawPrtBuff.length, objWroteSize);
        if (nmsRet != 0) {
            this.NLog.error("NImagePrint write error:" + nmsRet + " jobID:" + nmsJobID, i_prt);
            return nmsRet;
        }
        this.NLog.func("NImagePrint success wrote size:" + objWroteSize.getValue() + " jobID:" + nmsJobID, i_prt);
        return 0;
    }

    public int NImagePrintF(String i_prt, String i_file, byte i_putType, NInt io_jobid) {
        this.NLog.func("NImagePrintF start i_file:" + i_file + " i_putType:" + i_putType, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NImagePrintF error code:-91", i_prt);
            return -91;
        }
        if (i_file == null || i_file.equals("")) {
            this.NLog.error("NImagePrintF error code:-92", i_prt);
            return -92;
        }
        switch (i_putType) {
            case 0: 
            case 1: 
            case 2: 
            case 16: {
                break;
            }
            default: {
                this.NLog.error("NImagePrintF error code:-93", i_prt);
                return -93;
            }
        }
        int nmsJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(nmsJobID);
        }
        byte[] rawPrtBuff = null;
        NInt objRet = new NInt();
        rawPrtBuff = this.objDevice.imagePrintFile(i_prt, i_file, i_putType, objRet);
        if (rawPrtBuff == null) {
            this.NLog.error("NImagePrint error code:" + objRet.getValue() + " jobID:" + nmsJobID, i_prt);
            return objRet.getValue();
        }
        NInt objWroteSize = new NInt(0);
        int nmsRet = this.NWritePrinter(i_prt, rawPrtBuff, rawPrtBuff.length, objWroteSize);
        if (nmsRet != 0) {
            this.NLog.error("NImagePrintF write error:" + nmsRet + " jobID:" + nmsJobID, i_prt);
            return nmsRet;
        }
        this.NLog.func("NImagePrintF success wrote size:" + objWroteSize.getValue() + " jobID:" + nmsJobID, i_prt);
        return 0;
    }

    public int NBitImagePrint(String i_prt, Bitmap i_bmp, int i_width, int i_height, NInt io_jobid) {
        this.NLog.func("NBitImagePrint start i_width:" + i_width + " i_height:" + i_height, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NBitImagePrint error code:-91", i_prt);
            return -91;
        }
        if (i_bmp == null) {
            this.NLog.error("NBitImagePrint error code:-92", i_prt);
            return -92;
        }
        if (i_width <= 0) {
            this.NLog.error("NBitImagePrint error code:-93", i_prt);
            return -93;
        }
        if (i_height <= 0) {
            this.NLog.error("NBitImagePrint error code:-94", i_prt);
            return -94;
        }
        int numJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(numJobID);
        }
        byte[] rawPrtBuff = null;
        NInt objRet = new NInt();
        rawPrtBuff = this.objDevice.imagePrint(i_prt, i_bmp, i_width, i_height, (byte)16, objRet);
        if (rawPrtBuff == null) {
            this.NLog.error("NBitImagePrint error code:" + objRet.getValue() + " jobID:" + numJobID, i_prt);
            return objRet.getValue();
        }
        NInt objWroteSize = new NInt(0);
        int nmsRet = this.NWritePrinter(i_prt, rawPrtBuff, rawPrtBuff.length, objWroteSize);
        if (nmsRet != 0) {
            this.NLog.error("NBitImagePrint write error:" + nmsRet + " jobID:" + numJobID, i_prt);
            return nmsRet;
        }
        this.NLog.func("NBitImagePrint success wrote size:" + objWroteSize.getValue() + " jobID:" + numJobID, i_prt);
        return 0;
    }

    public int NBitImagePrintF(String i_prt, String i_file, NInt io_jobid) {
        this.NLog.func("NBitImagePrintF start i_file:" + i_file, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NBitImagePrintF error code:-91", i_prt);
            return -91;
        }
        if (i_file == null || i_file.equals("")) {
            this.NLog.error("NBitImagePrintF error code:-92", i_prt);
            return -92;
        }
        int nmsJobID = this.objDevice.getJobID(i_prt);
        if (io_jobid != null) {
            io_jobid.setValue(nmsJobID);
        }
        byte[] rawPrtBuff = null;
        NInt objRet = new NInt();
        rawPrtBuff = this.objDevice.imagePrintFile(i_prt, i_file, (byte)16, objRet);
        if (rawPrtBuff == null) {
            this.NLog.error("NBitImagePrintF error code:" + objRet.getValue() + " jobID:" + nmsJobID, i_prt);
            return objRet.getValue();
        }
        NInt objWroteSize = new NInt(0);
        int nmsRet = this.NWritePrinter(i_prt, rawPrtBuff, rawPrtBuff.length, objWroteSize);
        if (nmsRet != 0) {
            this.NLog.error("NBitImagePrintF write error:" + nmsRet + " jobID:" + nmsJobID, i_prt);
            return nmsRet;
        }
        this.NLog.func("NBitImagePrintF success wrote size:" + objWroteSize.getValue() + " jobID:" + nmsJobID, i_prt);
        return 0;
    }

    public int NGetStatus(String i_prt, NInt o_status) {
        this.NLog.func("NGetStatus start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NGetStatus error code:-91", i_prt);
            return -91;
        }
        if (o_status == null) {
            this.NLog.error("NGetStatus error code:-92", i_prt);
            return -92;
        }
        int nmsRet = this.objDevice.getStatus(i_prt, o_status, true);
        if (nmsRet != 0) {
            this.NLog.error("NGetStatus error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NGetStatus success o_status:" + o_status.getValue(), i_prt);
        return 0;
    }

    public int NGetInformation(String i_prt, byte i_id, byte[] o_dat, NLong o_time) {
        this.NLog.func("NGetInformation start i_id:" + i_id, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NGetInformation error code:-91", i_prt);
            return -91;
        }
        if (i_id < 1 || i_id > 31) {
            this.NLog.error("NGetInformation error code:-92", i_prt);
            return -92;
        }
        if (o_dat == null || o_dat.length < NCommon.EXTEND_DATA_SIZE[i_id]) {
            this.NLog.error("NGetInformation error code:-93", i_prt);
            return -93;
        }
        int nmsRet = this.objDevice.getInformation(i_prt, i_id, o_dat, o_time, true);
        if (nmsRet != 0) {
            this.NLog.func("NGetInformation error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NGetInformation success", i_prt);
        return 0;
    }

    public int NResetPrinter(String i_prt) {
        this.NLog.func("NResetPrinter start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NResetPrinter error code:-91", i_prt);
            return -91;
        }
        if (!this.objDevice.checkBluetooth(i_prt)) {
            this.NLog.error("NResetPrinter error code:-40", i_prt);
            return -40;
        }
        if (!this.objDevice.resetPrinter(i_prt, true)) {
            this.NLog.func("NResetPrinter error", i_prt);
            return -60;
        }
        this.NLog.func("NResetPrinter success", i_prt);
        return 0;
    }

    public int NStartDoc(String i_prt, NInt o_jobid) {
        this.NLog.func("NStartDoc start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NStartDoc error code:-91", i_prt);
            return -91;
        }
        if (o_jobid == null) {
            this.NLog.error("NStartDoc error code:-92", i_prt);
            return -92;
        }
        int nmsRet = this.objDevice.startDocument(i_prt, o_jobid);
        if (nmsRet != 0) {
            this.NLog.func("NStartDoc error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NStartDoc success jobID:" + o_jobid.getValue(), i_prt);
        return 0;
    }

    public int NEndDoc(String i_prt) {
        this.NLog.func("NEndDoc start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NEndDoc error code:-91", i_prt);
            return -91;
        }
        int nmsRet = this.objDevice.endDocument(i_prt);
        if (nmsRet != 0) {
            this.NLog.func("NEndDoc error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NEndDoc success", i_prt);
        return 0;
    }

    public int NCancelDoc(String i_prt) {
        this.NLog.func("NCancelDoc start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NCancelDoc error code:-91", i_prt);
            return -91;
        }
        int nmsRet = this.objDevice.cancelDocument(i_prt);
        if (nmsRet != 0) {
            this.NLog.func("NCancelDoc error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NCancelDoc success", i_prt);
        return 0;
    }

    public int NBarcode(String i_prt, String i_fontName, Bitmap i_bmp, int i_x, int i_y, int i_width, int i_height, byte[] i_dat, int i_size) {
        this.NLog.func("NBarcode start i_fontName:" + i_fontName + " i_x:" + i_x + " i_y:" + i_y + " i_width:" + i_width + " i_height:" + i_height + " i_size:" + i_size, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NBarcode error code:-91", i_prt);
            return -91;
        }
        NBarcodeData objBData = this.mapBcdFontName.get(i_fontName);
        if (objBData == null) {
            this.NLog.error("NBarcode error code:-92", i_prt);
            return -92;
        }
        if (i_bmp == null) {
            this.NLog.error("NBarcode error code:-93", i_prt);
            return -93;
        }
        if (i_x < 0) {
            this.NLog.error("NBarcode error code:-94", i_prt);
            return -94;
        }
        if (i_y < 0) {
            this.NLog.error("NBarcode error code:-95", i_prt);
            return -95;
        }
        if (i_width < 0) {
            this.NLog.error("NBarcode error code:-96", i_prt);
            return -96;
        }
        if (i_height < 0) {
            this.NLog.error("NBarcode error code:-97", i_prt);
            return -97;
        }
        if (i_dat == null) {
            this.NLog.error("NBarcode error code:-98", i_prt);
            return -98;
        }
        if (i_size < 0) {
            this.NLog.error("NBarcode error code:-99", i_prt);
            return -99;
        }
        int nmsRet = objBData.getFlg1DBarcode() ? this.bcdConvert.convert1DBarcode(i_fontName, objBData, i_bmp, i_x, i_y, i_width, i_height, i_dat, i_size) : this.bcdConvert.convert2DBarcode(i_fontName, objBData, i_bmp, i_x, i_y, i_width, i_height, i_dat, i_size);
        if (nmsRet != 0) {
            this.NLog.func("NBarcode error:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NBarcode success", i_prt);
        return 0;
    }

    public int NFirmwareDL(String i_prt, String i_file, byte i_errflg, NShort io_chksum, NInt io_jobid) {
        boolean flgErrCheck;
        this.NLog.func("NFirmwareDL start i_file:" + i_file + " i_errflg:" + i_errflg, i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NFirmwareDL error code:-91", i_prt);
            return -91;
        }
        if (!this.objDevice.checkBluetooth(i_prt)) {
            this.NLog.error("NFirmwareDL error code:-40", i_prt);
            return -40;
        }
        if (i_file == null) {
            if (io_chksum == null) {
                this.NLog.error("NFirmwareDL error code:-94", i_prt);
                return -94;
            }
            int nmsRet = this.objDevice.firmwareCheck(i_prt, io_chksum);
            if (nmsRet != 0) {
                this.NLog.error("NFirmwareDL error code:" + nmsRet, i_prt);
            } else {
                this.NLog.func("NFirmwareDL success", i_prt);
            }
            return nmsRet;
        }
        if (i_file.equals("")) {
            this.NLog.error("NFirmwareDL error code:-92", i_prt);
            return -92;
        }
        if (i_errflg == 0) {
            flgErrCheck = false;
        } else if (i_errflg == 1) {
            flgErrCheck = true;
        } else {
            this.NLog.error("NFirmwareDL error code:-93", i_prt);
            return -93;
        }
        int nmsRet = this.objDevice.firmwareDL(i_prt, i_file, flgErrCheck, io_chksum, io_jobid);
        if (nmsRet != 0) {
            this.NLog.error("NFirmwareDL error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        this.NLog.func("NFirmwareDL success", i_prt);
        return 0;
    }

    public int NFirmwareResult(String i_prt) {
        int nmsRet = 0;
        this.NLog.func("NFirmwareResult start", i_prt);
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NFirmwareResult error code:-91", i_prt);
            return -91;
        }
        nmsRet = this.objDevice.firmwareDLEndCheck(i_prt);
        if (nmsRet == 0) {
            this.NLog.func("NFirmwareResult success", i_prt);
        } else {
            this.NLog.error("NFirmwareResult error code:-93", i_prt);
        }
        return nmsRet;
    }

    public int NWritePrinter(String i_prt, byte[] i_rowBuffer, int i_nmuSize, NInt o_nmuSize) {
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NWritePrinter error code:-91", i_prt);
            return -13;
        }
        if (i_rowBuffer == null || i_rowBuffer.length <= 0) {
            this.NLog.error("NWritePrinter error code:-92", i_prt);
            return -13;
        }
        if (i_nmuSize <= 0) {
            this.NLog.error("NWritePrinter error code:-93", i_prt);
            return -13;
        }
        if (o_nmuSize == null) {
            this.NLog.error("NWritePrinter error code:-94", i_prt);
            return -13;
        }
        NBoolean objDocFlg = new NBoolean();
        int nmsRet = this.objDevice.documentWrite(i_prt, i_rowBuffer, i_nmuSize, objDocFlg);
        if (nmsRet != 0) {
            this.NLog.error("NWritePrinter check document error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        if (objDocFlg.getValue()) {
            this.NLog.func("Document writing (But we have not yet printed)", i_prt);
            return 0;
        }
        nmsRet = this.objDevice.write(i_prt, i_rowBuffer, i_nmuSize, o_nmuSize, true);
        if (nmsRet != 0) {
            this.NLog.error("NWritePrinter error code:" + nmsRet, i_prt);
            return nmsRet;
        }
        return 0;
    }

    public int NSetUSBProtocol(String i_prt, int i_type) {
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NSetUSBProtocol error code:-91", i_prt);
            return -91;
        }
        switch (i_type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.NLog.error("NSetUSBProtocol error code:-92", i_prt);
                return -92;
            }
        }
        return this.objDevice.setProtocol(i_prt, i_type);
    }

    public boolean NCheckOnline(String i_prt) {
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NCheckOnline error code:-91", i_prt);
            return false;
        }
        return this.objDevice.checkOnline(i_prt, true);
    }

    public int NDataConvert(byte[] i_rawData, int i_size, byte[] o_rawData, NInt o_size) {
        NInt nmuReadCnt = new NInt(0);
        int nmsRet = 0;
        int b_cntf = 0;
        boolean wk_cntf = false;
        boolean d_flg = false;
        byte whigh = 0;
        if (i_rawData == null) {
            this.NLog.error("NDataConvert i_rawData is null.");
            return -91;
        }
        if (o_size == null) {
            this.NLog.error("NDataConvert o_size is null.");
            return -94;
        }
        o_size.setValue(0);
        while (nmuReadCnt.getValue() < i_size) {
            byte cw;
            byte cr = i_rawData[nmuReadCnt.getValue()];
            nmuReadCnt.plusCount(1);
            if (!(cr >= 97 && cr <= 102 || cr >= 65 && cr <= 70 || cr >= 48 && cr <= 57)) {
                if (cr == 34) {
                    if (!wk_cntf) {
                        b_cntf = NCommon.HexEChk(b_cntf, whigh, o_rawData, o_size);
                        wk_cntf = true;
                    } else {
                        wk_cntf = false;
                    }
                    if (!d_flg || !wk_cntf) {
                        d_flg = true;
                        continue;
                    }
                    d_flg = true;
                } else {
                    d_flg = false;
                    if (!wk_cntf) {
                        if (cr == 60) {
                            b_cntf = NCommon.HexEChk(b_cntf, whigh, o_rawData, o_size);
                            nmsRet = NCommon.PasData(i_rawData, i_size, nmuReadCnt, o_rawData, o_size, this.NLog);
                            if (nmsRet != 0) break;
                        }
                        if (cr != 39) continue;
                        b_cntf = NCommon.HexEChk(b_cntf, whigh, o_rawData, o_size);
                        NCommon.CommentData(i_rawData, i_size, nmuReadCnt, o_rawData, o_size);
                        continue;
                    }
                }
            } else {
                d_flg = false;
            }
            if (wk_cntf) {
                cw = cr;
                if (o_rawData != null) {
                    o_rawData[o_size.getValue()] = cw;
                }
                o_size.plusCount(1);
            } else if (b_cntf == 1) {
                byte wlow = cr;
                cw = NCommon.StrToHex(whigh, wlow);
                if (o_rawData != null) {
                    o_rawData[o_size.getValue()] = cw;
                }
                o_size.plusCount(1);
                b_cntf = 0;
            } else {
                whigh = cr;
                b_cntf = 1;
            }
            if (nmuReadCnt.getValue() < i_size) continue;
            NCommon.HexEChk(b_cntf, whigh, o_rawData, o_size);
            break;
        }
        return 0;
    }

    public int NReadPrinter(String i_prt, byte[] o_buffer, int i_buffersize, NInt o_readsize) {
        if (i_prt == null || i_prt.equals("")) {
            this.NLog.error("NReadPrinter error code:-91", i_prt);
            return -91;
        }
        if (o_buffer == null) {
            this.NLog.error("NReadPrinter error code:-92", i_prt);
            return -92;
        }
        if (i_buffersize <= 0) {
            this.NLog.error("NReadPrinter error code:-93", i_prt);
            return -93;
        }
        if (o_readsize == null) {
            this.NLog.error("NReadPrinter error code:-94", i_prt);
            return -94;
        }
        return this.objDevice.readData(i_prt, o_buffer, i_buffersize, o_readsize);
    }

    private void setLogFileSetting() {
        String staLogType = "";
        int nmsLogMaxSize = 1000000;
        String logFileName = String.valueOf(NCommon.getStoragePath()) + "/npi/log/SDKLog";
        String settingFile = String.valueOf(NCommon.getStoragePath()) + "/npi/NLogInf";
        File file = new File(settingFile);
        if (file.exists()) {
            NIniFileOperation objIni = new NIniFileOperation(settingFile);
            staLogType = objIni.get("LOGSETTING", "OUTPUT");
            String logSizeStr = objIni.get("LOGSETTING", "SIZE");
            try {
                nmsLogMaxSize = Integer.parseInt(logSizeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nmsLogMaxSize <= 0) {
                nmsLogMaxSize = 1000000;
            }
        }
        ArrayList<Integer> logTypeArray = new ArrayList<Integer>();
        if (staLogType != null && !staLogType.equals("")) {
            String[] logTypeBuf = staLogType.split(",");
            int index = 0;
            while (index < logTypeBuf.length) {
                try {
                    int tmpType = Integer.parseInt(logTypeBuf[index]);
                    if (tmpType >= 1 && tmpType <= 5) {
                        logTypeArray.add(new Integer(tmpType));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        this.NLog = new NLogWriter(logFileName, nmsLogMaxSize, logTypeArray);
    }

    private void setBarcodeSetting() {
        this.mapBcdFontName = new HashMap();
        String settingFile = String.valueOf(NCommon.getStoragePath()) + "/npi/NBarcodeInf";
        NIniFileOperation objIni = new NIniFileOperation(settingFile);
        this.setting1DBcdData(objIni);
        this.setting2DBcdData(objIni);
        File folder = new File(Environment.getExternalStorageDirectory() + "/npi/image/");
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    private void setting1DBcdData(NIniFileOperation iniObj) {
        int nmsCount = 1;
        String[] stringArray = NCommon.BCDFONTARRAY_1D;
        int n = NCommon.BCDFONTARRAY_1D.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            NBarcodeData objBcdData = new NBarcodeData(true, nmsCount);
            if (iniObj.getReadResult() == -10) {
                this.mapBcdFontName.put(fontName, objBcdData);
            } else {
                int nmsGetNum = this.getNumberIni(iniObj, fontName, "TYPE");
                if (nmsGetNum != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            objBcdData.setType(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] TYPE illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "WIDTH")) != -1) {
                    switch (nmsGetNum) {
                        case 2: 
                        case 3: 
                        case 4: {
                            objBcdData.setWidth(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] WIDTH illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "HEIGHT")) != -1) {
                    objBcdData.setHeight(nmsGetNum);
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "HRI")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            objBcdData.setHRI(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] HRI illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "HEXMODE")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: {
                            objBcdData.setHexMode(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] HEXMODE illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "ROTATE")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            objBcdData.setRotate(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] ROTATE illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "STARTBIT")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            objBcdData.setStartbit(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] STARTBIT illegal number = " + nmsGetNum);
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "STOPBIT")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            objBcdData.setStopbit(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] STOPBIT illegal number = " + nmsGetNum);
                        }
                    }
                }
                String fileName = iniObj.get(fontName, "FILENAME");
                objBcdData.setFileName(fileName);
                this.mapBcdFontName.put(fontName, objBcdData);
                ++nmsCount;
            }
            ++n2;
        }
    }

    private void setting2DBcdData(NIniFileOperation iniObj) {
        int nmsCount = 1;
        String[] stringArray = NCommon.BCDFONTARRAY_2D;
        int n = NCommon.BCDFONTARRAY_2D.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            NBarcodeData objBcdData = new NBarcodeData(false, nmsCount);
            if (iniObj.getReadResult() != -10) {
                int nmsGetNum = this.getNumberIni(iniObj, fontName, "TYPE");
                if (nmsGetNum != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: {
                            objBcdData.setType(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] TYPE illegal number = " + nmsGetNum);
                            this.NLog.warn("Is used by default QRModel2");
                        }
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "SIZE")) != -1) {
                    if (objBcdData.getType() == 0) {
                        if (nmsGetNum >= 2 && nmsGetNum <= 8) {
                            objBcdData.setSize(nmsGetNum);
                        } else {
                            this.NLog.warn("Fontname[" + fontName + "] SIZE illegal number = " + nmsGetNum);
                            this.NLog.warn("Input must be empty or 2-8, in QRModel2");
                        }
                    } else if (nmsGetNum >= 2 && nmsGetNum <= 4) {
                        objBcdData.setSize(nmsGetNum);
                    } else {
                        this.NLog.warn("Fontname[" + fontName + "] SIZE illegal number = " + nmsGetNum);
                        this.NLog.warn("Input must be empty or 2-4, in PDF417");
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "HEIGHT")) != -1 && objBcdData.getType() == 1) {
                    if (nmsGetNum >= 1 && nmsGetNum <= 6) {
                        objBcdData.setHeight(nmsGetNum);
                    } else {
                        this.NLog.warn("Fontname[" + fontName + "] HEIGHT illegal number = " + nmsGetNum);
                        this.NLog.warn("Input must 1-6, in PDF417");
                    }
                }
                if ((nmsGetNum = this.getNumberIni(iniObj, fontName, "HEXMODE")) != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: {
                            objBcdData.setHexMode(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] HEXMODE illegal number = " + nmsGetNum);
                            this.NLog.warn("Input must 0 or 1.");
                        }
                    }
                }
                String error = iniObj.get(fontName, "ERROR");
                if (objBcdData.getType() == 0) {
                    if (error != null) {
                        if ((error = error.toUpperCase()).equals("L")) {
                            objBcdData.setError(0);
                        } else if (error.equals("M")) {
                            objBcdData.setError(1);
                        } else if (error.equals("Q")) {
                            objBcdData.setError(2);
                        } else if (error.equals("H")) {
                            objBcdData.setError(3);
                        } else {
                            this.NLog.warn("Fontname[" + fontName + "] ERROR illegal value = " + error);
                            this.NLog.warn("Input must be empty or 'L' or 'M' or 'Q' or 'H', in QRModel2");
                        }
                    } else {
                        this.NLog.warn("Fontname[" + fontName + "] ERROR is null.");
                    }
                } else if (error == null) {
                    objBcdData.setError(-1);
                } else {
                    nmsGetNum = this.getNumberIni(iniObj, fontName, "ERROR");
                    if (nmsGetNum != -1) {
                        if (nmsGetNum >= 0 && nmsGetNum <= 8) {
                            objBcdData.setError(nmsGetNum);
                        } else {
                            this.NLog.warn("Fontname[" + fontName + "] ERROR illegal value = " + error);
                            this.NLog.warn("Input must be empty or 1-8, in PDF417");
                        }
                    }
                }
                nmsGetNum = this.getNumberIni(iniObj, fontName, "ROTATE");
                if (nmsGetNum != -1) {
                    switch (nmsGetNum) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            objBcdData.setRotate(nmsGetNum);
                            break;
                        }
                        default: {
                            this.NLog.warn("Fontname[" + fontName + "] ROTATE illegal number = " + nmsGetNum);
                        }
                    }
                }
                String fileName = iniObj.get(fontName, "FILENAME");
                objBcdData.setFileName(fileName);
                this.mapBcdFontName.put(fontName, objBcdData);
                ++nmsCount;
            }
            ++n2;
        }
    }

    private int getNumberIni(NIniFileOperation iniObj, String section, String key) {
        String staGetData;
        block5: {
            block4: {
                staGetData = null;
                try {
                    staGetData = iniObj.get(section, key);
                    if (staGetData != null) break block4;
                    this.NLog.warn("Fontname:" + section + " Key:" + key + " null");
                    return -1;
                }
                catch (Exception e) {
                    this.NLog.error(e);
                    this.NLog.warn("Fontname:" + section + " Key:" + key + " Error number = " + staGetData);
                    return -1;
                }
            }
            if (!staGetData.equals("")) break block5;
            return -1;
        }
        return Integer.parseInt(staGetData);
    }
}

