/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.usb;

import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import java.util.ArrayList;
import java.util.HashMap;
import npi.sdk.common.NLogWriter;

public class NUsbBase {
    private NLogWriter NLog;
    private UsbManager mManager;
    private HashMap<String, UsbDevice> mDeviceMap;
    private Context mContext;

    public NUsbBase(Context context, NLogWriter NLog) {
        this.mContext = context;
        this.NLog = NLog;
        this.mManager = (UsbManager)context.getSystemService("usb");
    }

    public ArrayList<String> getDeviceKeyArray() {
        ArrayList<String> keyArray = new ArrayList<String>();
        this.mDeviceMap = this.mManager.getDeviceList();
        if (this.mDeviceMap == null || this.mDeviceMap.size() == 0) {
            return null;
        }
        for (String key : this.mDeviceMap.keySet()) {
            UsbDevice tmpDevice = this.mDeviceMap.get(key);
            StringBuilder tmpStr = new StringBuilder(Integer.toHexString(tmpDevice.getVendorId()));
            tmpStr.append(Integer.toHexString(tmpDevice.getProductId()));
            keyArray.add(tmpStr.toString());
        }
        return keyArray;
    }

    public UsbManager getManager() {
        return this.mManager;
    }
}

