/*
 * Decompiled with CFR 0.152.
 */
package npi.sdk.device.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.os.ParcelUuid;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import npi.sdk.common.NCommon;
import npi.sdk.common.NExDataArray;
import npi.sdk.common.NLogWriter;
import npi.sdk.data.NInt;
import npi.sdk.device.bluetooth.NBlthRecvThread;
import npi.sdk.device.bluetooth.NBlthSendThread;
import npi.sdk.device.usb.NSendData;

public class NBluetooth {
    private NLogWriter NLog;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothSocket mSocket;
    private BluetoothDevice mDevice;
    private NBlthSendThread mBlthSendThread;
    private OutputStream mOutStream;
    private NBlthRecvThread mBlthRecvThread;
    private InputStream mInStream;
    private int prtStatus;
    private NExDataArray extendInfo;
    private boolean bOnline;
    private String mPairDeviceName;
    private String mSerialAddr;
    private String mStrPrtname;
    private boolean mFlgOpen;
    private boolean mFlgRetry;
    private int numOpenFlg;
    private HashMap<String, LinkedList<NSendData>> sendQueueMap;
    private HashSet<String> sendThreadStopSet;

    public NBluetooth(NLogWriter NLog, String strPrtname, HashMap<String, LinkedList<NSendData>> sendQueueMap, HashSet<String> sendThreadStopSet) {
        this.NLog = NLog;
        this.mSocket = null;
        this.prtStatus = 255;
        this.mStrPrtname = strPrtname;
        this.mBlthSendThread = null;
        this.mBlthRecvThread = null;
        this.sendQueueMap = sendQueueMap;
        this.sendThreadStopSet = sendThreadStopSet;
        this.extendInfo = new NExDataArray();
        this.setFlgOpen(false);
        this.setFlgRetry(false);
    }

    protected void finalize() {
    }

    public String getPrintername() {
        return this.mStrPrtname;
    }

    public LinkedList<NSendData> getSendQueue(String prtName) {
        return this.sendQueueMap.get(prtName);
    }

    public boolean getFlgSendStop() {
        boolean flgSendStop = false;
        if (this.sendThreadStopSet.contains(this.mStrPrtname)) {
            this.sendThreadStopSet.remove(this.mStrPrtname);
            flgSendStop = true;
        }
        return flgSendStop;
    }

    public void setFlgSendStop(boolean flgSendStop) {
        if (flgSendStop && !this.sendThreadStopSet.contains(this.mStrPrtname)) {
            this.sendThreadStopSet.add(this.mStrPrtname);
        }
    }

    public boolean getFlgOpen() {
        return this.mFlgOpen;
    }

    public void setFlgOpen(boolean flgOpen) {
        this.mFlgOpen = flgOpen;
    }

    public boolean getFlgRetry() {
        return this.mFlgRetry;
    }

    public void setFlgRetry(boolean mFlgRetry) {
        this.mFlgRetry = mFlgRetry;
    }

    public void setOnline(boolean flg) {
        this.bOnline = flg;
    }

    public boolean getOnline() {
        return this.bOnline;
    }

    public void setPrinterStatus(int prtStatus) {
        this.prtStatus = prtStatus;
    }

    public NLogWriter getLogObj() {
        return this.NLog;
    }

    public InputStream getStreamIn() {
        return this.mInStream;
    }

    public String getDeviceName() {
        return this.mPairDeviceName;
    }

    public int getBlthStatus() {
        if (this.mSocket != null && this.mInStream != null) {
            if (this.mBlthRecvThread != null) {
                return this.prtStatus;
            }
            return this.blthManualRecv();
        }
        return 255;
    }

    public NExDataArray getExtendInfo() {
        if (this.mSocket != null && this.mInStream != null) {
            if (this.mBlthRecvThread != null) {
                return this.extendInfo;
            }
            if (this.blthManualRecv() != 255) {
                return this.extendInfo;
            }
        }
        return null;
    }

    private int blthManualRecv() {
        byte[] buffer = new byte[1024];
        byte[] byArray = new byte[3];
        byArray[0] = 29;
        byArray[1] = 20;
        byte[] rawGSDC4 = byArray;
        NInt o_nmuSize = new NInt();
        if (!this.sendData(rawGSDC4, rawGSDC4.length, o_nmuSize)) {
            this.NLog.write("Bluetooth manual recv error. (GS DC4 00 send error)", 1);
        }
        try {
            int nSize = this.mInStream.read(buffer);
            if (nSize > 0) {
                this.prtStatus = NCommon.AnalysisRecvData(Arrays.copyOfRange(buffer, 0, nSize), this.extendInfo, this.NLog, this.mPairDeviceName);
                this.NLog.write("Bluetooth manual recv data size=" + nSize, Arrays.copyOfRange(buffer, 0, nSize), 4);
            } else {
                this.prtStatus = 255;
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            this.prtStatus = 255;
        }
        return this.prtStatus;
    }

    public int blthRecvForReadPrinter(byte[] o_buffer, int i_buffersize, NInt o_readsize) {
        int numRet;
        try {
            int nSize = this.mInStream.read(o_buffer, 0, i_buffersize);
            if (nSize > 0) {
                this.NLog.write("Bluetooth NReadPrinter recv data size=" + nSize, Arrays.copyOfRange(o_buffer, 0, nSize), 4);
                o_readsize.setValue(nSize);
                numRet = 0;
            } else {
                numRet = -14;
            }
        }
        catch (Exception e) {
            this.NLog.error(e);
            numRet = -14;
        }
        return numRet;
    }

    public static ArrayList<String> getDeviceKeyArray() {
        ArrayList<String> keyArray = new ArrayList<String>();
        BluetoothAdapter adpt = BluetoothAdapter.getDefaultAdapter();
        if (adpt != null && adpt.isEnabled()) {
            Set pairedDevices = adpt.getBondedDevices();
            for (BluetoothDevice tmpDevice : pairedDevices) {
                String address = tmpDevice.getAddress().replace(":", "");
                keyArray.add(String.valueOf(tmpDevice.getName()) + "/" + address);
            }
        }
        return keyArray;
    }

    public int reconnect() {
        this.NLog.warn("Bluetooth reconnect start");
        int numRet = this.connect(String.valueOf(this.mPairDeviceName) + "/" + this.mSerialAddr, false);
        this.NLog.warn("reconnect ret:" + numRet);
        return numRet;
    }

    public int connect(String deviceName, boolean flgRecv) {
        int index = deviceName.lastIndexOf("/");
        this.mPairDeviceName = deviceName.substring(0, index);
        this.mSerialAddr = deviceName.substring(index + 1);
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            this.NLog.error("mBluetoothAdapter is null.", deviceName);
            return 2;
        }
        if (!this.mBluetoothAdapter.isEnabled()) {
            this.NLog.error("mBluetoothAdapter is not enabled.", deviceName);
            return 2;
        }
        Set pairedDevices = this.mBluetoothAdapter.getBondedDevices();
        for (BluetoothDevice tmpDevice : pairedDevices) {
            String tmpAddr = tmpDevice.getAddress().replace(":", "");
            if (!tmpDevice.getName().equals(this.mPairDeviceName) || !tmpAddr.equals(this.mSerialAddr)) continue;
            this.mDevice = tmpDevice;
            break;
        }
        if (this.mDevice == null) {
            return 1;
        }
        boolean flgUUID = false;
        ParcelUuid[] uuidArray = this.mDevice.getUuids();
        if (uuidArray == null || uuidArray.length == 0) {
            this.NLog.error("UUID was not found even one.", deviceName);
            return 2;
        }
        int n = 0;
        while (n < uuidArray.length) {
            ParcelUuid parcelObj = uuidArray[n];
            if (parcelObj.getUuid().equals(NCommon.SPP_UUID)) {
                this.NLog.func("UUID of the SPP found. UUID Obj[" + n + "]:" + parcelObj.getUuid());
                flgUUID = true;
                break;
            }
            this.NLog.func("It is not the UUID of the SPP. UUID Obj[" + n + "]:" + parcelObj.getUuid());
            ++n;
        }
        if (!flgUUID) {
            this.NLog.error("UUID of the SPP was not found.", deviceName);
            return 2;
        }
        try {
            this.mSocket = this.mDevice.createRfcommSocketToServiceRecord(NCommon.SPP_UUID);
        }
        catch (Exception e) {
            this.NLog.error(e);
            return 2;
        }
        this.mBluetoothAdapter.cancelDiscovery();
        try {
            this.mSocket.connect();
        }
        catch (Exception e) {
            this.NLog.error(e);
            try {
                this.mSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 2;
        }
        try {
            this.mInStream = this.mSocket.getInputStream();
            this.mOutStream = this.mSocket.getOutputStream();
            if (!this.getFlgRetry()) {
                this.mBlthSendThread = new NBlthSendThread(this.NLog, this);
                this.mBlthSendThread.start();
                if (flgRecv) {
                    this.mBlthRecvThread = new NBlthRecvThread(this);
                    this.mBlthRecvThread.start();
                }
            }
            this.setFlgOpen(true);
        }
        catch (Exception e) {
            this.NLog.error(e);
            return 2;
        }
        return 0;
    }

    public boolean close() {
        return this.close(true);
    }

    public boolean close(boolean bThreadStop) {
        int nErr;
        block24: {
            block22: {
                block20: {
                    nErr = 0;
                    if (bThreadStop && this.mBlthRecvThread != null) {
                        this.mBlthRecvThread.close();
                        long nStartTime = System.currentTimeMillis();
                        while (!this.mBlthRecvThread.checkThreadEnd()) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (nStartTime + 5000L >= System.currentTimeMillis()) continue;
                            this.NLog.error("Bluetooth recv thread stop error!", this.mPairDeviceName);
                            ++nErr;
                            break;
                        }
                        this.mBlthRecvThread = null;
                    }
                    if (this.mOutStream != null) {
                        try {
                            try {
                                this.mOutStream.flush();
                                this.mOutStream.close();
                            }
                            catch (Exception e) {
                                this.NLog.error(e);
                                nErr += 2;
                                this.mOutStream = null;
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            this.mOutStream = null;
                            throw throwable;
                        }
                        this.mOutStream = null;
                    }
                }
                if (this.mInStream != null) {
                    try {
                        try {
                            this.mInStream.close();
                        }
                        catch (Exception e) {
                            this.NLog.error(e);
                            nErr += 4;
                            this.mInStream = null;
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        this.mInStream = null;
                        throw throwable;
                    }
                    this.mInStream = null;
                }
            }
            if (this.mSocket != null) {
                try {
                    try {
                        this.mSocket.close();
                    }
                    catch (Exception e) {
                        this.NLog.error(e);
                        nErr += 8;
                        this.mSocket = null;
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    this.mSocket = null;
                    throw throwable;
                }
                this.mSocket = null;
            }
        }
        this.setFlgOpen(false);
        this.setFlgRetry(false);
        return nErr <= 0;
    }

    public boolean sendData(byte[] i_rowBuffer, int i_nmuSize, NInt o_nmuSize) {
        try {
            this.mOutStream.write(i_rowBuffer, 0, i_nmuSize);
            this.mOutStream.flush();
            this.NLog.write("Bluetooth send data size=" + i_nmuSize, Arrays.copyOfRange(i_rowBuffer, 0, i_nmuSize), 5);
        }
        catch (Exception e) {
            this.NLog.error(e);
            if (o_nmuSize != null) {
                o_nmuSize.setValue(0);
            }
            return false;
        }
        if (o_nmuSize != null) {
            o_nmuSize.setValue(i_nmuSize);
        }
        return true;
    }

    public boolean resetPrinter() {
        return false;
    }

    public int getOpenFlg() {
        return this.numOpenFlg;
    }

    public void setOpenFlg(int numOpenFlg) {
        this.numOpenFlg = numOpenFlg;
    }
}

