﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using NPrinterCLib;

namespace WindowsFormsApplication1
{
	public partial class Form1 : Form
	{
    NClassLib nei;
	
        public Form1()
        {
            InitializeComponent();
            nei = new NClassLib();
        }

        //NStartDoc
        private void Command4_Click(object sender, EventArgs e)
        {
            int ret;
            long jid = 0;

            ret = nei.NStartDoc(Text8.Text, out jid);
            if (ret < 0)
                MessageBox.Show("Error");
            Text5.Text = Convert.ToString(jid);
        }

        //NEndDoc
        private void Command5_Click(object sender, EventArgs e)
        {
            int ret;

            ret = nei.NEndDoc(Text8.Text);
            if (ret < 0)
                MessageBox.Show("Error");
        }

        //NPrint
        private void Command1_Click(object sender, EventArgs e)
        {
            int ret;
            long jid = 0;


            ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(Text1.Text), (uint)Text1.Text.Length, out jid);
            if (ret < 0)
            {
                MessageBox.Show("Error");
            }
            Text5.Text = Convert.ToString(jid);
        }

        //NImagePrint
        private void Command2_Click(object sender, EventArgs e)
        {
            int ret;
            long jid = 0;
            IntPtr hdc;

            //Get Device context(HDC)
            Graphics g = Picture1.CreateGraphics();
            g.DrawImage(Picture1.Image, 0, 0, Picture1.Image.Width, Picture1.Image.Height);
            hdc = g.GetHdc();

            //Output Image(RASTER BLOCK)
            ret = nei.NImagePrint(Text8.Text, hdc, Picture1.Image.Width, Picture1.Image.Height, 0, out jid);
            if (ret < 0)
                MessageBox.Show("Error");
            Text5.Text = Convert.ToString(jid);

            //Output Image(RASTER LINE)
            ret = nei.NImagePrint(Text8.Text, hdc, Picture1.Image.Width, Picture1.Image.Height, 1, out jid);
            if (ret < 0)
                MessageBox.Show("Error");
            Text5.Text = Convert.ToString(jid);

            //Output Image(BIT IMAGE)
            ret = nei.NImagePrint(Text8.Text, hdc, Picture1.Image.Width, Picture1.Image.Height, 16, out jid);
            if (ret < 0)
                MessageBox.Show("Error");
            Text5.Text = Convert.ToString(jid);

            //Open Resource
            g.ReleaseHdc(hdc);
            g.Dispose();
        }

        //NGetStatus
        private void Command3_Click(object sender, EventArgs e)
        {
            long st = 0;
            int ret;

            ret = nei.NGetStatus(Text8.Text, out st);
			textBox10.Text = ret.ToString();
            Text2.Text = Convert.ToString(st);
        }

        //NGetInfomation<Model ID=2>
        private void Command6_Click(object sender, EventArgs e)
        {
            int ret;
            long tm = 0;
            byte[] dat = new byte[64];

            ret = nei.NGetInformation(Text8.Text, (byte)2, dat, out tm);
            if (ret < 0)
                MessageBox.Show("Error");

            //Model&Time
            Text4.Text = "";
            for (int i = 0; i < 64; i++)
                Text4.Text += (char)dat[i];
            Text3.Text = Convert.ToString(tm);
        }

        //NGetInfomation<EndDoc ID=19>
        private void Command9_Click(object sender, EventArgs e)
        {
            int ret;
            long tm = 0;
            byte[] dat = new byte[64];

            ret = nei.NGetInformation(Text8.Text, (byte)19, dat, out tm);
            if (ret < 0)
                MessageBox.Show("Error");

           
            Text9.Text = "";
            Text7.Text = "";
            Text9.Text = Convert.ToString(BitConverter.ToUInt32(dat, 0));
            for (int i = 4; i < 8; i++)
            {
                Text7.Text += dat[i].ToString("X2");
            }

            Text6.Text = Convert.ToString(tm);
        }

        //PrintSample
		private void Command7_Click(object sender, EventArgs e)
		{
			int ret;
			int cmd;
			long jid = 0;
			long sjid = 0;
			string wk;
			IntPtr hdc;

			byte[] dat = new byte[64];
			long tm = 0;
			long stm = 0;
			long etm = 0;
			long id;
			bool flg;
			long st = 0;

			//デバイスコンテキスト(HDC)取得
			Graphics g = Picture1.CreateGraphics();
			g.DrawImage(Picture1.Image, 0, 0, Picture1.Image.Width, Picture1.Image.Height);
			hdc = g.GetHdc();

			for (int i = 1; i <= int.Parse(textBox1.Text); i++)
			{
				Application.DoEvents();

				ret = nei.NStartDoc(Text8.Text, out jid);
				if (ret < 0)
				{
					MessageBox.Show("Error");
				}

				Text5.Text = Convert.ToString(jid);

				//印字開始宣言
				cmd = int.Parse(Text5.Text);
				wk = "1D\"G\"11" + cmd.ToString("X2") + "000000";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				//印字前処理
				wk = "1B\"@\"1B4AFF1D7E801B6101";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				//ドキュメントイメージ出力
				wk = "\"TEST Image START\"0a";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				ret = nei.NImagePrint(Text8.Text, hdc, Picture1.Image.Width, Picture1.Image.Height, 1, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				wk = "1B\"@TEST Image END\"0a";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				//印字後処理
				//                wk = "1B4A781b69";
				wk = "1B4A78";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				wk = "1D\"G\"10";
				ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
				if (ret < 0)
					MessageBox.Show("Error");
				ret = nei.NEndDoc(Text8.Text);
				if (ret < 0)
					MessageBox.Show("Error");

				//印字完了待ちLoop
				stm = (long)System.Environment.TickCount;
				flg = true;
				while (true)
				{
					Application.DoEvents();

					//Job ID取得
					ret = nei.NGetInformation(Text8.Text, (byte)19, dat, out tm);
					if (ret < 0)
					{
						MessageBox.Show("NGetInformation Error" + Convert.ToString(ret));
						flg = false;
						break;
					}
					id = (long)dat[0];
					if (jid == id)
						break;

					//3秒以上経過
					etm = (long)System.Environment.TickCount;
					if ((etm - stm) > 3000)
					{
						//Status
						ret = nei.NGetStatus(Text8.Text, out st);
						if (ret < 0)
						{
							MessageBox.Show("NGetStatus Error");
						}

						Text2.Text = Convert.ToString(st);

						if ((st & 0x7F) > 0)
						{
							wk = "1D\"G\"10";
							ret = nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes(wk), (uint)wk.Length, out sjid);
							if (ret < 0)
								MessageBox.Show("NPrint Error");
						}
						MessageBox.Show("3秒以上経過");
						flg = false;
						break;
					}
				}
				//Error
				if (flg == false)
				{
					break;
				}

				textBox2.Text = Convert.ToString(i);
			}
			//リソース開放
			g.ReleaseHdc(hdc);
			g.Dispose();
		}

		private void button1_Click(object sender, EventArgs e)
		{

			int size;
			long wk;
			StringBuilder printerNames;

			nei.NEnumPrinters(null, out wk);
			size = (int)wk;
			printerNames = new StringBuilder(size);
			nei.NEnumPrinters(printerNames, out wk);

			Text8.Text = printerNames.ToString();
		}

		private void button2_Click(object sender, EventArgs e)
		{
			timer1.Enabled = !timer1.Enabled;
		}

		private void timer1_Tick(object sender, EventArgs e)
		{
			Command3_Click(sender, e);
		}

		private void button3_Click(object sender, EventArgs e)
		{
			StringBuilder printerNames;
			printerNames = new StringBuilder(100);

			nei.NGetPrinterFromID(textBox3.Text, printerNames);
			Text8.Text = printerNames.ToString();
		}

		private void button4_Click(object sender, EventArgs e)
		{
			nei.NDeletePrinter(Text8.Text);
		}

		private void button5_Click(object sender, EventArgs e)
		{
			nei.NRenamePrinter(Text8.Text, textBox4.Text);
		}

		private void button6_Click(object sender, EventArgs e)
		{
			int size;
			long wk;
			StringBuilder PrinterInf;
			nei.NGetPrinterInf(Text8.Text, null, out wk);
			size = (int)wk;
			PrinterInf = new StringBuilder(size);
			nei.NGetPrinterInf(Text8.Text, PrinterInf, out wk);
			textBox5.Text = PrinterInf.ToString();
		}

		private void button7_Click(object sender, EventArgs e)
		{
			nei.NOpenPrinter(Text8.Text, byte.Parse(textBox6.Text));
		}

		private void button8_Click(object sender, EventArgs e)
		{
			nei.NClosePrinter(Text8.Text);
		}

		private void button9_Click(object sender, EventArgs e)
		{
			long jid = 0;
			nei.NImagePrintF(Text8.Text, textBox7.Text, 0x01, out jid);
			nei.NPrint(Text8.Text, System.Text.Encoding.ASCII.GetBytes("0a0a0a1b69"), 10, out jid);
		}

		private void button10_Click(object sender, EventArgs e)
		{
			nei.NResetPrinter(Text8.Text);
		}

		private void button11_Click(object sender, EventArgs e)
		{

			int size;
			StringBuilder DocList;

			size = nei.NEnumDoc(Text8.Text,null);
			DocList = new StringBuilder(size);
			nei.NEnumDoc(Text8.Text, DocList);

			textBox8.Text = DocList.ToString();

		}

		private void button12_Click(object sender, EventArgs e)
		{
			nei.NDeleteDoc(Text8.Text, textBox9.Text);
		}

		private void button13_Click(object sender, EventArgs e)
		{
			long o_count;

			NClassLib.SCANRESULT callback = new NClassLib.SCANRESULT(showResult2);

			nei.NScanPrinters(out o_count, 3000, callback);

			textBox11.Text = o_count.ToString();
		}

		
		private void button14_Click(object sender, EventArgs e)
		{
			NClassLib.RESULTCALL callback = new NClassLib.RESULTCALL(showResult);

			Byte value = Byte.Parse(comboBox1.Text);

			nei.NBlockSendSetting(Text8.Text, value, callback);
		}

		private void showResult(int result)
		{
			MessageBox.Show("result code:"+ result);
		}

		private void showResult2(int result, int count)
		{
			MessageBox.Show("result code:" + result+" count:" + count);
		}

		private void button15_Click(object sender, EventArgs e)
		{
			NClassLib.RESULTCALL callback = new NClassLib.RESULTCALL(showResult);



			nei.NBufferClear(Text8.Text, callback);
		}

		private void button16_Click(object sender, EventArgs e)
		{
			NClassLib.RESULTCALL callback = new NClassLib.RESULTCALL(showResult);

			Byte value = Byte.Parse(comboBox3.Text);

			nei.NTCPPortLock(Text8.Text, value, callback);
		}
	}
}
