/*
 ============================================================================
 Name        :libNPrint_sample.c
 Author      : Nippon Printer Engnieering Inc.
 Version     :
 Copyright   :
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <time.h>		// localtime
#include "cv.h"			// OpenCV
#include "highgui.h"	// OpenCV

//#include <sys/types.h>	// open
//#include <sys/stat.h>	//
//#include <fcntl.h>		//
//#include <termios.h>	// termios


#define	SUCCESS					0
#define	ERR_OFFLINE				-5

#define IMG_RASTER_LINE				0x00
#define IMG_RASTER_BLOCK			0x01
#define IMG_RASTER_GRADATION		0x02
#define IMG_BITIMG					0x10

//***************************************************************************
//  Name : fncGetDate
//***************************************************************************
void fncGetDate(char *o_staData)
{
	time_t timep;
    struct tm *time_inf;
    char staDate[32];

    time(&timep);

    time_inf = localtime(&timep);
    memset(staDate, 0x00, 32);
    sprintf(staDate,"%02d/%02d/%04d %02d:%02d", time_inf->tm_mon + 1, time_inf->tm_mday, time_inf->tm_year + 1900, time_inf->tm_hour, time_inf->tm_min);
    memcpy(o_staData, staDate, strlen(staDate));
    return;
}

//---------------------------------------------------------------------------
//  Name     : fncTestSample
//  Deteail  : TEST Sample
//  Argument :
//  Return   :
//---------------------------------------------------------------------------
void fncTestSample(void)
{
	char staGetChr[8];
	char staPort[8];
	char staDate[32];
	unsigned char rawGScmd[8];
	unsigned char rawGetData[128];

	int nmsRet;
	int nmsCnt;
	unsigned long nmuTimeout;
	unsigned long nmuTime;
	unsigned long nmuStatus;
	unsigned int nmuJob;
	unsigned int nmuGetJobID;
	unsigned int *pnmuID;

	char *staImgPath = "/home/nei/npi/img/PrintSample.bmp";
	IplImage *img = cvLoadImage("/home/nei/npi/img/PrintSample.bmp", CV_LOAD_IMAGE_ANYCOLOR | CV_LOAD_IMAGE_ANYDEPTH);


	printf("********** Test Sample in **********\n");
	while(1)
	{
		// 入力させる
		// Input
		memset(staGetChr, 0x00, 8);
		printf("*************************************\n");
		printf(" Do you \"Test Sample\" quit?(YES:y or Y / NO:n or N):");
		scanf("%s", staGetChr);
		fflush(stdin);

		// 終了
		// Exit
		if(strcmp(staGetChr, "Y") == 0 || strcmp(staGetChr, "y") == 0)
		{
			break;
		}

		memset(staPort, 0x00, 8);
		printf("*************************************\n");
		printf(" Please input port name(ex. PRT001):");
		scanf("%s", staPort);
		fflush(stdin);
		printf("*************************************\n");


		// ポートオープン
		// Port open
		nmsRet = NOpenPrinter(staPort, 1);
		printf(" NOpenPrinter           ReturnCode : %d\n", nmsRet);
		if(nmsRet != SUCCESS)
		{
			continue;
		}

		// print
		// 印刷
		while(1)
		{
			// 入力させる
			// Input
			memset(staGetChr, 0x00, 8);
			printf("*************************************\n");
			printf(" (S ro s): start the print operation / (E or e): end the print operation :");
			scanf("%s", staGetChr);
			fflush(stdin);
			printf("*************************************\n");

			// 印刷終了
			// end the print operation
			if(strcmp(staGetChr, "E") == 0 || strcmp(staGetChr, "e") == 0)
			{
				break;
			}

			// 年月日、時間取得
			// get a date
			memset(staDate, 0x00, 32);
			strcat(staDate, "\"DATE : ");
			fncGetDate(&staDate[strlen(staDate)]);
			strcat(staDate, "\"");

			// 状態確認
			// Printer satatus check
			nmsRet = NGetStatus(staPort, &nmuStatus);
			printf(" NGetStatus             ReturnCode : %d -> Status           : %02lX\n", nmsRet, nmuStatus);
			if(nmsRet != SUCCESS)
			{
				continue;
			}

			// 情報取得CMD発行
			// Information acquisition command output
			nmsRet = NPrint(staPort, "1b73021b73031b7304", strlen("1b73021b73031b7304"), &nmuJob);

			usleep(1000000);
			// Model name
			memset(rawGetData, 0x00, 128);
			nmsRet = NGetInformation(staPort, (unsigned char)0x02, rawGetData, &nmuTime);
			printf(" NGetInformation(ID:02) ReturnCode : %d -> Model Name       : %s\n", nmsRet, rawGetData);
			// Firmware version
			memset(rawGetData, 0x00, 128);
			nmsRet = NGetInformation(staPort, (unsigned char)0x03, rawGetData, &nmuTime);
			printf(" NGetInformation(ID:03) ReturnCode : %d -> Firmware Version : %s\n", nmsRet, rawGetData);
			// Boot version
			memset(rawGetData, 0x00, 128);
			nmsRet = NGetInformation(staPort, (unsigned char)0x04, rawGetData, &nmuTime);
			printf(" NGetInformation(ID:04) ReturnCode : %d -> Boot Version     : %s\n", nmsRet, rawGetData);

			//
			// データセット
			// Set data
			//

			// StartDoc
			nmuJob = 0;
			nmsRet = NStartDoc(staPort, &nmuJob);
			printf(" NStartDoc              ReturnCode : %d -> JOB ID : %d\n", nmsRet, nmuJob);
			if(nmsRet != SUCCESS)
			{
				continue;
			}


			// 印字開始CMD
			// In printing command
			nmsCnt = 0;
			memset(rawGScmd, 0x00, 8);
			rawGScmd[nmsCnt++] = 0x1d;
			rawGScmd[nmsCnt++] = 0x47;
			rawGScmd[nmsCnt++] = 0x11;
			memcpy((unsigned long*)&rawGScmd[nmsCnt], &nmuJob, 4);
			nmsCnt+=4;
			nmsRet = NDPrint(staPort, rawGScmd, nmsCnt, NULL);

			// 文字データ
			// other data
			nmsRet = NPrint(staPort, "1b61011b2130", strlen("1b61011b2130"), NULL);
			nmsRet = NPrint(staPort, "\"PRIMEX\"0a", strlen("\"PRIMEX\"0a"), NULL);
			nmsRet = NPrint(staPort, "1b2100", strlen("1b2100"), NULL);
			nmsRet = NPrint(staPort, "\"---- demo ----\"0a", strlen("\"---- demo ----\"0a"), NULL);
			nmsRet = NPrint(staPort, "1b6100", strlen("1b6100"), NULL);

			nmsRet = NPrint(staPort, "\"1-5-12, Unoki, Ohtaku, Tokyo\"0a", strlen("\"1-5-12, Unoki, Ohtaku, Tokyo\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"146-8650 Japan\"0a", strlen("\"146-8650 Japan\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"TEL    : 81-3-3750-5817\"0a", strlen("\"TEL    : 81-3-3750-5817\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"E-Mail : overseas@primex.co.jp\"0a", strlen("\"E-Mail : overseas@primex.co.jp\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"********************************\"0a", strlen("\"********************************\"0a"), NULL);
			nmsRet = NPrint(staPort, "1b6101", strlen("1b6101"), NULL);
			nmsRet = NPrint(staPort, "\"Tank you for\"0a", strlen("\"Tank you for\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"the coming to the store.\"0a", strlen("\"the coming to the store.\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"I rest and do business\"0a", strlen("\"I rest and do business\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"this month.\"0a", strlen("\"this month.\"0a"), NULL);
			nmsRet = NPrint(staPort, "1b6100", strlen("1b6100"), NULL);
			nmsRet = NPrint(staPort, "\"********************************\"0a", strlen("\"********************************\"0a"), NULL);
			nmsRet = NPrint(staPort, staDate, strlen(staDate), NULL);
			nmsRet = NPrint(staPort, "0a", strlen("0a"), NULL);
			nmsRet = NPrint(staPort, "\"Charge : Primex\"0a0a", strlen("\"Charge : Primex\"0a0a"), NULL);
			nmsRet = NPrint(staPort, "\"Coke\"0a", strlen("\"Coke\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"    $ 2.00 * 3            $ 6.00\"0a", strlen("\"    $ 2.00 * 3            $ 6.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"Apple juice\"0a", strlen("\"Apple juice\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"    $ 2.00 * 1            $ 2.00\"0a", strlen("\"    $ 2.00 * 1            $ 2.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"Budweiser\"0a", strlen("\"Budweiser\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"    $ 5.00 * 1            $ 5.00\"0a", strlen("\"    $ 5.00 * 1            $ 5.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"Whisky\"0a", strlen("\"Whisky\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"   $ 10.00 * 1           $ 10.00\"0a", strlen("\"   $ 10.00 * 1           $ 10.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"--------------------------------\"0a", strlen("\"--------------------------------\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"TOTAL                 USD  23.00\"0a", strlen("\"TOTAL                 USD  23.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"--------------------------------\"0a", strlen("\"--------------------------------\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"Deposit               USD  30.00\"0a", strlen("\"Deposit               USD  30.00\"0a"), NULL);
			nmsRet = NPrint(staPort, "\"Change                USD   7.00\"0a0a", strlen("\"Change                USD   7.00\"0a0a"), NULL);
			// Barcode
			nmsRet = NPrint(staPort, "1b61011d4802", strlen("1b61011d4802"), NULL);
			// CODE39
			nmsRet = NPrint(staPort, "1d6b04\"*12345*\"000a", strlen("1d6b04\"*12345*\"000a"), NULL);
			// バーコード(設定値解除)
			// Barcode(Setting release)
			nmsRet = NPrint(staPort, "1d48001b6100", strlen("1d48001b6100"), NULL);
			nmsRet = NPrint(staPort, "\"http://www.prmex.co.jp/npiweb/index_e.jsp\"0a", strlen("\"http://www.prmex.co.jp/npiweb/index_e.jsp\"0a"), NULL);
			// 文字データ(Feed&Cut)
			// Feed / Cut command
			nmsRet = NPrint(staPort, "1b4aff1b69", strlen("1b4aff1b69"), NULL);

			// Raster image data
			nmsRet = NImagePrintF(staPort, staImgPath, IMG_RASTER_BLOCK, NULL);
			// 文字データ(Feed&Cut)
			// Feed / Cut command
			nmsRet = NPrint(staPort, "1b4aff1b69", strlen("1b4aff1b69"), NULL);

			// Raster image data
			nmsRet = NImagePrint(staPort, img, img->width, img->height, IMG_RASTER_BLOCK, NULL);
			// 文字データ(Feed&Cut)
			// Feed / Cut command
			nmsRet = NPrint(staPort, "1b4aff1b69", strlen("1b4aff1b69"), NULL);

//			// Binary Data
//			nmsRet = NPrint(staPort, "</home/nei/test.bin>", strlen("</home/nei/test.bin>"), NULL);

			// 印字終了CMD
			// Out printing command
			nmsRet = NPrint(staPort, "1d4710", strlen("1d4710"), NULL);

			// EndDoc
			nmsRet = NEndDoc(staPort);
			printf(" NEndDoc                ReturnCode : %d\n", nmsRet);
			if(nmsRet != SUCCESS)
			{
				nmsRet = NCancelDoc(staPort);
				printf(" NCancelDoc             ReturnCode : %d\n", nmsRet);
				continue;
			}

			// 転送完了確認
			// It waits until forwarding is completed.
			nmuGetJobID = 0;
			nmuTimeout = cputime();
			while(nmuGetJobID != nmuJob)
			{
				memset(rawGetData, 0x00, 128);
				nmsRet = NGetInformation(staPort, (unsigned char)25, rawGetData, &nmuTime);
				pnmuID = (unsigned int*)&rawGetData;
				nmuGetJobID = *pnmuID;

				if(cputime() > (nmuTimeout+5000))
				{
					printf(" Print Error(ID:25)\n");
					break;
				}
			}
			printf(" ID:25 GetJobID:%d\n", nmuGetJobID);
			if(nmuGetJobID == nmuJob)
			{
				// 印刷完了待ち
				// It waits until printing is completed.
				nmuGetJobID = 0;
				nmuTimeout = cputime();
				while(nmuGetJobID != nmuJob)
				{
					memset(rawGetData, 0x00, 128);
					nmsRet = NGetInformation(staPort, (unsigned char)19, rawGetData, &nmuTime);
					pnmuID = (unsigned int*)&rawGetData;
					nmuGetJobID = *pnmuID;

					if(cputime() > (nmuTimeout+5000))
					{
						printf(" Print Error(ID:19)\n");
						break;
					}
				}
				if(nmuGetJobID == nmuJob)
				{
					printf(" ID:19 GetJobID:%d\n", nmuGetJobID);
					printf(" Print Success\n");
				}
			}
		}

		// ポートクローズ
		// port close
		nmsRet = NClosePrinter(staPort);
		printf(" NClosePrinter          ReturnCode : %d\n", nmsRet);

	}
	printf("********** Test Sample out **********\n");

	cvReleaseImage(&img);

	return;
}

//***************************************************************************
//  Name : main
//***************************************************************************
int main(void)
{
//	int fp;
//	struct termios newtio;

	int nmsRet;
	char staSelect[8];
	char *pPrinters;
	unsigned int nmuSize;
	unsigned int nmuDummy;


	printf("---------- libNPrint.so Test Sample Start ----------\n");
	while(1)
	{
		// 入力させる
		// Input
		memset(staSelect, 0x00, 8);
		printf("Please select( (A or a):NEnumPrinters / (B or b):Test Sample / Other:quit ):");
		scanf("%s", staSelect);
		fflush(stdin);

		if(strcmp(staSelect, "A") == 0 || strcmp(staSelect, "a") == 0)
		{
			nmuSize = 0;
			nmsRet = NEnumPrinters(NULL, &nmuSize);
			printf("NEnumPrinters(ret:%d)\n", nmsRet);
			if(nmuSize != 0)
			{
				pPrinters = (char*)malloc(sizeof(char)*(nmuSize+1));
				memset(pPrinters, 0x00, sizeof(char)*(nmuSize+1));
				NEnumPrinters(pPrinters, &nmuDummy);
				printf("%s\n", pPrinters);
				free(pPrinters);
			}
		}
		else if(strcmp(staSelect, "B") == 0 || strcmp(staSelect, "b") == 0)
		{
//			// COM baud rate set
//			fp = -1;
//			fp = open("/dev/ttyS0",  O_RDWR | O_NOCTTY);
//			if((int)fp < 0)
//			{
//				printf("open error\n");
//			}
//			else
//			{
//				// ポートの設定の構造体をクリア
//				bzero(&newtio, sizeof(newtio));
//				// 現在のシリアルポートの設定取得
//				tcgetattr((int)fp, &newtio);
//				// ボーレート通信速度設定
//				cfsetspeed(&newtio, B115200);
//				// ポートのクリア
//				tcflush((int)fp, TCIFLUSH);
//				// 新しいポートの設定を有効にする
//				tcsetattr((int)fp, TCSANOW, &newtio);
//
//				printf("open success\n");
//				close(fp);
//				fp = -1;
//			}
			fncTestSample();
		}
		else
		{
			break;	// Exit
		}
	}
	printf("---------- libNPrint.so Test Sample End ----------\n");
	return EXIT_SUCCESS;
}

